/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.labelPattern;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.help.HelpDialog;
import net.sf.jabref.labelPattern.LabelPattern;

public class LabelPatternPanel
extends JPanel {
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints con = new GridBagConstraints();
    private HelpAction help;
    private JButton btnDefaultAll;
    private JButton btnDefault;
    private JLabel lblEntryType;
    private JLabel lblKeyPattern;
    protected JTextField defaultPat = new JTextField();
    private HashMap<String, JTextField> textFields = new HashMap();

    public LabelPatternPanel(HelpDialog helpDiag) {
        this.help = new HelpAction(helpDiag, "LabelPatterns.html", "Help on key patterns");
        this.buildGUI();
    }

    private void buildGUI() {
        JPanel pan = new JPanel();
        JScrollPane sp = new JScrollPane(pan);
        sp.setPreferredSize(new Dimension(100, 100));
        sp.setBorder(BorderFactory.createEmptyBorder());
        pan.setLayout(this.gbl);
        this.setLayout(this.gbl);
        this.lblEntryType = new JLabel(Globals.lang("Entry type"));
        Font f = new Font("plain", 1, 12);
        this.lblEntryType.setFont(f);
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.fill = 3;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 0);
        this.gbl.setConstraints(this.lblEntryType, this.con);
        pan.add(this.lblEntryType);
        this.lblKeyPattern = new JLabel(Globals.lang("Key pattern"));
        this.lblKeyPattern.setFont(f);
        this.con.gridx = 1;
        this.con.gridy = 0;
        this.con.gridheight = 1;
        this.con.fill = 2;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 5);
        this.gbl.setConstraints(this.lblKeyPattern, this.con);
        pan.add(this.lblKeyPattern);
        this.con.gridy = 1;
        this.con.gridx = 0;
        JLabel lab = new JLabel(Globals.lang("Default pattern"));
        this.gbl.setConstraints(lab, this.con);
        pan.add(lab);
        this.con.gridx = 1;
        this.gbl.setConstraints(this.defaultPat, this.con);
        pan.add(this.defaultPat);
        this.con.insets = new Insets(5, 5, 10, 5);
        this.btnDefault = new JButton(Globals.lang("Default"));
        this.btnDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LabelPatternPanel.this.defaultPat.setText((String)Globals.prefs.defaults.get("defaultLabelPattern"));
            }
        });
        this.con.gridx = 2;
        int y = 2;
        this.gbl.setConstraints(this.btnDefault, this.con);
        pan.add(this.btnDefault);
        for (String s : BibtexEntryType.ALL_TYPES.keySet()) {
            this.textFields.put(s, this.addEntryType(pan, s, y));
            ++y;
        }
        this.con.fill = 1;
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.gridwidth = 3;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.gbl.setConstraints(sp, this.con);
        this.add(sp);
        this.con.gridwidth = 1;
        this.con.gridx = 1;
        this.con.gridy = 2;
        this.con.fill = 2;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(0, 5, 0, 5);
        JButton hlb = new JButton(GUIGlobals.getImage("helpSmall"));
        hlb.setToolTipText(Globals.lang("Help on key patterns"));
        this.gbl.setConstraints(hlb, this.con);
        this.add(hlb);
        hlb.addActionListener(this.help);
        this.btnDefaultAll = new JButton(Globals.lang("Reset all"));
        this.con.gridx = 2;
        this.con.gridy = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(20, 5, 0, 5);
        this.gbl.setConstraints(this.btnDefaultAll, this.con);
        this.btnDefaultAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (String s : LabelPatternPanel.this.textFields.keySet()) {
                    JTextField tf = (JTextField)LabelPatternPanel.this.textFields.get(s);
                    tf.setText("");
                }
                LabelPatternPanel.this.defaultPat.setText((String)Globals.prefs.defaults.get("defaultLabelPattern"));
            }
        });
        this.add(this.btnDefaultAll);
    }

    private JTextField addEntryType(Container c, String name, int y) {
        JLabel lab = new JLabel(Util.nCase(name));
        name = name.toLowerCase();
        this.con.gridx = 0;
        this.con.gridy = y;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 17;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(lab, this.con);
        c.add(lab);
        JTextField tf = new JTextField();
        tf.setColumns(15);
        this.con.gridx = 1;
        this.con.fill = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(tf, this.con);
        c.add(tf);
        JButton but = new JButton(Globals.lang("Default"));
        this.con.gridx = 2;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(but, this.con);
        but.setActionCommand(name);
        but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField tf = (JTextField)LabelPatternPanel.this.textFields.get(e.getActionCommand());
                tf.setText("");
            }
        });
        c.add(but);
        return tf;
    }

    public LabelPattern getLabelPattern() {
        LabelPattern keypatterns = new LabelPattern();
        for (String s : this.textFields.keySet()) {
            String text = this.textFields.get(s).getText();
            if ("".equals(text.trim())) continue;
            keypatterns.addLabelPattern(s, text);
        }
        String text = this.defaultPat.getText();
        if (!"".equals(text.trim())) {
            keypatterns.setDefaultValue(text);
        }
        return keypatterns;
    }

    public void setValues(LabelPattern keypatterns) {
        for (String name : this.textFields.keySet()) {
            JTextField tf = this.textFields.get(name);
            this.setValue(tf, name, keypatterns);
        }
        if (keypatterns.getDefaultValue() == null) {
            this.defaultPat.setText("");
        } else {
            this.defaultPat.setText(keypatterns.getDefaultValue().get(0));
        }
    }

    private void setValue(JTextField tf, String fieldName, LabelPattern keypatterns) {
        if (keypatterns.isDefaultValue(fieldName)) {
            tf.setText("");
        } else {
            tf.setText(keypatterns.getValue(fieldName).get(0).toString());
        }
    }
}

