/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class JMapTable
extends JTable {
    private boolean editable = true;
    private Vector items = new Vector();
    private MapModel theModel = new MapModel();
    private Color oddColor;

    public JMapTable() {
        SystemColor c = SystemColor.textHighlight;
        this.oddColor = new Color(0, 0, 64, 16);
        super.setModel(this.theModel);
        super.setRowSelectionAllowed(false);
    }

    public JMapTable(String nameLabel, String valueLabel) {
        this();
        this.setHeaderNames(nameLabel, valueLabel);
    }

    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int colIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, colIndex);
        if (rowIndex % 2 == 1 && !this.isCellSelected(rowIndex, colIndex)) {
            c.setBackground(this.oddColor);
        } else {
            c.setBackground(this.getBackground());
        }
        c.setForeground(SystemColor.textText);
        return c;
    }

    public void setCellEditable(boolean editable) {
        this.editable = editable;
    }

    public void setHeaderNames(String nameLabel, String valueLabel) {
        this.theModel = new MapModel();
        this.theModel.colNames[0] = nameLabel;
        this.theModel.colNames[1] = valueLabel;
        super.setModel(this.theModel);
    }

    public void clear() {
        this.items.clear();
    }

    public Map getMap() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        HashMap theMap = new HashMap();
        for (int i = 0; i < this.items.size(); ++i) {
            Map.Entry item = (Map.Entry)this.items.get(i);
            if (item.getKey().toString().equals("")) continue;
            theMap.put(item.getKey(), item.getValue());
        }
        return theMap;
    }

    public void putAll(Map theMap) {
        Iterator it = theMap.entrySet().iterator();
        while (it.hasNext()) {
            this.items.add(it.next());
        }
    }

    public void put(Object key, Object value) {
        this.items.add(new Entry(key, value));
    }

    class Entry
    implements Map.Entry {
        Object key;
        Object value;

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object other) {
            return this.key.equals(((Entry)other).key);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object parm1) {
            this.value = parm1;
            return this;
        }
    }

    class MapModel
    extends AbstractTableModel {
        public String[] colNames = new String[]{"Name", "Value"};

        MapModel() {
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return JMapTable.this.editable;
        }

        public String getColumnName(int col) {
            return this.colNames[col];
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return JMapTable.this.items.size() + 1;
        }

        public Object getValueAt(int row, int col) {
            if (row >= JMapTable.this.items.size()) {
                return "";
            }
            Map.Entry item = (Map.Entry)JMapTable.this.items.get(row);
            return col == 0 ? item.getKey() : item.getValue();
        }

        public void setValueAt(Object aValue, int row, int col) {
            if (row >= JMapTable.this.items.size()) {
                Entry item = col == 0 ? new Entry(aValue, "") : new Entry("", aValue);
                JMapTable.this.items.add(item);
            } else {
                Map.Entry oldItem = (Map.Entry)JMapTable.this.items.get(row);
                Entry item = col == 0 ? new Entry(aValue, oldItem.getValue()) : new Entry(oldItem.getKey(), aValue);
                JMapTable.this.items.set(row, item);
            }
        }
    }
}

