/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.tags.XMLDocument;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.IO;

public class AccountManager {
    private static final File ACCOUNTS_FILE = new File(System.getProperty("user.home"), ".jalbum-ftp-accounts.xml");
    private static AccountManager instance;
    private DefaultListModel accounts = new DefaultListModel();

    private AccountManager() {
    }

    public static AccountManager getInstance() {
        if (instance == null) {
            instance = new AccountManager();
        }
        return instance;
    }

    public void addAccount(AccountProfile newAccount) {
        Vector<String> names = new Vector<String>();
        Enumeration e = this.accounts.elements();
        while (e.hasMoreElements()) {
            AccountProfile account = (AccountProfile)e.nextElement();
            names.add(account.getName());
        }
        newAccount.setName(this.uniqueName(newAccount.getName(), names));
        this.accounts.addElement(newAccount);
    }

    public void removeAccount(AccountProfile oldAccount) {
        this.accounts.removeElement(oldAccount);
    }

    public boolean hasAccounts() {
        return !this.accounts.isEmpty();
    }

    public void resetAccounts() {
        this.accounts.removeAllElements();
    }

    public void loadAccounts() throws ElementException, IOException {
        Element ae;
        String doc;
        if (!ACCOUNTS_FILE.exists()) {
            return;
        }
        String rest = doc = IO.readTextFile(ACCOUNTS_FILE);
        while ((ae = Elements.getElementByName("account", rest, false)) != null) {
            AccountProfile a = new AccountProfile();
            BeanBinder.setProperties((Object)a, ae.getAttributes());
            this.accounts.addElement(a);
            rest = ae.getPostElement();
        }
    }

    public AccountProfile getFirstMyjalbumAccount() {
        Enumeration e = this.accounts.elements();
        while (e.hasMoreElements()) {
            AccountProfile account = (AccountProfile)e.nextElement();
            if (!account.isMyjalbum()) continue;
            return account;
        }
        return null;
    }

    private String uniqueName(String name, AbstractCollection names) {
        if (names.contains(name)) {
            int i;
            for (i = name.length() - 1; i >= 0 && Character.isDigit(name.charAt(i)); --i) {
            }
            String base = name.substring(0, i + 1);
            i = 1;
            while (names.contains(name = base + i)) {
                ++i;
            }
        }
        return name;
    }

    public void saveAccounts() throws IOException, Exception {
        FileWriter out = new FileWriter(ACCOUNTS_FILE);
        Element ftpAccounts = new Element("ftp-accounts");
        Enumeration e = this.accounts.elements();
        while (e.hasMoreElements()) {
            AccountProfile account = (AccountProfile)e.nextElement();
            Element el = new Element("account");
            el.setAttributes(BeanBinder.getProperties(account));
            ftpAccounts.addContentElement(el);
        }
        XMLDocument doc = new XMLDocument(ftpAccounts);
        out.write(doc.toString());
        out.close();
    }

    public DefaultListModel getAccounts() {
        return this.accounts;
    }
}

