/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumUtils;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.UploadListener;
import se.datadosen.util.BeanBinder;

public class JAlbumConsole
implements AlbumBeanListener,
UploadListener {
    AlbumBean engine = new AlbumBean();
    UploadBean uploadBean = new UploadBean();

    public JAlbumConsole(Properties props) throws Exception {
        this.engine.addAlbumBeanListener(this);
        System.out.println(Msg.get("console.startupInfo", "8.0.9"));
        if (props.containsKey("help") || props.containsKey("?")) {
            Properties defs = BeanBinder.getProperties((Object)this.engine, true);
            BeanBinder.getProperties((Object)this.uploadBean, defs);
            defs.setProperty("projectFile", "");
            defs.setProperty("programDirectory", Config.getConfig().progDir.toString());
            defs.setProperty("skinsDirectory", Config.getConfig().skinsDir.toString());
            defs.setProperty("runTool", "");
            defs.setProperty("uploadAll", "");
            defs.setProperty("smartUpload", "");
            System.out.println("\n" + Msg.getString("console.helpInfo"));
            for (Map.Entry<Object, Object> e : defs.entrySet()) {
                if (e.getKey().equals("class") || e.getKey().equals("userVariables") || e.getKey().equals("skinVariables")) continue;
                System.out.println("-" + e.getKey() + " " + e.getValue());
            }
            System.out.println(Msg.getString("console.userVariableInfo"));
            System.out.println(Msg.getString("console.requiredArgumentsInfo"));
            return;
        }
        if (props.containsKey("projectFile")) {
            Properties fileProps = new Properties();
            FileInputStream fis = new FileInputStream(props.getProperty("projectFile"));
            fileProps.load(fis);
            fis.close();
            fileProps.putAll((Map<?, ?>)props);
            props = fileProps;
        }
        BeanBinder.setProperties((Object)this.engine, props);
        this.engine.setSkinVariables(AlbumUtils.getSkinVariables(props));
        this.engine.setUserVariables(AlbumUtils.getUserVariables(props));
        String toolName = props.getProperty("runTool");
        if (toolName != null) {
            this.engine.init();
            this.engine.processBeanShellFile(new File(toolName));
        } else if (props.containsKey("uploadAll")) {
            BeanBinder.setProperties((Object)this.uploadBean, props);
            this.uploadAlbum(true);
        } else if (props.containsKey("smartUpload")) {
            BeanBinder.setProperties((Object)this.uploadBean, props);
            this.uploadAlbum(false);
        } else {
            this.engine.makeAlbum();
            System.out.println(Msg.getString("console.albumCreationInfo") + " " + this.engine.getOutputDirectory());
        }
    }

    public static void main(String[] args) throws Exception {
        Properties commandLineProperties = BeanBinder.parseArgsOptions(args);
        new JAlbumConsole(commandLineProperties);
    }

    private void uploadAlbum(boolean fullUpdate) throws Exception {
        this.uploadBean.addUploadListener(this);
        this.uploadBean.connect();
        this.uploadBean.uploadAlbum(this.engine, fullUpdate);
    }

    public void imageProcessingStarted(AlbumBeanEvent e) {
        if (e.imageNum == 0) {
            System.out.println("\n" + Msg.get("console.processingInfo", e.directory, this.engine.getOutputDirectory()));
            System.out.println(e.msg);
        } else {
            System.out.print(Msg.getString("console.FileInfo") + " " + e.msg + " (" + e.processedFiles + "/" + e.totalFiles + ") ");
        }
    }

    public void imageProcessingFinished(AlbumBeanEvent e) {
        System.out.println(Msg.getString("console.processingDoneInfo"));
    }

    public void errorOccured(Throwable t, File f) {
        System.err.println(Msg.get("console.errorProcessingInfo", f, t.toString()));
    }

    public void bytesTransferred(long count) {
        System.out.print(".");
    }
}

