/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import se.datadosen.component.JDirectoryChooser;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.DeferredChooser;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;

public class JNewProjectDialog
extends JSmartDialog {
    private JLabel info = new JLabel(Msg.get("newproject.info"));
    private JLabel albumNameLabel = new JLabel(Msg.get("newproject.albumNameLabel"));
    private JTextField albumName = new JSmartTextField(20);
    private JLabel albumLocationLabel = new JLabel(Msg.get("newproject.albumLocationLabel"));
    private JTextField albumLocation = new JTextField(20);
    private JButton browseButton = new JButton();
    private DeferredChooser albumLocationChooser = new DeferredChooser(JDirectoryChooser.class);
    private List files;
    Action okAction;
    Action cancelAction;

    public JNewProjectDialog(Frame parent) {
        super(parent, Msg.get("newproject.title"), true);
        this.initComponents();
    }

    public void setAlbumName(String albumName) {
        this.albumName.setText(albumName);
        this.fixUIDisabling();
    }

    public void setFiles(List files) {
        this.files = files;
    }

    private File getAlbumDirectory() {
        return new File(this.albumLocation.getText() + File.separator + this.albumName.getText().trim()).getAbsoluteFile();
    }

    private void initComponents() {
        this.albumLocation.setEditable(false);
        this.albumLocation.setEnabled(false);
        this.albumLocation.setFocusable(false);
        File myAlbums = new File(((JAlbumFrame)this.getOwner()).preferencesWindow.myAlbumsLocation.getText());
        this.albumLocationChooser.setSelectedFile(myAlbums);
        this.albumLocation.setText(myAlbums.getAbsolutePath());
        this.okAction = new AbstractAction(Msg.get("ok")){

            public void actionPerformed(ActionEvent e) {
                File albumDirectory = JNewProjectDialog.this.getAlbumDirectory();
                if (!albumDirectory.exists()) {
                    albumDirectory.mkdirs();
                } else if (albumDirectory.listFiles().length > 0) {
                    JOptionPane.showMessageDialog(JNewProjectDialog.this, Msg.get("newProject.projectAlreadyExistsError", JNewProjectDialog.this.albumName.getText().trim()), Msg.get("newproject.title"), 0);
                    return;
                }
                JNewProjectDialog.this.setVisible(false);
                JNewProjectDialog.this.dispose();
                ((JAlbumFrame)JNewProjectDialog.this.getOwner()).initProject(JNewProjectDialog.this.getAlbumDirectory());
                ((JAlbumFrame)JNewProjectDialog.this.getOwner()).saveProject(new File(JNewProjectDialog.this.getAlbumDirectory(), "jalbum-settings.jap"));
                if (JNewProjectDialog.this.files != null && JNewProjectDialog.this.files.size() > 0) {
                    JAlbum.mainFrame.albumExplorer.explorer.handleFileAdd(JNewProjectDialog.this.files);
                }
            }
        };
        this.cancelAction = new AbstractAction(Msg.get("cancel")){

            public void actionPerformed(ActionEvent e) {
                JNewProjectDialog.this.setVisible(false);
                JNewProjectDialog.this.dispose();
            }
        };
        this.initEventListeners();
        this.albumNameLabel.setLabelFor(this.albumName);
        this.albumLocationLabel.setLabelFor(this.albumLocation);
        this.browseButton.setIcon(JAlbum.mainFrame.icons.openIcon);
        Container content = this.getContentPane();
        content.setLayout(new RiverLayout());
        content.add("br", this.info);
        content.add("p", this.albumNameLabel);
        content.add("tab hfill", this.albumName);
        content.add("br", this.albumLocationLabel);
        content.add("tab hfill", this.albumLocation);
        content.add(this.browseButton);
        this.registerActions(this.okAction, this.cancelAction);
        this.fixUIDisabling();
    }

    private void fixUIDisabling() {
        this.okAction.setEnabled(this.albumName.getText().trim().length() > 0);
    }

    private void initEventListeners() {
        this.albumName.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                JNewProjectDialog.this.fixUIDisabling();
            }
        });
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JNewProjectDialog.this.albumLocationChooser.showOpenDialog(JNewProjectDialog.this);
            }
        });
        this.albumLocationChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ApproveSelection")) {
                    JNewProjectDialog.this.albumLocation.setText(JNewProjectDialog.this.albumLocationChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
    }
}

