/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JButton;
import se.datadosen.jalbum.JAlbum;

class JToolBarButton
extends JButton {
    private boolean showLabel = true;
    private Action action;

    public JToolBarButton() {
        this.init();
    }

    public JToolBarButton(Action action) {
        super(action);
        this.action = action;
        this.init();
    }

    public JToolBarButton(Action action, boolean showLabel) {
        super(action);
        this.action = action;
        this.showLabel = showLabel;
        this.init();
    }

    private void init() {
        if (JAlbum.isMac()) {
            this.setFocusable(false);
            this.putClientProperty("JComponent.sizeVariant", "regular");
            this.putClientProperty("JButton.buttonType", "segmentedTextured");
            this.putClientProperty("JButton.segmentPosition", "only");
            this.setFont(this.getFont().deriveFont(0, 11.0f));
        } else {
            this.setMargin(new Insets(1, 2, 1, 3));
        }
        if (this.action != null) {
            this.setText((String)this.action.getValue("Name"));
        }
    }

    public void setText(String text) {
        if (this.showLabel) {
            super.setText(text);
        } else {
            this.setToolTipText(text);
        }
    }
}

