/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.jalbum.filterManager.JAlbumImageFilterInterface;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FilterPluginList;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.util.IO;

class PluginManager {
    private static final String PLUGIN_POSTFIX = "Plugin.class";

    PluginManager() {
    }

    static void loadPlugins() {
        File[] jars;
        PluginManager.loadPlugins(Config.getConfig().pluginsDir, "");
        File extDir = new File(Config.getConfig().progDir, "ext");
        for (File jar : jars = PluginManager.buildFileList(extDir)) {
            PluginManager.loadPlugins(jar);
        }
        FilterPluginList.getInstance().sort();
    }

    private static final File[] buildFileList(File dir) {
        Object[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                String s = f.getName().toLowerCase();
                return s.endsWith(".jar") || s.endsWith(".zip");
            }
        });
        if (files == null) {
            files = new File[]{};
        }
        Arrays.sort(files);
        return files;
    }

    private static void loadPlugins(File jarFile) {
        try {
            ZipFile zf = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> files = zf.entries();
            while (files.hasMoreElements()) {
                ZipEntry e = files.nextElement();
                if (!e.getName().endsWith(PLUGIN_POSTFIX)) continue;
                String s = e.getName();
                String className = s.substring(0, s.length() - 6).replace('/', '.');
                PluginManager.initPlugin(className);
            }
        }
        catch (ZipException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void loadPlugins(File dir, String javaPackage) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                PluginManager.loadPlugins(f, javaPackage.length() == 0 ? f.getName() : javaPackage + "." + f.getName());
                continue;
            }
            if (!f.getName().endsWith(PLUGIN_POSTFIX)) continue;
            String className = javaPackage.length() == 0 ? IO.baseName(f) : javaPackage + "." + IO.baseName(f);
            PluginManager.initPlugin(className);
        }
    }

    private static void initPlugin(String className) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> c = cl.loadClass(className);
            if (PluginManager.isPlugin(c)) {
                Object o = c.newInstance();
                Method method = c.getMethod("init", new Class[0]);
                method.invoke(o, new Object[0]);
            }
            if (PluginManager.isImageFilter(c)) {
                FilterPluginList.getInstance().addFilterClass(className);
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    private static boolean isPlugin(Class c) {
        while (c != null) {
            for (Class<?> in : c.getInterfaces()) {
                if (!in.equals(JAlbumPlugin.class)) continue;
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }

    private static boolean isImageFilter(Class c) {
        while (c != null) {
            for (Class<?> in : c.getInterfaces()) {
                if (!in.equals(JAlbumImageFilterInterface.class)) continue;
                return true;
            }
            c = c.getSuperclass();
        }
        return false;
    }
}

