/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import java.awt.Dimension;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectImpl;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.util.RotationSupport;

public class ThumbnailFileView
extends FileView {
    private File lastFile;
    private AlbumObject lastAlbumObject;
    private final AlbumObjectFactory factory;
    private FileSystemView fsv = FileSystemView.getFileSystemView();
    private Dimension thumbDim = JAlbum.isMac() ? new Dimension(24, 24) : new Dimension(42, 42);

    public ThumbnailFileView() {
        this.factory = new AlbumObjectFactory(JAlbumContext.getEngine());
        this.factory.setCacheThumbnails(false);
    }

    public Icon getIcon(File f) {
        if (f.isDirectory() || this.fsv.isDrive(f) || this.fsv.isComputerNode(f)) {
            return super.getIcon(f);
        }
        Icon icon = this.getThumbnail(f);
        if (icon != null) {
            return icon;
        }
        return super.getIcon(f);
    }

    private Icon getThumbnail(File f) {
        try {
            Metadata imageInfo = JpegMetadataReader.readMetadata((File)f);
            if (imageInfo.containsDirectory(ExifDirectory.class)) {
                Directory dir = imageInfo.getDirectory(ExifDirectory.class);
                byte[] rawImage = (byte[])dir.getObject(61441);
                ImageIcon ii = new ImageIcon(rawImage);
                return RotationSupport.adjustOrientation(AlbumObjectImpl.scaleToFit(ii, this.thumbDim, false), f);
            }
        }
        catch (JpegProcessingException ex) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Boolean isTraversable(File f) {
        return f.isDirectory();
    }

    private AlbumObject getAlbumObject(File f) {
        if (f.equals(this.lastFile)) {
            return this.lastAlbumObject;
        }
        this.lastAlbumObject = this.factory.createInstance(f);
        this.lastFile = f;
        return this.lastAlbumObject;
    }
}

