/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.UploadFileFilter;
import se.datadosen.jalbum.UploadListener;
import se.datadosen.util.IO;

public class UploadBean
implements RemoteFSProgressMonitor {
    private static final String TIME_DIFF_TEST_NAME = "timedifftester";
    private transient Vector uploadListeners;
    private RemoteFSBean remoteFSBean = new RemoteFSBean();
    private int processedFiles;
    private int totalFiles;
    private AlbumBean engine;
    private String remoteDirectory = "album";
    private String baseDirectory = "";
    private String ftpServer = "";
    private String ftpUser = "";
    private String ftpPassword = "";
    private boolean ftpForceUTF8 = false;
    private boolean secureFtp = false;
    private boolean passiveMode = true;
    private int ftpPort = 21;
    private long timeDifference = 0L;

    public static void showErrorDialog(Component owner, RemoteFSException ex, String messagePrefix, String title) {
        String message = messagePrefix != null ? messagePrefix + ": " : "";
        message = message + (ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
        JOptionPane.showMessageDialog(owner, message, title, 0);
    }

    protected void finalize() throws Throwable {
        if (this.remoteFSBean.isConnected()) {
            this.remoteFSBean.disconnect();
        }
    }

    public RemoteFSBean getRemoteFSBean() {
        return this.remoteFSBean;
    }

    private void deleteDirectory2(String remotePath) throws RemoteFSException, IOException {
        this.remoteFSBean.setDirectory(remotePath);
        String relativeRemotePath = this.toRelative(remotePath);
        RemoteFile[] files = this.remoteFSBean.getFiles(RemoteFSBean.noDotDotDotFileFilter);
        for (int i = 0; i < files.length; ++i) {
            AlbumBeanEvent eventObject = new AlbumBeanEvent(this, relativeRemotePath, files[i].getName(), 0, 1, 0, 1);
            this.fireImageProcessingStarted(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            String fullPath = IO.combinePaths(remotePath, files[i].getName());
            if (files[i].isDirectory()) {
                this.deleteDirectory2(fullPath);
            } else {
                this.remoteFSBean.removeFile(fullPath);
            }
            this.fireImageProcessingFinished(eventObject);
        }
        this.remoteFSBean.toParentDirectory();
        this.remoteFSBean.removeDirectory(remotePath);
    }

    public void deleteDirectory(String remoteDir) throws ParameterException, RemoteFSException, IOException {
        if (remoteDir.length() == 0) {
            throw new ParameterException("Cannot delete ftp root (security)");
        }
        this.deleteDirectory2(this.toAbsolute(remoteDir));
    }

    public void setFtpServer(String newFtpServer) {
        this.ftpServer = newFtpServer.trim();
        int colonIndex = this.ftpServer.indexOf("://");
        if (colonIndex != -1) {
            this.ftpServer = this.ftpServer.substring(colonIndex + 3);
        }
    }

    public String getFtpServer() {
        return this.ftpServer;
    }

    public void setFtpPort(int newFtpPort) throws RemoteFSException {
        this.ftpPort = newFtpPort;
    }

    public int getFtpPort() throws RemoteFSException {
        return this.ftpPort;
    }

    public void setFtpUser(String newFtpUser) {
        this.ftpUser = newFtpUser.trim();
    }

    public String getFtpUser() {
        return this.ftpUser;
    }

    public void setFtpPassword(String newFtpPassword) {
        this.ftpPassword = newFtpPassword.trim();
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public void setRemoteDirectory(String newRemoteDirectory) {
        this.remoteDirectory = newRemoteDirectory.trim();
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public boolean isFtpForceUTF8() throws RemoteFSException {
        return this.ftpForceUTF8;
    }

    public void setFtpForceUTF8(boolean force) throws RemoteFSException {
        this.ftpForceUTF8 = force;
    }

    public void setSecureFtp(boolean newSecureFtp) {
        this.secureFtp = newSecureFtp;
    }

    public boolean isSecureFtp() {
        return this.secureFtp;
    }

    public void setPassiveMode(boolean newPassiveMode) throws RemoteFSException {
        this.passiveMode = newPassiveMode;
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.passiveMode;
    }

    public void connect() throws RemoteFSException, IOException {
        this.remoteFSBean.setSecure(this.isSecureFtp());
        this.remoteFSBean.setProgressMonitor(this);
        this.remoteFSBean.setForceUTF8(this.isFtpForceUTF8());
        this.remoteFSBean.setPassiveMode(this.isPassiveMode());
        this.remoteFSBean.setPort(this.getFtpPort());
        this.remoteFSBean.connect(this.getFtpServer(), this.getFtpUser(), this.getFtpPassword());
        this.baseDirectory = this.remoteFSBean.getDirectory();
    }

    public void disconnect() {
        try {
            this.remoteFSBean.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConnection(AlbumBean engine) throws IOException, RemoteFSException {
        this.remoteFSBean.testConnection(this.getFtpServer(), this.getFtpUser(), this.getFtpPassword());
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    private String toAbsolute(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return IO.combinePaths(this.baseDirectory, path);
    }

    private String toRelative(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        String rel = IO.relativePath(path, this.baseDirectory);
        if (rel.startsWith("..")) {
            return path;
        }
        return rel;
    }

    public void uploadAlbum(AlbumBean engine, boolean fullUpdate) throws ParameterException, RemoteFSException, IOException, OperationAbortedException {
        this.engine = engine;
        File dir = engine.getInterpretedOutputDirectory();
        if (!dir.isDirectory()) {
            throw new IOException(Msg.get("publish.invalidOutputDirectoryError"));
        }
        this.processedFiles = 0;
        this.remoteFSBean.setProgressMonitor(this);
        String remoteDir = this.toAbsolute(engine.getRemoteDirectory());
        Map remoteFiles = null;
        if (!fullUpdate) {
            AlbumBeanEvent eventObject = new AlbumBeanEvent(this, dir.getName(), Msg.get("upload.comparingFilesInfo"), 1, 1, 1, 1);
            this.fireImageProcessingStarted(eventObject);
            this.timeDifference = this.calcTimeDifference();
            remoteFiles = this.scanRemoteFiles(dir, remoteDir);
        }
        this.totalFiles = this.countFiles(dir.listFiles(new UploadFileFilter()), remoteFiles);
        this.uploadFiles(dir.listFiles(new UploadFileFilter()), remoteFiles, remoteDir);
    }

    public void uploadFiles(File[] filesDirs, String remotePath) throws RemoteFSException, IOException, OperationAbortedException {
        this.processedFiles = 0;
        this.totalFiles = this.countFiles(filesDirs, null);
        this.remoteFSBean.setProgressMonitor(this);
        this.uploadFiles(filesDirs, null, this.toAbsolute(remotePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calcTimeDifference() {
        File tempfile = null;
        long diff = 0L;
        try {
            tempfile = File.createTempFile("JAlbumDateDiffTester", ".tmp");
            this.remoteFSBean.setDirectory(this.toAbsolute(this.engine.getRemoteDirectory()));
            Date localTime = new Date();
            this.remoteFSBean.putFile(tempfile, TIME_DIFF_TEST_NAME);
            RemoteFile[] files = this.remoteFSBean.getFiles();
            this.remoteFSBean.removeFile(TIME_DIFF_TEST_NAME);
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().equals(TIME_DIFF_TEST_NAME)) continue;
                diff = files[i].getModificationDate().getTime() - localTime.getTime();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (RemoteFSException ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            if (tempfile != null) {
                tempfile.delete();
            }
        }
        return diff;
    }

    private void uploadFiles(File[] filesDirs, Map remoteFiles, String remotePath) throws RemoteFSException, IOException, OperationAbortedException {
        this.remoteFSBean.setDirectory(remotePath);
        for (int i = 0; i < filesDirs.length; ++i) {
            RemoteFile rf;
            Object o;
            if (filesDirs[i].isDirectory()) {
                String newPath = IO.combinePaths(remotePath, filesDirs[i].getName());
                try {
                    this.remoteFSBean.createDirectory(filesDirs[i].getName());
                }
                catch (RemoteFSException ex) {
                    // empty catch block
                }
                this.uploadFiles(filesDirs[i].listFiles(new UploadFileFilter()), remoteFiles, newPath);
                this.remoteFSBean.toParentDirectory();
                continue;
            }
            if (remoteFiles != null && (o = remoteFiles.get(filesDirs[i])) != null && this.identical(filesDirs[i], rf = (RemoteFile)o)) continue;
            AlbumBeanEvent eventObject = new AlbumBeanEvent(this, filesDirs[i].getParentFile().getName(), filesDirs[i].getName(), i + 1, filesDirs.length, this.processedFiles + 1, this.totalFiles);
            this.fireImageProcessingStarted(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            int attempt = 1;
            while (true) {
                try {
                    if (attempt > 1) {
                        if (this.remoteFSBean.isConnected()) {
                            this.remoteFSBean.disconnect();
                        }
                        this.remoteFSBean.reconnect();
                    }
                    this.remoteFSBean.putFile(filesDirs[i], filesDirs[i].getName());
                }
                catch (IOException ex) {
                    if (attempt > 6) {
                        throw ex;
                    }
                    System.err.println("Caught " + ex.toString() + " while uploading " + filesDirs[i] + ". Attempt " + attempt);
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000 * attempt * attempt);
                    }
                    catch (InterruptedException ex2) {
                        // empty catch block
                    }
                    ++attempt;
                    continue;
                }
                break;
            }
            this.fireImageProcessingFinished(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            ++this.processedFiles;
        }
    }

    private Map scanRemoteFiles(File dir, String remotePath) throws RemoteFSException, IOException {
        File[] filesDirs = dir.listFiles(new UploadFileFilter());
        HashMap<String, File> localFiles = new HashMap<String, File>();
        for (int i = 0; i < filesDirs.length; ++i) {
            localFiles.put(filesDirs[i].getName(), filesDirs[i]);
        }
        HashMap remoteFiles = new HashMap();
        this.remoteFSBean.setDirectory(remotePath);
        RemoteFile[] res2 = this.remoteFSBean.getFiles();
        for (int i = 0; i < res2.length; ++i) {
            RemoteFile remoteFile = res2[i];
            if (remoteFile.isFile() && localFiles.containsKey(remoteFile.getName())) {
                remoteFiles.put(localFiles.get(remoteFile.getName()), remoteFile);
                continue;
            }
            File localFile = (File)localFiles.get(remoteFile.getName());
            if (localFile == null || !localFile.isDirectory()) continue;
            remoteFiles.putAll(this.scanRemoteFiles(localFile, IO.combinePaths(remotePath, remoteFile.getName())));
        }
        return remoteFiles;
    }

    private int countFiles(File[] filesDirs, Map remoteFiles) {
        int counter = 0;
        if (filesDirs == null) {
            return 0;
        }
        for (int i = 0; i < filesDirs.length; ++i) {
            RemoteFile rf;
            Object o;
            if (filesDirs[i].isDirectory()) {
                counter += this.countFiles(filesDirs[i].listFiles(new UploadFileFilter()), remoteFiles);
                continue;
            }
            if (remoteFiles != null && (o = remoteFiles.get(filesDirs[i])) != null && this.identical(filesDirs[i], rf = (RemoteFile)o)) continue;
            ++counter;
        }
        return counter;
    }

    private boolean identical(File local, RemoteFile remote) {
        long adjustedRemoteTime = remote.getModificationDate().getTime() - this.timeDifference;
        return local.length() == remote.size() && adjustedRemoteTime > local.lastModified();
    }

    private void myAssert(boolean test, String msg) throws ParameterException {
        if (!test) {
            throw new ParameterException(msg);
        }
    }

    public synchronized void addUploadListener(AlbumBeanListener l) {
        Vector v;
        Vector vector = v = this.uploadListeners == null ? new Vector(2) : (Vector)this.uploadListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.uploadListeners = v;
        }
    }

    public synchronized void removeUploadListener(AlbumBeanListener l) {
        if (this.uploadListeners != null && this.uploadListeners.contains(l)) {
            Vector v = (Vector)this.uploadListeners.clone();
            v.removeElement(l);
            this.uploadListeners = v;
        }
    }

    protected void fireImageProcessingStarted(AlbumBeanEvent e) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).imageProcessingStarted(e);
            }
        }
    }

    protected void fireImageProcessingFinished(AlbumBeanEvent e) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).imageProcessingFinished(e);
            }
        }
    }

    protected void fireErrorOccured(Exception param1, File param2) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((AlbumBeanListener)listeners.elementAt(i)).errorOccured(param1, param2);
            }
        }
    }

    protected void fireBytesTransferred(long bytes) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                if (!(listeners.elementAt(i) instanceof UploadListener)) continue;
                ((UploadListener)listeners.elementAt(i)).bytesTransferred(bytes);
            }
        }
    }

    public void bytesTransferred(long bytes) {
        this.fireBytesTransferred(bytes);
    }
}

