/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

public class Stopwatch {
    private long startTime = 0L;
    private long millis = 0L;
    private boolean running = false;
    private String label = "";

    public Stopwatch() {
    }

    public Stopwatch(String label) {
        this.label = label + ": ";
    }

    public synchronized void start() {
        if (!this.isRunning()) {
            this.startTime = System.currentTimeMillis();
            this.running = true;
        }
    }

    public synchronized void stop() {
        if (this.isRunning()) {
            this.millis += System.currentTimeMillis() - this.startTime;
            this.running = false;
        }
    }

    public synchronized void reset() {
        this.startTime = System.currentTimeMillis();
        this.millis = 0L;
    }

    public synchronized long getMillis() {
        if (this.isRunning()) {
            return System.currentTimeMillis() - this.startTime + this.millis;
        }
        return this.millis;
    }

    public synchronized String toString() {
        return this.label + (float)this.getMillis() / 1000.0f + "s";
    }

    public synchronized boolean isRunning() {
        return this.running;
    }
}

