/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.datadosen.util.CharBuffer;

public class Template {
    private List data = new LinkedList();
    final char keyPrefix;
    final int sizeHint;
    CharBuffer buffer;

    public Template(String ts) {
        this(ts, '$');
    }

    public Template(String ts, char keyPrefix) {
        this.keyPrefix = keyPrefix;
        this.sizeHint = ts.length();
        int index = 0;
        int lastIndex = 0;
        while ((index = ts.indexOf(keyPrefix, index)) > 0) {
            this.data.add(ts.substring(lastIndex, index));
            int keyLength = this.getKeyLength(ts, ++index);
            this.data.add(new Key(ts.substring(index, index + keyLength)));
            lastIndex = index += keyLength;
        }
        this.data.add(ts.substring(lastIndex));
    }

    private int getKeyLength(String s, int index) {
        char c;
        int i;
        for (i = index; i < s.length() && (Character.isJavaIdentifierPart(c = s.charAt(i)) || c == '.' && i + 1 < s.length() && Character.isJavaIdentifierPart(s.charAt(i + 1))); ++i) {
        }
        return i - index;
    }

    public String toString(Map mapping) {
        if (this.data.size() == 1 && this.data.get(0) instanceof String) {
            return (String)this.data.get(0);
        }
        StringBuilder buf = new StringBuilder(this.sizeHint);
        for (Object o : this.data) {
            if (o instanceof String) {
                buf.append((String)o);
                continue;
            }
            Key key = (Key)o;
            if (mapping.containsKey(key.name)) {
                buf.append(mapping.get(key.name));
                continue;
            }
            buf.append(this.keyPrefix);
            buf.append(key.name);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        String ts = "This is a simple text with a $style and a $styleFile variable. We also have $text.somekey $text.blaj. Here comes a $style variable again.$styleFil";
        Template testTemplate = new Template(ts, '$');
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("style", "[This is an expanded style variable]");
        mapping.put("styleFile", "[This is an expanded styleFile variable]");
        mapping.put("text.somekey", "[This is an expanded text]");
        System.out.println(testTemplate.toString(mapping));
        Template t2 = new Template("This is a string without any mappings", '$');
        System.out.println(t2.toString(mapping));
    }

    static class Key {
        String name;

        public Key(String name) {
            this.name = name;
        }
    }
}

