/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util.httpClient;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import se.datadosen.util.httpClient.Http;
import se.datadosen.util.httpClient.HttpResponse;
import se.datadosen.util.httpClient.Log;
import se.datadosen.util.httpClient.ModuleException;

public class HttpConnection {
    private static int timeout = 0;
    private String proto;
    private String host;
    private String uri;
    private int port;
    private String encoding;
    private Socket sock;

    public HttpConnection(URL url) {
        this.proto = url.getProtocol();
        this.host = url.getHost();
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = this.proto.equalsIgnoreCase("https") ? 443 : 80;
        }
        this.uri = url.getFile();
    }

    public HttpResponse Post(String contentType, String data, Map headers) throws IOException, ModuleException {
        String request = this.buildPost(this.uri, headers, contentType, data);
        Log.DEBUG("request is:\n" + request);
        this.sock = Http.makeSocket(this.proto, this.host, this.port);
        this.sock.setSoTimeout(timeout);
        Log.DEBUG("made socket\n");
        if (contentType.indexOf("charset") != -1) {
            this.encoding = contentType.substring(contentType.indexOf(61, contentType.indexOf("charset")) + 1);
        }
        this.sendRequest(this.sock, request, this.encoding);
        Log.DEBUG("request sent\n");
        HttpResponse response = Http.readResponse(this.sock.getInputStream());
        this.sock.close();
        return response;
    }

    public HttpResponse Post(Map data, Map headers) throws IOException, ModuleException {
        return this.Post("application/x-www-form-urlencoded", HttpConnection.encodeFormData(data), headers);
    }

    public HttpResponse Post(Map data) throws IOException, ModuleException {
        return this.Post(data, new HashMap());
    }

    public boolean abortConnection() {
        if (this.sock != null) {
            try {
                this.sock.close();
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    private void sendRequest(Socket sock, String request, String encoding) throws IOException {
        BufferedWriter out = encoding == null ? new BufferedWriter(new OutputStreamWriter(sock.getOutputStream())) : new BufferedWriter(new OutputStreamWriter(sock.getOutputStream(), encoding));
        out.write(request);
        out.flush();
    }

    private String buildPost(String uri, Map headers, String contentType, String content) {
        String result = "POST " + uri + " HTTP/1.1\r\n";
        String[] mandatory = new String[]{"Accept", "*/*", "Content-Type", contentType, "Accept-Encoding", "deflate, gzip, x-gzip, compress, x-compress", "User-Agent", "Mozilla/4.0 (compatible; JAlbum)", "Host", this.host, "Content-Length", String.valueOf(content.length()), "Connection", "Close", "Cache-Control", "no-cache"};
        for (int i = 0; i < mandatory.length; i += 2) {
            headers = HttpConnection.mandatoryHeader(headers, mandatory[i], mandatory[i + 1]);
        }
        for (Map.Entry e : headers.entrySet()) {
            result = result + e.getKey() + ": " + e.getValue() + "\r\n";
        }
        result = result + "\r\n" + content;
        return result;
    }

    static Map mandatoryHeader(Map headers, String name, String value) {
        if (headers.containsKey(name)) {
            return headers;
        }
        headers.put(name, value);
        return headers;
    }

    static String encodeFormData(Map data) {
        try {
            String result = "";
            for (Map.Entry e : data.entrySet()) {
                if (!result.equals("")) {
                    result = result + "&";
                }
                result = result + URLEncoder.encode(e.getKey().toString(), "UTF-8") + "=" + URLEncoder.encode(e.getValue().toString(), "UTF-8");
            }
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setDefaultTimeout(int timeout) {
        HttpConnection.timeout = timeout;
    }

    public static void setDefaultAllowUserInteraction(boolean dummy) {
    }

    public static void main(String[] args) throws Exception {
        URL url = new URL("http://localhost/www.datadosen.se/jalbum/signuptest.jsp");
        HttpConnection conn = new HttpConnection(url);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("foo", "bar");
        data.put("firstName", "David Ekholm \u00e5\u00e4\u00f6");
        HttpResponse resp = conn.Post(data);
        System.out.println(resp.getContentAsString());
    }
}

