/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterManager;
import net.jalbum.filterManager.JAlbumImageFilterInterface;

public class BasicFilter
implements JAlbumImageFilterInterface {
    private static final long serialVersionUID = 4118395418676584221L;
    protected String name = "JAlbum Image Filter";
    protected String shortName = "";
    protected ImageIcon icon = null;
    protected String author = "David Fichtmueller";
    protected String version = "1.0";
    protected String description = "This is the default filter class, all other filters must inherite from.";
    protected String help = "This filter doesn't do anything to the actual image, so don't be surprised if it doesn't seem to work.";
    protected String other = "";
    protected boolean prescale = true;
    protected boolean postscale = true;
    protected BufferedImage inputImage;
    protected BufferedImage outputImage;
    protected FilterManager filterManager;
    protected int width;
    protected int height;

    public void init() {
    }

    public JPanel getControls() {
        return null;
    }

    public void setImage(BufferedImage bi) {
        this.inputImage = this.cloneBufferedImage(bi);
        this.width = this.inputImage.getWidth();
        this.height = this.inputImage.getHeight();
        this.renderPreview();
    }

    protected BufferedImage cloneBufferedImage(BufferedImage bi) {
        return FilterManager.cloneBufferedImage((BufferedImage)bi);
    }

    public void renderImage() {
        this.outputImage = this.renderImage(this.cloneBufferedImage(this.inputImage));
        this.filterManager.setGUIImage(this.outputImage);
    }

    public BufferedImage renderImage(BufferedImage bi) {
        return bi;
    }

    public void renderPreview() {
        this.outputImage = this.renderImage(this.cloneBufferedImage(this.inputImage));
        this.paint(this.outputImage.getGraphics());
        this.filterManager.setGUIImage(this.outputImage);
    }

    public void paint(Graphics g) {
    }

    public void dispose() {
        this.inputImage = null;
        this.outputImage = null;
        this.filterManager = null;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHelp() {
        return this.help;
    }

    public String getOther() {
        return this.other;
    }

    public boolean isPrescale() {
        return this.prescale;
    }

    public boolean isPostscale() {
        return this.postscale;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public void setPrescale(boolean prescale) {
        this.prescale = prescale;
    }

    public void setPostscale(boolean postscale) {
        this.postscale = postscale;
    }

    public FilterManager getFilterManager() {
        return this.filterManager;
    }

    public void setFilterManager(FilterManager filterManager) {
        this.filterManager = filterManager;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

