/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.jalbum.filters.FilterControl;
import net.jalbum.filters.RotationFilterPlugin;
import net.jalbum.filters.components.JInstantTextField;
import se.datadosen.component.JColorSelector;
import se.datadosen.jalbum.Msg;

public class RotationControl
extends FilterControl {
    private static final long serialVersionUID = -8762814379216308341L;
    protected RotationFilterPlugin rotationFilterPlugin;
    protected JTextField tfAngle;
    protected JCheckBox random;
    protected JCheckBox showGrid;
    protected JComboBox resizeOption;
    protected Color color;
    protected JColorSelector bgcolor;
    protected double angle;

    public RotationControl() {
    }

    public RotationControl(RotationFilterPlugin rotationFilterPlugin) {
        this.init(rotationFilterPlugin);
        this.addRotationControls();
    }

    protected void init(RotationFilterPlugin rotationFilterPlugin) {
        this.rotationFilterPlugin = rotationFilterPlugin;
        super.init(rotationFilterPlugin);
    }

    public void addRotationControls() {
        this.tfAngle = new JInstantTextField(Integer.toString(0), 4);
        this.showGrid = new JCheckBox(Msg.getString((Object)this, (String)"filters.rotation.showGrid"));
        this.showGrid.setSelected(true);
        this.bgcolor = new JColorSelector(Msg.getString((Object)this, (String)"filters.rotation.bgColor"));
        this.bgcolor.setColor(Color.WHITE);
        this.resizeOption = new JComboBox();
        this.resizeOption.addItem(new String(Msg.getString((Object)this, (String)"filters.rotation.resizeCrop")));
        this.resizeOption.addItem(new String(Msg.getString((Object)this, (String)"filters.rotation.resizeCropAndZoom")));
        this.resizeOption.addItem(new String(Msg.getString((Object)this, (String)"filters.rotation.resizeEnlarge")));
        this.tfAngle.addActionListener(this);
        this.showGrid.addActionListener(this);
        this.resizeOption.addActionListener(this);
        this.bgcolor.addActionListener((ActionListener)this);
        this.add("p", new JLabel(Msg.getString((Object)this, (String)"filters.rotation.rotate")));
        this.add(this.tfAngle);
        this.add(new JLabel("<html>&deg;</html>"));
        this.add("br", (Component)this.bgcolor);
        this.add(new JLabel(Msg.getString((Object)this, (String)"filters.rotation.bgColor")));
        this.add("p", new JLabel(Msg.getString((Object)this, (String)"filters.rotation.mode")));
        this.add(this.resizeOption);
        this.add("p", this.showGrid);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.bgcolor) {
            this.color = this.bgcolor.getColor();
            this.rotationFilterPlugin.setColor(this.color);
            this.rotationFilterPlugin.renderPreview();
        } else if (e.getSource() == this.tfAngle) {
            try {
                double angle = Double.parseDouble(this.tfAngle.getText());
                angle = (angle % 360.0 + 360.0 + 180.0) % 360.0 - 180.0;
                this.tfAngle.setText(Double.toString((double)((int)(angle * 100.0)) / 100.0));
                this.angle = angle;
                this.rotationFilterPlugin.adjustAngle(angle);
            }
            catch (Exception exception) {
                this.tfAngle.setText(Double.toString(this.angle));
            }
        } else if (e.getSource() == this.random) {
            this.rotationFilterPlugin.adjustRandom(this.random.isSelected());
        } else if (e.getSource() == this.resizeOption) {
            if (this.resizeOption.getSelectedIndex() == 0) {
                this.rotationFilterPlugin.setResizeOption(0);
            } else if (this.resizeOption.getSelectedIndex() == 1) {
                this.rotationFilterPlugin.setResizeOption(1);
            } else if (this.resizeOption.getSelectedIndex() == 2) {
                this.rotationFilterPlugin.setResizeOption(2);
            }
            this.rotationFilterPlugin.renderPreview();
        } else if (e.getSource() == this.showGrid) {
            this.rotationFilterPlugin.setShowGrid(this.showGrid.isSelected());
            this.rotationFilterPlugin.renderPreview();
        }
    }

    public void updateAngle(double angle) {
        this.angle = (angle % 360.0 + 360.0 + 180.0) % 360.0 - 180.0;
        this.tfAngle.setText(Double.toString((double)((int)(this.angle * 100.0)) / 100.0));
    }

    public void setResizeOption(int resizeOption) {
        if (resizeOption == 1) {
            this.resizeOption.setSelectedIndex(0);
        } else if (resizeOption == 0) {
            this.resizeOption.setSelectedIndex(1);
        } else if (resizeOption == 2) {
            this.resizeOption.setSelectedIndex(2);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }
}

