/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filterManager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.jalbum.filterManager.FilterManager;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.component.JLinkButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;

public class FilterManagerUI
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -4783268072080962112L;
    protected final FilterManager filterManager;
    JButton apply;
    JButton cancel;
    JLinkButton preview;
    JLinkButton info;
    private JPanel filterInfoPanel;
    private final Action applyAction;
    private final Action cancelAction;

    public FilterManagerUI(final FilterManager filterManager) {
        this.filterManager = filterManager;
        this.applyAction = new AbstractAction(){
            private static final long serialVersionUID = -4810095035671646114L;

            public void actionPerformed(ActionEvent e) {
                filterManager.applyFilter();
            }
        };
        this.cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                filterManager.cancel();
            }
        };
        this.apply = new JButton(this.applyAction);
        this.apply.setText(Msg.get("filters.filterManager.apply"));
        this.apply.setIcon(Icons.getIcon("small.apply"));
        this.cancel = new JButton(this.cancelAction);
        this.cancel.setText(Msg.get("cancel"));
        this.cancel.setIcon(Icons.getIcon("small.cancel"));
        this.preview = new JLinkButton();
        this.preview.setIcon(Icons.getIcon("small.preview"));
        this.info = new JLinkButton();
        this.info.setIcon(Icons.getIcon("small.info"));
        this.info.setToolTipText(Msg.get("filters.filterManager.infoToolTip"));
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        this.registerKeyboardAction(this.applyAction, "applyFilter", ks, 2);
        ks = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyboardAction(this.cancelAction, "cancelFilter", ks, 2);
        this.setLayout(new RiverLayout());
        this.preview.addActionListener(this);
        this.info.addActionListener(this);
        this.add("p center", this.apply);
        this.add(this.cancel);
        this.add("br center", this.preview);
        this.add(this.info);
    }

    public void indicatePreview(boolean indicate) {
        if (indicate) {
            this.preview.setEnabled(true);
            this.preview.setToolTipText(Msg.get("filters.filterManager.previewToolTip"));
        } else {
            this.preview.setEnabled(false);
            this.preview.setToolTipText(Msg.get("filters.filterManager.previewToolTipDisabled"));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.preview) {
            ImageIcon icon = new ImageIcon(this.filterManager.renderPreview());
            JOptionPane previewPane = new JOptionPane(new JLabel(icon), -1, -1);
            previewPane.createDialog(this.getParent(), Msg.get("ui.preview")).setVisible(true);
        } else if (e.getSource() == this.info) {
            JAlbumImageFilter currentFilter = this.filterManager.getNewFilter();
            JOptionPane infoPane = new JOptionPane(this.filterInfoPanel, 1, -1);
            infoPane.createDialog(this.getParent(), currentFilter.getName() + " - " + Msg.get("filters.filterManager.info")).setVisible(true);
        }
    }

    public void loadFilterInfoPanel(JAlbumImageFilter filter) {
        this.filterInfoPanel = new JPanel(new RiverLayout());
        JLabel nameLabel = new JLabel(Msg.get("ui.nameOrdering") + ":");
        nameLabel.setFont(nameLabel.getFont().deriveFont(1));
        this.filterInfoPanel.add("p left", nameLabel);
        this.filterInfoPanel.add(new JLabel(filter.getName()));
        JLabel authorLabel = new JLabel(Msg.get("filters.filterManager.author") + ":");
        authorLabel.setFont(authorLabel.getFont().deriveFont(1));
        this.filterInfoPanel.add("p left", authorLabel);
        this.filterInfoPanel.add(new JLabel(filter.getProperties().getAuthor()));
        JLabel versionLabel = new JLabel(Msg.get("filters.filterManager.version") + ":");
        versionLabel.setFont(versionLabel.getFont().deriveFont(1));
        this.filterInfoPanel.add("p left", versionLabel);
        this.filterInfoPanel.add(new JLabel(filter.getProperties().getVersion()));
        JLabel descriptionLabel = new JLabel(Msg.get("filters.filterManager.description") + ":");
        descriptionLabel.setFont(descriptionLabel.getFont().deriveFont(1));
        this.filterInfoPanel.add("p left", descriptionLabel);
        this.filterInfoPanel.add(new JLabel(filter.getProperties().getDescription()));
        if (filter.getProperties().getHelp() != null && filter.getProperties().getHelp().length() > 1) {
            JLabel helpLabel = new JLabel(Msg.get("ui.helpMenu") + ":");
            helpLabel.setFont(helpLabel.getFont().deriveFont(1));
            this.filterInfoPanel.add("p left", helpLabel);
            this.filterInfoPanel.add(new JLabel(filter.getProperties().getHelp()));
        }
        if (filter.getProperties().getOther() != null && filter.getProperties().getOther().length() > 1) {
            JLabel otherLabel = new JLabel(Msg.get("filters.filterManager.other") + ":");
            otherLabel.setFont(otherLabel.getFont().deriveFont(1));
            this.filterInfoPanel.add("p left", otherLabel);
            this.filterInfoPanel.add(new JLabel(filter.getProperties().getOther()));
        }
    }
}

