/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import javax.swing.UIManager;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.Msg;

public class Config
implements Serializable {
    private static Config theConfig;
    public File progDir = new File("").getAbsoluteFile();
    public File skinsDir;
    public ChainedDirectory chainedSkinsDir;
    public File pluginsDir;
    public String language = "default";
    private File appdataDir;
    private String lookAndFeel;
    private String webHostListUrl = "http://jalbum.net/web-hosts.xml";
    private boolean cleanOutputFiles = true;
    private boolean synchronizeOutputDirectory = true;
    private boolean cacheThumbnails = true;
    private boolean updateProfilePage = true;
    private String afterPublishing = "openPublishingSuccessfulPage";
    private boolean showPreviewInfoBar = true;
    private boolean encryptManifest = false;
    private String manifestPassword;
    private boolean zipstreaming = true;
    private boolean debugMode;

    private Config() {
        this.newProgDir();
        if (!this.skinsDir.exists() || !this.pluginsDir.exists()) {
            URL url;
            File classPath;
            String instDirName = System.getProperty("jalbum.installation.dir");
            this.progDir = instDirName != null ? new File(instDirName) : ((classPath = new File(System.getProperty("java.class.path"))).exists() ? classPath.getParentFile().getAbsoluteFile() : ((url = JAlbum.class.getResource("../../../")) != null ? new File(url.getFile()).getParentFile() : new File("")));
            this.newProgDir();
        }
        this.setLookAndFeel(System.getProperty("swing.defaultlaf") == null ? UIManager.getSystemLookAndFeelClassName() : System.getProperty("swing.defaultlaf"));
        this.updateChainedSkinsDir();
    }

    private void updateChainedSkinsDir() {
        this.chainedSkinsDir = new ChainedDirectory(this.skinsDir);
        String appdata = System.getProperty("appdata");
        if (appdata == null) {
            try {
                appdata = System.getenv("APPDATA");
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (appdata != null) {
            this.appdataDir = new File(appdata);
        } else {
            String os = System.getProperty("os.name");
            if (os != null && os.indexOf("Windows") != -1) {
                File appdataDir = new File(System.getProperty("user.home"), "Application Data");
                if (appdataDir.exists()) {
                    this.appdataDir = appdataDir;
                }
            } else if (JAlbum.isMac()) {
                this.appdataDir = new File(System.getProperty("user.home"), "Library");
            }
        }
        if (this.appdataDir != null) {
            File altSkinsDir = new File(this.appdataDir, "JAlbum/skins");
            this.chainedSkinsDir = new ChainedDirectory(altSkinsDir, this.chainedSkinsDir);
        }
    }

    public static Config getConfig() {
        if (theConfig == null) {
            theConfig = new Config();
        }
        return theConfig;
    }

    public void setProgramDirectory(File progDir) {
        this.progDir = progDir;
        this.newProgDir();
        this.updateChainedSkinsDir();
    }

    public void setProgramDirectory(String progDir) {
        this.setProgramDirectory(new File(progDir));
    }

    public void setSkinsDirectory(File skinsDir) {
        this.skinsDir = skinsDir;
        this.updateChainedSkinsDir();
    }

    public void setSkinsDirectory(String skinsDir) {
        this.setSkinsDirectory(new File(skinsDir));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getInterpretedLanguage() {
        return this.language.equals("default") ? System.getProperty("user.language") : this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
        if (!language.equals("default")) {
            Locale.setDefault(new Locale(language, System.getProperty("user.country")));
        } else {
            Locale.setDefault(new Locale(System.getProperty("user.language"), System.getProperty("user.country")));
        }
        Msg.reloadBundle();
    }

    private void newProgDir() {
        this.skinsDir = new File(this.progDir, "skins");
        this.pluginsDir = new File(this.progDir, "plugins");
    }

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public String getWebHostListUrl() {
        return this.webHostListUrl;
    }

    public void setWebHostListUrl(String webHostListUrl) {
        this.webHostListUrl = webHostListUrl;
    }

    public boolean isCleanOutputFiles() {
        return this.cleanOutputFiles;
    }

    public void setCleanOutputFiles(boolean clean) {
        this.cleanOutputFiles = clean;
    }

    public boolean isSynchronizeOutputDirectory() {
        return this.synchronizeOutputDirectory;
    }

    public void setSynchronizeOutputDirectory(boolean synchronizeOutputDirectory) {
        this.synchronizeOutputDirectory = synchronizeOutputDirectory;
    }

    public boolean isCacheThumbnails() {
        return this.cacheThumbnails;
    }

    public void setCacheThumbnails(boolean cacheThumbnails) {
        this.cacheThumbnails = cacheThumbnails;
    }

    public boolean isUpdateProfilePage() {
        return this.updateProfilePage;
    }

    public void setUpdateProfilePage(boolean updateProfilePage) {
        this.updateProfilePage = updateProfilePage;
    }

    public String getAfterPublishing() {
        return this.afterPublishing;
    }

    public void setAfterPublishing(String afterPublishing) {
        this.afterPublishing = afterPublishing;
    }

    public boolean isShowPreviewInfoBar() {
        return this.showPreviewInfoBar;
    }

    public void setShowPreviewInfoBar(boolean showPreviewInfoBar) {
        this.showPreviewInfoBar = showPreviewInfoBar;
    }

    public boolean isEncryptManifest() {
        return this.encryptManifest;
    }

    public void setEncryptManifest(boolean encryptManifest) {
        this.encryptManifest = encryptManifest;
    }

    public String getManifestPassword() {
        return this.manifestPassword;
    }

    public void setManifestPassword(String manifestPassword) {
        this.manifestPassword = manifestPassword;
    }

    public boolean isZipstreaming() {
        return this.zipstreaming;
    }

    public void setZipstreaming(boolean zipstreaming) {
        this.zipstreaming = zipstreaming;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }
}

