/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.PluginManager;
import se.datadosen.jalbum.SkinManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialMacHandler
implements ApplicationListener {
    private static int counter = 1;
    private FileQueue fileQueue;

    public SpecialMacHandler() {
        SpecialMacHandler.setSystemProperties();
        SpecialMacHandler.registerAsApplicationListener(this);
    }

    private static void registerAsApplicationListener(ApplicationListener l) {
        Application app = Application.getApplication();
        app.addApplicationListener(l);
        app.addPreferencesMenuItem();
        app.setEnabledAboutMenu(true);
        app.setEnabledPreferencesMenu(true);
    }

    private static void setSystemProperties() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "JAlbum");
        System.setProperty("apple.awt.fileDialogForDirectories", "true");
        System.setProperty("apple.awt.antialiasing", "on");
        System.setProperty("apple.awt.interpolation", "bilinear");
        System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
        System.setProperty("apple.awt.graphics.UseQuartz", "true");
        System.setProperty("apple.awt.draggableWindowBackground", "false");
    }

    public void handleOpenApplication(ApplicationEvent applicationEvent) {
    }

    public void handleReOpenApplication(ApplicationEvent applicationEvent) {
        JAlbumFrame f = JAlbum.mainFrame;
        if (!f.isVisible()) {
            f.setVisible(true);
        }
        if (f.getExtendedState() != 0) {
            f.setExtendedState(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleOpenFile(ApplicationEvent applicationEvent) {
        System.out.println("handleOpenFile");
        if (this.fileQueue == null) {
            this.fileQueue = new FileQueue();
            this.fileQueue.start();
            FileQueue fileQueue = this.fileQueue;
            synchronized (fileQueue) {
                while (true) {
                    try {
                        if (this.fileQueue.synch) break;
                        this.fileQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
        this.fileQueue.addFile(new File(applicationEvent.getFilename()));
        applicationEvent.setHandled(true);
    }

    public void handleAbout(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(true);
        JAlbum.mainFrame.showAboutBox();
    }

    public void handlePreferences(ApplicationEvent applicationEvent) {
        applicationEvent.setHandled(true);
        JAlbum.mainFrame.actions.showPreferencesWindowAction.actionPerformed(null);
    }

    public void handlePrintFile(ApplicationEvent applicationEvent) {
        System.out.println("handlePrintFile");
    }

    public void handleQuit(ApplicationEvent applicationEvent) {
        if (!JAlbum.mainFrame.isVisible() && PluginManager.onExit()) {
            System.exit(0);
        }
        JAlbum.mainFrame.doExit(null);
    }

    private void handleFileOpen(final List<File> files) {
        new Thread(){

            public void run() {
                SpecialMacHandler.this.ensureGuiStarted();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (((File)files.get(0)).getName().endsWith("jaskin")) {
                            new SkinManager().installSkin((File)files.get(0));
                        } else {
                            JAlbum.mainFrame.albumExplorer.explorer.handleFileAdd(files);
                        }
                    }
                });
            }
        }.start();
    }

    private void ensureGuiStarted() {
        while (!JAlbum.initialized) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    class FileQueue
    extends Thread {
        LinkedList<File> files = new LinkedList();
        boolean synch = false;

        FileQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FileQueue fileQueue = this;
            synchronized (fileQueue) {
                this.synch = true;
                this.notify();
                while (true) {
                    try {
                        this.wait(100L);
                        SpecialMacHandler.this.handleFileOpen(this.files);
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                    break;
                }
            }
            SpecialMacHandler.this.fileQueue = null;
        }

        public synchronized void addFile(File f) {
            this.files.add(f);
            this.interrupt();
        }
    }
}

