/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.test.FTPTestCase;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class VMSTests
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: VMSTests.java,v 1.2 2005/07/15 17:30:06 bruceb Exp $";

    protected String getLogName() {
        return "TestVMS.log";
    }

    public void testDir() throws Exception {
        block2: {
            this.connect();
            this.ftp.chdir(this.testdir);
            String[] list = this.ftp.dir();
            this.print(list);
            String randomName = this.generateRandomFilename();
            try {
                list = this.ftp.dir(randomName);
                this.print(list);
            }
            catch (FTPException ex) {
                if (ex.getReplyCode() == 550 || ex.getReplyCode() == 552) break block2;
                VMSTests.fail((String)("dir(" + randomName + ") should throw 550/552 for non-existent dir"));
            }
        }
        this.ftp.quit();
    }

    public void testDirFull() throws Exception {
        block2: {
            this.connect();
            this.ftp.chdir(this.testdir);
            String[] list = this.ftp.dir("", true);
            this.print(list);
            this.log.debug("******* dirDetails *******");
            FTPFile[] files = this.ftp.dirDetails("");
            this.print(files);
            this.log.debug("******* end dirDetails *******");
            String randomName = this.generateRandomFilename();
            try {
                list = this.ftp.dir(randomName, true);
                this.print(list);
            }
            catch (FTPException ex) {
                if (ex.getReplyCode() == 550 || ex.getReplyCode() == 552) break block2;
                VMSTests.fail((String)("dir(" + randomName + ") should throw 550/552 for non-existent dir"));
            }
        }
        this.ftp.quit();
    }

    public void testTransferText() throws Exception {
        this.log.debug("testTransferText()");
        this.connect();
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.ASCII);
        String filename = this.generateRandomFilename();
        this.ftp.get(this.localDataDir + filename, this.remoteTextFile);
        File local = new File(this.localDataDir + filename);
        local.delete();
        this.ftp.quit();
    }

    public void testTransferBinary() throws Exception {
        this.log.debug("testTransferBinary()");
        this.connect();
        this.ftp.chdir(this.testdir);
        this.ftp.setType(FTPTransferType.BINARY);
        String filename = this.generateRandomFilename();
        this.ftp.get(this.localDataDir + filename, this.remoteBinaryFile);
        File local = new File(this.localDataDir + filename);
        local.delete();
        this.ftp.quit();
    }

    public static Test suite() {
        return new TestSuite(VMSTests.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)VMSTests.suite());
    }
}

