/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletePopupWindow;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.autocomplete.SizeGrip;
import org.fife.ui.autocomplete.Util;

class AutoCompleteDescWindow
extends JWindow
implements HyperlinkListener {
    private AutoCompletion ac;
    private JEditorPane descArea;
    private JScrollPane scrollPane;
    private JPanel bottomPanel;
    private JToolBar descWindowNavBar;
    private Action backAction;
    private Action forwardAction;
    private List history;
    private int historyPos;
    private ResourceBundle bundle;
    private static final String MSG = "org.fife.ui.autocomplete.AutoCompleteDescWindow";

    public AutoCompleteDescWindow(Window window, AutoCompletion autoCompletion) {
        super(window);
        this.ac = autoCompletion;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.descArea = new JEditorPane("text/html", null);
        this.tweakDescArea();
        this.descArea.addHyperlinkListener(this);
        this.scrollPane = new JScrollPane(this.descArea);
        this.scrollPane.setViewportBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.scrollPane.setBackground(this.descArea.getBackground());
        this.scrollPane.getViewport().setBackground(this.descArea.getBackground());
        jPanel.add(this.scrollPane);
        this.descWindowNavBar = new JToolBar();
        this.backAction = new ToolBarBackAction();
        this.forwardAction = new ToolBarForwardAction();
        this.descWindowNavBar.setFloatable(false);
        this.descWindowNavBar.add(new JButton(this.backAction));
        this.descWindowNavBar.add(new JButton(this.forwardAction));
        this.bottomPanel = new JPanel(new BorderLayout());
        SizeGrip sizeGrip = new SizeGrip();
        this.bottomPanel.add((Component)this.descWindowNavBar, "Before");
        this.bottomPanel.add((Component)sizeGrip, "After");
        jPanel.add((Component)this.bottomPanel, "South");
        this.setContentPane(jPanel);
        this.setFocusableWindowState(false);
        this.history = new ArrayList(1);
        this.historyPos = -1;
    }

    private void addToHistory(String string) {
        this.history.add(++this.historyPos, string);
        this.clearHistoryAfterCurrentPos();
        this.setActionStates();
    }

    private void clearHistory() {
        this.history.clear();
        this.historyPos = -1;
        if (this.descWindowNavBar != null) {
            this.setActionStates();
        }
    }

    private void clearHistoryAfterCurrentPos() {
        for (int i = this.history.size() - 1; i > this.historyPos; --i) {
            this.history.remove(i);
        }
        this.setActionStates();
    }

    public boolean copy() {
        if (this.isVisible() && this.descArea.getSelectionStart() != this.descArea.getSelectionEnd()) {
            this.descArea.copy();
            return true;
        }
        return false;
    }

    protected Color getDefaultBackground() {
        Color color = UIManager.getColor("ToolTip.background");
        if (color == null && (color = UIManager.getColor("info")) == null) {
            color = SystemColor.infoText;
        }
        return color;
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle(MSG);
        }
        return this.bundle.getString(string);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
        if (eventType.equals(HyperlinkEvent.EventType.ACTIVATED)) {
            URL uRL = hyperlinkEvent.getURL();
            if (uRL != null) {
                ExternalURLHandler externalURLHandler = this.ac.getExternalURLHandler();
                if (externalURLHandler != null) {
                    externalURLHandler.urlClicked(uRL);
                    return;
                }
                try {
                    Util.browse(new URI(uRL.toString()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.descArea);
                    uRISyntaxException.printStackTrace();
                }
            } else {
                AutoCompletePopupWindow autoCompletePopupWindow = (AutoCompletePopupWindow)this.getParent();
                CompletionProvider completionProvider = autoCompletePopupWindow.getSelection().getProvider();
                if (completionProvider instanceof AbstractCompletionProvider) {
                    String string = hyperlinkEvent.getDescription();
                    List list = ((AbstractCompletionProvider)completionProvider).getCompletionByInputText(string);
                    if (list != null && !list.isEmpty()) {
                        Completion completion = (Completion)list.get(0);
                        this.setDescriptionFor(completion, true);
                    } else {
                        UIManager.getLookAndFeel().provideErrorFeedback(this.descArea);
                    }
                }
            }
        }
    }

    private void setActionStates() {
        this.backAction.setEnabled(this.historyPos > 0);
        this.forwardAction.setEnabled(this.historyPos > -1 && this.historyPos < this.history.size() - 1);
    }

    public void setDescriptionFor(Completion completion) {
        this.setDescriptionFor(completion, false);
    }

    protected void setDescriptionFor(Completion completion, boolean bl) {
        String string;
        String string2 = string = completion == null ? null : completion.getSummary();
        if (string == null) {
            string = "<html><em>" + this.getString("NoDescAvailable") + "</em>";
        }
        this.descArea.setText(string);
        this.descArea.setCaretPosition(0);
        if (!bl) {
            this.clearHistory();
        }
        this.addToHistory(string);
    }

    public void setVisible(boolean bl) {
        if (!bl) {
            this.clearHistory();
        }
        super.setVisible(bl);
    }

    private void tweakDescArea() {
        Serializable serializable;
        Serializable serializable2;
        if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
            serializable2 = this.descArea.getSelectionColor();
            serializable = this.descArea.getSelectedTextColor();
            this.descArea.setUI(new BasicEditorPaneUI());
            this.descArea.setSelectedTextColor((Color)serializable);
            this.descArea.setSelectionColor((Color)serializable2);
        }
        this.descArea.setEditable(false);
        this.descArea.getCaret().setSelectionVisible(true);
        this.descArea.setBackground(this.getDefaultBackground());
        serializable2 = UIManager.getFont("Label.font");
        if (serializable2 == null) {
            serializable2 = new Font("SansSerif", 0, 12);
        }
        serializable = (HTMLDocument)this.descArea.getDocument();
        ((HTMLDocument)serializable).getStyleSheet().addRule("body { font-family: " + ((Font)serializable2).getFamily() + "; font-size: " + ((Font)serializable2).getSize() + "pt; }");
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
        this.tweakDescArea();
        this.scrollPane.setBackground(this.descArea.getBackground());
        this.scrollPane.getViewport().setBackground(this.descArea.getBackground());
    }

    class ToolBarForwardAction
    extends AbstractAction {
        public ToolBarForwardAction() {
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL uRL = classLoader.getResource("org/fife/ui/autocomplete/arrow_right.png");
            try {
                ImageIcon imageIcon = new ImageIcon(ImageIO.read(uRL));
                this.putValue("SmallIcon", imageIcon);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.putValue("ShortDescription", "Forward");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompleteDescWindow.this.history != null && AutoCompleteDescWindow.this.historyPos < AutoCompleteDescWindow.this.history.size() - 1) {
                AutoCompleteDescWindow.this.descArea.setText((String)AutoCompleteDescWindow.this.history.get(++AutoCompleteDescWindow.this.historyPos));
                AutoCompleteDescWindow.this.descArea.setCaretPosition(0);
                AutoCompleteDescWindow.this.setActionStates();
            }
        }
    }

    class ToolBarBackAction
    extends AbstractAction {
        public ToolBarBackAction() {
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL uRL = classLoader.getResource("org/fife/ui/autocomplete/arrow_left.png");
            try {
                ImageIcon imageIcon = new ImageIcon(ImageIO.read(uRL));
                this.putValue("SmallIcon", imageIcon);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.putValue("ShortDescription", "Back");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompleteDescWindow.this.historyPos > 0) {
                AutoCompleteDescWindow.this.descArea.setText((String)AutoCompleteDescWindow.this.history.get(--AutoCompleteDescWindow.this.historyPos));
                AutoCompleteDescWindow.this.descArea.setCaretPosition(0);
                AutoCompleteDescWindow.this.setActionStates();
            }
        }
    }
}

