/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import net.jalbum.filters.BoxBlurFilterPlugin;
import net.jalbum.filters.FilterControl;
import net.jalbum.filters.components.ExtendedSlider;
import se.datadosen.jalbum.Msg;

public class BoxBlurControl
extends FilterControl {
    private static final long serialVersionUID = -7969686269619548580L;
    protected BoxBlurFilterPlugin blurFilterPlugin;
    protected ExtendedSlider strengthSlider;
    protected JLabel textStrength;
    protected ExtendedSlider qualitySlider;
    protected JLabel textquality;

    public BoxBlurControl() {
    }

    public BoxBlurControl(BoxBlurFilterPlugin blurFilterPlugin) {
        this.init(blurFilterPlugin);
        this.addBlurControls();
    }

    protected void addBlurControls() {
        this.textStrength = new JLabel(Msg.getString((Object)this, (String)"filters.boxblur.radius"));
        this.strengthSlider = new ExtendedSlider(0, 0, 100, this.blurFilterPlugin.getRadius());
        this.strengthSlider.getSlider().setSnapToTicks(false);
        this.strengthSlider.getSlider().setPaintLabels(false);
        this.strengthSlider.setSliderWidth(132);
        this.strengthSlider.removeResetButton();
        this.strengthSlider.addActionListener(this);
        this.add(this.textStrength);
        this.add("br", this.strengthSlider);
        this.textquality = new JLabel(Msg.getString((Object)this, (String)"filters.boxblur.passes"));
        this.qualitySlider = new ExtendedSlider(0, 1, 5, this.blurFilterPlugin.getPasses());
        this.qualitySlider.getSlider().setSnapToTicks(true);
        this.qualitySlider.getSlider().setPaintLabels(false);
        this.qualitySlider.setSliderWidth(132);
        this.qualitySlider.removeResetButton();
        this.qualitySlider.addActionListener(this);
        this.add("br", this.textquality);
        this.add("br", this.qualitySlider);
    }

    protected void init(BoxBlurFilterPlugin blurFilterPlugin) {
        this.blurFilterPlugin = blurFilterPlugin;
        super.init(blurFilterPlugin);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.strengthSlider && this.strengthSlider.getValue() != this.blurFilterPlugin.getRadius()) {
            this.blurFilterPlugin.adjustRadius(this.strengthSlider.getValue());
        }
        if (e.getSource() == this.qualitySlider && this.qualitySlider.getValue() != this.blurFilterPlugin.getRadius()) {
            this.blurFilterPlugin.adjustPasses(this.qualitySlider.getValue());
        }
    }
}

