/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import net.jalbum.filters.ResizableBox;
import net.jalbum.filters.ResizableObjectPanel;
import se.datadosen.jalbum.Msg;

public class TextBox
extends ResizableBox {
    private static final long serialVersionUID = -3676185755730114344L;
    public static final int TEXT_ALIGN_LEFT = 0;
    public static final int TEXT_ALIGN_CENTER = 1;
    public static final int TEXT_ALIGN_RIGHT = 2;
    protected Color lineColor = Color.BLACK;
    protected String font = "Arial";
    protected Color textColor = Color.BLACK;
    protected int textStrength = 255;
    protected int watermarkStrength = 64;
    protected int textSize = 24;
    protected boolean italic = false;
    protected boolean bold = false;
    protected int alignment = 0;
    protected Color shadowColor = Color.BLACK;
    protected int shadowAngle = 45;
    protected int shadowDistance = 6;
    protected int shadowStrength = 128;
    protected boolean showShadow = false;
    protected boolean showWatermark = false;
    protected double lineSpacing = 0.0;
    protected String text = Msg.getString((Object)this, (String)"filters.text.welcomeText");
    protected Vector<String> lines = new Vector();
    protected String widestLine = "";

    public TextBox() {
        this(100, 100);
    }

    public TextBox(int width, int height, ResizableObjectPanel parentPanel) {
        this(width, height);
        this.parentPanel = parentPanel;
    }

    public TextBox(ResizableObjectPanel parentPanel) {
        this();
        this.parentPanel = parentPanel;
    }

    public TextBox(int width, int height) {
        super(width, height);
        this.X1 = 0.2;
        this.Y1 = 0.2;
        this.X2 = 0.6;
        this.Y2 = 0.6;
        this.initial = false;
        this.keepDimension = true;
        this.color = new Color(255, 255, 225, 127);
        this.repaintOnCursorChange = false;
        this.checkDimensions(true);
    }

    protected void paintHandles(Graphics g) {
    }

    protected int checkState(int x, int y) {
        int intX1 = (int)(this.OutX1 * (double)(this.width - 1));
        int intX2 = (int)(this.OutX2 * (double)(this.width - 1));
        int intY1 = (int)(this.OutY1 * (double)(this.height - 1));
        int intY2 = (int)(this.OutY2 * (double)(this.height - 1));
        if (x > intX1 && x < intX2 && y > intY1 && y < intY2) {
            return 1;
        }
        return 0;
    }

    protected void setMouseCursor(MouseEvent arg0) {
        this.position = this.checkState(arg0.getX(), arg0.getY());
        if (this.position == 0) {
            Cursor old = this.parentPanel.getCursor();
            this.parentPanel.setCursor(Cursor.getPredefinedCursor(2));
            if (old != this.parentPanel.getCursor()) {
                this.parentPanel.renderPreview();
            }
        } else {
            super.setMouseCursor(arg0);
        }
    }

    public void paint(Graphics g) {
        this.prepareTextDrawing(g, false);
        if (this.parentPanel.isShowOutline()) {
            g.setColor(this.color);
            int intX1 = (int)(this.OutX1 * (double)(this.width - 1));
            int intX2 = (int)(this.OutX2 * (double)(this.width - 1));
            int intY1 = (int)(this.OutY1 * (double)(this.height - 1));
            int intY2 = (int)(this.OutY2 * (double)(this.height - 1));
            g.setColor(this.lineColor);
            g.drawRect(intX1 - 4, intY1, intX2 - intX1 + 8, intY2 - intY1);
        }
        this.drawText(g);
    }

    public void paintSelected(Graphics g) {
        this.prepareTextDrawing(g, false);
        if (this.parentPanel.isShowOutline()) {
            int intX1 = (int)(this.OutX1 * (double)(this.width - 1));
            int intX2 = (int)(this.OutX2 * (double)(this.width - 1));
            int intY1 = (int)(this.OutY1 * (double)(this.height - 1));
            int intY2 = (int)(this.OutY2 * (double)(this.height - 1));
            g.setColor(this.color);
            g.fillRect(intX1 - 4, intY1, intX2 - intX1 + 8, intY2 - intY1);
            g.setColor(this.lineColor);
            g.drawRect(intX1 - 4, intY1, intX2 - intX1 + 8, intY2 - intY1);
        }
        this.drawText(g);
    }

    public void prepareTextDrawing(Graphics g, boolean finalRender) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int fontSetting = 0;
        if (this.italic) {
            fontSetting = 2;
        }
        if (this.bold) {
            fontSetting |= 1;
        }
        int renderFontSize = this.textSize;
        int comparisonFontSize = 48;
        g.setFont(new Font(this.font, fontSetting, 48));
        StringTokenizer tokenizer = new StringTokenizer(this.text, "\n");
        this.widestLine = "";
        int widestWidth = 0;
        this.lines.clear();
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            this.lines.add(line);
            if (g2d.getFontMetrics().stringWidth(line) <= widestWidth) continue;
            this.widestLine = line;
            widestWidth = g2d.getFontMetrics().stringWidth(this.widestLine);
        }
        if (widestWidth <= 0) {
            widestWidth = 1;
        }
        if (finalRender) {
            int desiredWidth = Math.round((float)((this.X2 - this.X1) * (double)(this.width - 1)));
            renderFontSize = 48 * desiredWidth / widestWidth;
        }
        g.setFont(new Font(this.font, fontSetting, renderFontSize));
        tokenizer = new StringTokenizer(this.text, "\n");
        int textWidth = 0;
        for (String line : this.lines) {
            textWidth = Math.max(textWidth, g2d.getFontMetrics().stringWidth(line));
        }
        if (!finalRender) {
            int textHeight = g2d.getFontMetrics().getHeight() * this.lines.size();
            this.X2 = this.X1 + (double)textWidth / (double)(this.width - 1);
            this.Y2 = this.Y1 + (double)textHeight / (double)(this.height - 1);
            this.checkDimensions(false);
        }
    }

    public void drawText(Graphics g) {
        boolean showShadow;
        int shadowAngle;
        int shadowDistance;
        Color textColor;
        Color shadowColor;
        int textStrength;
        int shadowStrength;
        if (this.showWatermark) {
            shadowStrength = this.watermarkStrength;
            textStrength = this.watermarkStrength;
            shadowColor = new Color(0, 0, 0);
            textColor = new Color(255, 255, 255);
            shadowDistance = 2;
            shadowAngle = 45;
            showShadow = true;
        } else {
            shadowColor = this.shadowColor;
            textStrength = this.textStrength;
            textColor = this.textColor;
            shadowDistance = this.shadowDistance;
            shadowAngle = this.shadowAngle;
            showShadow = this.showShadow;
            shadowStrength = this.shadowStrength;
        }
        int relativeShadowDistance = g.getFont().getSize() * shadowDistance / this.textSize;
        int shadownOffsetX = (int)((double)relativeShadowDistance * Math.cos(Math.toRadians(shadowAngle)));
        int shadownOffsetY = (int)((double)relativeShadowDistance * Math.sin(Math.toRadians(shadowAngle)));
        int intX1 = (int)(this.OutX1 * (double)(this.width - 1));
        int intY1 = (int)(this.OutY1 * (double)(this.height - 1));
        int rowCounter = 0;
        for (String line : this.lines) {
            int maxWidth = g.getFontMetrics().stringWidth(this.widestLine);
            int positionX = this.alignment == 2 ? intX1 + maxWidth - g.getFontMetrics().stringWidth(line) : (this.alignment == 1 ? intX1 + (maxWidth - g.getFontMetrics().stringWidth(line)) / 2 : intX1);
            int positionY = intY1 + g.getFontMetrics().getHeight() * rowCounter + g.getFontMetrics().getAscent();
            if (showShadow) {
                g.setColor(new Color(shadowColor.getRed(), shadowColor.getGreen(), shadowColor.getBlue(), shadowStrength));
                g.drawString(line, positionX + shadownOffsetX, positionY + shadownOffsetY);
            }
            g.setColor(new Color(textColor.getRed(), textColor.getGreen(), textColor.getBlue(), textStrength));
            g.drawString(line, positionX, positionY);
            ++rowCounter;
        }
    }

    public void update(double x1, double y1, double x2, double y2) {
        this.X1 = x1;
        this.Y1 = y1;
    }

    protected void checkDimensions(boolean changeOriginal) {
        if (this.X1 > this.X2) {
            this.OutX2 = this.X1;
            this.OutX1 = this.X2;
        } else {
            this.OutX1 = this.X1;
            this.OutX2 = this.X2;
        }
        if (this.Y1 > this.Y2) {
            this.OutY2 = this.Y1;
            this.OutY1 = this.Y2;
        } else {
            this.OutY1 = this.Y1;
            this.OutY2 = this.Y2;
        }
        if (this.OutX1 < 0.0) {
            this.OutX1 = 0.0;
        }
        if (this.OutX1 > 1.0) {
            this.OutX1 = 1.0;
        }
        if (this.OutY1 < 0.0) {
            this.OutY1 = 0.0;
        }
        if (this.OutY1 > 1.0) {
            this.OutY1 = 1.0;
        }
        if (changeOriginal) {
            this.X1 = this.OutX1;
            this.X2 = this.OutX2;
            this.Y1 = this.OutY1;
            this.Y2 = this.OutY2;
        }
    }

    protected void changeMousePosition(MouseEvent arg0) {
        int inputX = arg0.getX();
        int inputY = arg0.getY();
        if (this.state == 1) {
            if (!(this.X1 - this.OffsetX + (double)inputX / (double)(this.width - 1) < 0.0) && !(this.X2 - this.OffsetX + (double)inputX / (double)(this.width - 1) > 1.0) && (this.keepDimension || this.keepRatio || this.keepRatioKey) || !this.keepDimension && !this.keepRatio && !this.keepRatioKey) {
                this.X1 = this.X1 - this.OffsetX + (double)inputX / (double)(this.width - 1);
                this.X2 = this.X2 - this.OffsetX + (double)inputX / (double)(this.width - 1);
                this.OffsetX = (double)inputX / (double)(this.width - 1);
            } else {
                double correctionX = 0.0;
                if (this.X1 - this.OffsetX + (double)inputX / (double)(this.width - 1) < 0.0) {
                    correctionX = this.X1;
                    this.X1 = 0.0;
                    this.X2 -= correctionX;
                } else if (this.X2 - this.OffsetX + (double)inputX / (double)(this.width - 1) > 1.0) {
                    correctionX = 1.0 - this.X2;
                    this.X2 = 1.0;
                    this.X1 += correctionX;
                }
            }
            if (!(this.Y1 - this.OffsetY + (double)inputY / (double)(this.height - 1) < 0.0) && !(this.Y2 - this.OffsetY + (double)inputY / (double)(this.height - 1) > 1.0) && (this.keepDimension || this.keepRatio || this.keepRatioKey) || !this.keepDimension && !this.keepRatio && !this.keepRatioKey) {
                this.Y1 = this.Y1 - this.OffsetY + (double)inputY / (double)(this.height - 1);
                this.Y2 = this.Y2 - this.OffsetY + (double)inputY / (double)(this.height - 1);
                this.OffsetY = (double)inputY / (double)(this.height - 1);
            } else {
                double correctionY = 0.0;
                if (this.Y1 - this.OffsetY + (double)inputY / (double)(this.height - 1) < 0.0) {
                    correctionY = this.Y1;
                    this.Y1 = 0.0;
                    this.Y2 -= correctionY;
                } else if (this.Y2 - this.OffsetY + (double)inputY / (double)(this.height - 1) > 1.0) {
                    correctionY = 1.0 - this.Y2;
                    this.Y2 = 1.0;
                    this.Y1 += correctionY;
                }
            }
        }
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public int getTextStrength() {
        return this.textStrength;
    }

    public void setTextStrength(int textStrength) {
        this.textStrength = textStrength;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(Color shadowColor) {
        this.shadowColor = shadowColor;
    }

    public int getShadowAngle() {
        return this.shadowAngle;
    }

    public void setShadowAngle(int shadowAngle) {
        this.shadowAngle = shadowAngle;
    }

    public int getShadowDistance() {
        return this.shadowDistance;
    }

    public void setShadowDistance(int shadowDistance) {
        this.shadowDistance = shadowDistance;
    }

    public int getShadowStrength() {
        return this.shadowStrength;
    }

    public void setShadowStrength(int shadowStrength) {
        this.shadowStrength = shadowStrength;
    }

    public boolean isShowShadow() {
        return this.showShadow;
    }

    public void setShowShadow(boolean showShadow) {
        this.showShadow = showShadow;
    }

    public boolean isShowWatermark() {
        return this.showWatermark;
    }

    public void setShowWatermark(boolean showWatermark) {
        this.showWatermark = showWatermark;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getWatermarkStrength() {
        return this.watermarkStrength;
    }

    public void setWatermarkStrength(int watermarkStrength) {
        this.watermarkStrength = watermarkStrength;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }
}

