.highslide {
	cursor: url($resPath/graphics/zoomin.cur), pointer;
    outline: none;
}
.highslide img {
	border: $cssHSimgBorderWidth solid $cssHSimgBorder;
}
.highslide:hover img {
	border: $cssHSimgBorderWidth solid $cssHSimgBorderHover;
}
.highslide-overlay {
	display: none;
}
.highslide-image {
    border: solid $cssHSimageBorder;
}

.highslide-caption {
    display: none;
    color: $cssHScaptionFontColor;
    border: $cssHScaptionBorderWidth solid $cssHScaptionBorder;
    border-top: none;
    font-family: Verdana, Helvetica;
    font-size: $cssHScaptionFontSize;
    padding: 5px;
    background-color: $cssHScaptionFontBgColor;
}

.highslide-caption a {color: #2E8B57;}

.highslide-loading, a.highslide-loading:link {
   display: block;
   color: $cssHSloading;
   background-color: $cssHSloadingBG;
   font-size: $cssHSloadingText;
   font-weight: bold;
   text-transform: uppercase;
   text-decoration: none;
   padding: 3px;
   border-top: 1px solid $cssHSloading;
   border-bottom: 1px solid $cssHSloading;
   padding-left: 22px;
   background-image: url($resPath/graphics/loader.gif);
   background-repeat: no-repeat;
   background-position: 3px 1px;
}

a.highslide-credits, a.highslide-credits i {
    padding: 2px;
    color: silver;
    text-decoration: none;
	font-size: 10px;
}
a.highslide-credits:hover,
a.highslide-credits:hover i {
    color: white;
    background-color: gray;
}

.highslide-move {
    cursor: move;
}


/* Controlbar */
.controlbar {	
	background: url($resPath/graphics/controlbar4.gif);
	width: 167px;
	height: 34px;
}
.controlbar a {	
	display: block;
	float: left;
	/*margin: 0px 0 0 4px;*/	
	height: 27px;
}
.controlbar a:hover {
	background-image: url($resPath/graphics/controlbar4-hover.gif);
}
.controlbar .previous {
	width: 50px;
}
.controlbar .next {
	width: 40px;
	background-position: -50px 0;
}
.controlbar .highslide-move {
	width: 40px;
	background-position: -90px 0;
}
.controlbar .close {
	width: 36px;
	background-position: -130px 0;
}

.highslide-dimming {
background: ${dimmerColor};
position: absolute;
visibility: hidden;
} 

<ja:if test="$hsFullExpandOpacity">a.highslide-full-expand {
	background: url($resPath/graphics/fullexpand.gif) no-repeat;
	display: block;
	margin: 10px 10px 10px 10px;
	width: 34px;
	height: 34px;
}</ja:if>

<ja:if test="$hsHideThumbnail">.highslide-active-anchor img {
    visibility: hidden
}</ja:if>
.highslide-html {
    background-color: white;
}
.highslide-html-blur {
}
.highslide-html-content {
	position: absolute;
    display: none;
}
<ja:if test="$folderHS">
.highslide-wrapper {
	background-color: white;
}
.highslide-wrapper .highslide-html-content {
    width: 775px;
    padding: 5px;
}
.highslide-wrapper .highslide-header div {
}
.highslide-wrapper .highslide-header ul {
	margin: 0;
	padding: 0;
	text-align: right;
}
.highslide-wrapper .highslide-header ul li {
	display: inline;
	padding-left: 1em;
}
.highslide-wrapper .highslide-header ul li.highslide-previous, .highslide-wrapper .highslide-header ul li.highslide-next {
	display: none;
}
.highslide-wrapper .highslide-header a {
	font-weight: bold;
	color: gray;
	text-transform: uppercase;
	text-decoration: none;
}
.highslide-wrapper .highslide-header a:hover {
	color: black;
}
.highslide-wrapper .highslide-header .highslide-move a {
	cursor: move;
}
.highslide-wrapper .highslide-footer {
	height: 11px;
}
.highslide-wrapper .highslide-footer .highslide-resize {
	float: right;
	height: 11px;
	width: 11px;
	background: url($resPath/graphics/resize.gif);
}
.highslide-wrapper .highslide-body {
}
.highslide-move {
    cursor: move;
}
.highslide-resize {
    cursor: nw-resize;
}
.highslide-wrapper .highslide-header {
   height: 25px;
}
</ja:if>
<ja:if test="$folderHStitle">
.highslide-overlay-title {
   text-align: center;
   background: white; 
   font-weight: bold; 
   font-size: 12pt;
   color: black;
   padding: 2px;
}
</ja:if>
<ja:if test="$showExif">
.highslide-overlay-exif {
   text-align: center;
   background: $cssHSexifBG; 
   font-size: $cssHSexifText;
   color: $cssHSexif;
   padding: 2px;
}
</ja:if>
/* Necessary for functionality */
.highslide-display-block {
    display: block;
}
.highslide-display-none {
    display: none;
}
