/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

class SizeGrip
extends JPanel {
    private Image osxSizeGrip;

    public SizeGrip() {
        MouseHandler mouseHandler = new MouseHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.possiblyFixCursor(ComponentOrientation.getOrientation(this.getLocale()));
        this.setPreferredSize(new Dimension(16, 16));
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        this.possiblyFixCursor(componentOrientation);
        super.applyComponentOrientation(componentOrientation);
    }

    private Image createOSXSizeGrip() {
        Object object;
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource("org/fife/ui/autocomplete/osx_sizegrip.png");
        if (uRL == null) {
            object = new File("../AutoComplete/src/org/fife/ui/autocomplete/osx_sizegrip.png");
            if (((File)object).isFile()) {
                try {
                    uRL = ((File)object).toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return null;
                }
            } else {
                return null;
            }
        }
        object = null;
        try {
            object = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        Color color = UIManager.getColor("Label.disabledShadow");
        Color color2 = UIManager.getColor("Label.disabledForeground");
        if (this.osxSizeGrip != null) {
            graphics.drawImage(this.osxSizeGrip, dimension.width - 16, dimension.height - 16, null);
            return;
        }
        ComponentOrientation componentOrientation = this.getComponentOrientation();
        if (componentOrientation.isLeftToRight()) {
            int n = dimension.width -= 3;
            int n2 = dimension.height -= 3;
            graphics.setColor(color);
            graphics.fillRect(n - 9, n2 - 1, 3, 3);
            graphics.fillRect(n - 5, n2 - 1, 3, 3);
            graphics.fillRect(n - 1, n2 - 1, 3, 3);
            graphics.fillRect(n - 5, n2 - 5, 3, 3);
            graphics.fillRect(n - 1, n2 - 5, 3, 3);
            graphics.fillRect(n - 1, n2 - 9, 3, 3);
            graphics.setColor(color2);
            graphics.fillRect(n - 9, n2 - 1, 2, 2);
            graphics.fillRect(n - 5, n2 - 1, 2, 2);
            graphics.fillRect(n - 1, n2 - 1, 2, 2);
            graphics.fillRect(n - 5, n2 - 5, 2, 2);
            graphics.fillRect(n - 1, n2 - 5, 2, 2);
            graphics.fillRect(n - 1, n2 - 9, 2, 2);
        } else {
            int n = dimension.height -= 3;
            graphics.setColor(color);
            graphics.fillRect(10, n - 1, 3, 3);
            graphics.fillRect(6, n - 1, 3, 3);
            graphics.fillRect(2, n - 1, 3, 3);
            graphics.fillRect(6, n - 5, 3, 3);
            graphics.fillRect(2, n - 5, 3, 3);
            graphics.fillRect(2, n - 9, 3, 3);
            graphics.setColor(color2);
            graphics.fillRect(10, n - 1, 2, 2);
            graphics.fillRect(6, n - 1, 2, 2);
            graphics.fillRect(2, n - 1, 2, 2);
            graphics.fillRect(6, n - 5, 2, 2);
            graphics.fillRect(2, n - 5, 2, 2);
            graphics.fillRect(2, n - 9, 2, 2);
        }
    }

    protected void possiblyFixCursor(ComponentOrientation componentOrientation) {
        int n = 7;
        if (componentOrientation.isLeftToRight()) {
            n = 6;
        }
        if (n != this.getCursor().getType()) {
            this.setCursor(Cursor.getPredefinedCursor(n));
        }
    }

    public void updateUI() {
        super.updateUI();
        if (System.getProperty("os.name").indexOf("OS X") > -1) {
            if (this.osxSizeGrip == null) {
                this.osxSizeGrip = this.createOSXSizeGrip();
            }
        } else {
            this.osxSizeGrip = null;
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private Point origPos;

        private MouseHandler() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, SizeGrip.this);
            int n = point.x - this.origPos.x;
            int n2 = point.y - this.origPos.y;
            Window window = SwingUtilities.getWindowAncestor(SizeGrip.this);
            if (window != null) {
                int n3 = window.getWidth();
                if (point.x >= window.getX()) {
                    n3 += n;
                }
                int n4 = window.getHeight();
                if (point.y >= window.getY()) {
                    n4 += n2;
                }
                window.setSize(n3, n4);
                window.invalidate();
                window.validate();
            }
            this.origPos.setLocation(point);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.origPos = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(this.origPos, SizeGrip.this);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.origPos = null;
        }
    }
}

