/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.io.DocumentReader;
import org.fife.ui.rsyntaxtextarea.Parser;
import org.fife.ui.rsyntaxtextarea.ParserNotice;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

class ParserManager
implements DocumentListener {
    private RSyntaxTextArea textArea;
    private Parser parser;
    private Timer timer;
    private TimerTask task;
    private boolean needsReparsing;
    private static final boolean DEBUG_PARSING = true;
    private static final int TIMER_DELAY_MS = 3000;

    public ParserManager(RSyntaxTextArea rSyntaxTextArea) {
        this.textArea = rSyntaxTextArea;
        ToolTipManager.sharedInstance().registerComponent(rSyntaxTextArea);
        rSyntaxTextArea.getDocument().addDocumentListener(this);
        this.timer = new Timer();
    }

    private void cancelTask() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent(documentEvent);
    }

    public Parser getParser() {
        return this.parser;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.textArea.viewToModel(mouseEvent.getPoint());
        Iterator iterator = this.parser.getNoticeIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ParserNotice parserNotice = (ParserNotice)iterator.next();
                if (!parserNotice.containsPosition(n)) continue;
                return parserNotice.getMessage();
            }
        }
        return null;
    }

    public void handleDocumentEvent(DocumentEvent documentEvent) {
        if (!this.needsReparsing) {
            this.needsReparsing = true;
        } else {
            this.cancelTask();
            this.scheduleTask();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent(documentEvent);
    }

    private void scheduleTask() {
        this.task = new ParseDocumentTask();
        this.timer.schedule(this.task, 3000L);
    }

    public void setParser(Parser parser) {
        this.cancelTask();
        this.parser = parser;
        if (parser != null) {
            this.needsReparsing = true;
            this.scheduleTask();
        }
    }

    public void stopParsing() {
        this.textArea.getDocument().removeDocumentListener(this);
        ToolTipManager.sharedInstance().unregisterComponent(this.textArea);
        this.setParser(null);
    }

    class UpdateTextAreaRunnable
    implements Runnable {
        UpdateTextAreaRunnable() {
        }

        public void run() {
            ParserManager.this.textArea.refreshParserNoticeHighlights(ParserManager.this.parser.getNoticeIterator());
        }
    }

    private class ParseDocumentTask
    extends TimerTask {
        private ParseDocumentTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!ParserManager.this.needsReparsing) {
                System.err.println("Parsing skipped; not needed");
                return;
            }
            long l = 0L;
            l = System.currentTimeMillis();
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)ParserManager.this.textArea.getDocument();
            rSyntaxDocument.readLock();
            try {
                DocumentReader documentReader = new DocumentReader(rSyntaxDocument);
                ParserManager.this.parser.parse(documentReader);
                ParserManager.this.needsReparsing = false;
                documentReader.close();
            }
            finally {
                rSyntaxDocument.readUnlock();
            }
            float f = (float)(System.currentTimeMillis() - l) / 1000.0f;
            System.err.println("Parsing took: " + f + " seconds");
            SwingUtilities.invokeLater(new UpdateTextAreaRunnable());
        }
    }
}

