/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters.components;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class ExportableSlider
extends JSlider
implements PropertyChangeListener {
    private static final long serialVersionUID = 6664565110127768655L;
    public int start;
    public int increment;
    public Hashtable table;
    public boolean startAtMin;

    public ExportableSlider() {
    }

    public ExportableSlider(int orientation) {
        super(orientation);
    }

    public ExportableSlider(BoundedRangeModel brm) {
        super(brm);
    }

    public ExportableSlider(int min, int max) {
        super(min, max);
    }

    public ExportableSlider(int min, int max, int value) {
        super(min, max, value);
    }

    public ExportableSlider(int orientation, int min, int max, int value) {
        super(orientation, min, max, value);
    }

    public Hashtable createStandardLabels(int increment, int start) {
        if (start > this.getMaximum() || start < this.getMinimum()) {
            throw new IllegalArgumentException("Slider label start point out of range.");
        }
        if (increment <= 0) {
            throw new IllegalArgumentException("Label incremement must be > 0");
        }
        this.start = start;
        this.increment = increment;
        this.startAtMin = start == this.getMinimum();
        Hashtable table = this.createLabels();
        if (this.getLabelTable() != null && this.getLabelTable() instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)this.getLabelTable()));
        }
        return table;
    }

    Hashtable createLabels() {
        this.table = new Hashtable();
        int labelIndex = this.start;
        while (labelIndex <= this.getMaximum()) {
            JLabel label = new JLabel("" + labelIndex, 0);
            label.setName("Slider.label");
            this.table.put(new Integer(labelIndex), label);
            labelIndex += this.increment;
        }
        return this.table;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("minimum") && this.startAtMin) {
            this.start = this.getMinimum();
        }
        if (e.getPropertyName().equals("minimum") || e.getPropertyName().equals("maximum")) {
            Enumeration keys = this.getLabelTable().keys();
            Object key = null;
            Hashtable hashtable = new Hashtable();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                Object value = this.getLabelTable().get(key);
                if (value instanceof JLabel) continue;
                hashtable.put(key, value);
            }
            this.table.clear();
            this.table = this.createLabels();
            keys = hashtable.keys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                this.table.put(key, hashtable.get(key));
            }
            ((JSlider)e.getSource()).setLabelTable(this.table);
        }
    }
}

