/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class AutoSelectingTreeCellEditor
extends DefaultTreeCellEditor {
    public boolean ignoreFocusLost = false;
    public boolean rootEditable = false;

    public AutoSelectingTreeCellEditor(JTree p0, DefaultTreeCellRenderer p1) {
        super(p0, p1);
        DefaultCellEditor editor = (DefaultCellEditor)this.realEditor;
        editor.getComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Component src = e.getComponent();
                if (src != null && src instanceof JTextComponent) {
                    JTextComponent textField = (JTextComponent)src;
                    textField.setText(textField.getText());
                    textField.selectAll();
                }
            }

            public void focusLost(FocusEvent e) {
                if (!AutoSelectingTreeCellEditor.this.ignoreFocusLost) {
                    AutoSelectingTreeCellEditor.this.stopCellEditing();
                }
            }
        });
    }

    public boolean isCellEditable(EventObject event) {
        TreePath path;
        if (event != null && event.getSource() instanceof JTree && event instanceof MouseEvent && ((path = this.tree.getPathForLocation(((MouseEvent)event).getX(), ((MouseEvent)event).getY())) == null || path.getPathCount() == 1 && !this.rootEditable)) {
            return false;
        }
        return super.isCellEditable(event);
    }

    protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (this.renderer != null) {
            JLabel label = (JLabel)this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
            this.editingIcon = label.getIcon();
            this.offset = this.editingIcon != null ? this.renderer.getIconTextGap() + this.editingIcon.getIconWidth() : this.renderer.getIconTextGap();
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }
}

