/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.border.AbstractBorder;
import se.datadosen.component.JSmartButton;

public class JLinkButton
extends JSmartButton {
    private String url;

    public JLinkButton() {
        this.init();
    }

    public JLinkButton(Action action) {
        super(action);
        this.init();
    }

    private void init() {
        this.setBorder(new LinkButtonBorder());
        this.setBorderPainted(false);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent event) {
                JLinkButton.this.setBorderPainted(true);
            }

            public void mouseExited(MouseEvent event) {
                JLinkButton.this.setBorderPainted(false);
            }

            public void mousePressed(MouseEvent arg0) {
                JLinkButton.this.setBorderPainted(false);
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (JLinkButton.this.url != null) {
                    try {
                        BrowserLauncher.openURL(JLinkButton.this.url);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private static class LinkButtonBorder
    extends AbstractBorder {
        private LinkButtonBorder() {
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(3, 6, 3, 6);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics gg, int x, int y, int width, int height) {
            Graphics2D g = (Graphics2D)gg;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int r = 5;
            g.setColor(new Color(0, 0, 0, 8));
            g.fillRoundRect(x, y, width - 1, height - 1, 5, 5);
            g.setColor(new Color(0, 0, 0, 90));
            g.drawRoundRect(x, y, width - 1, height - 1, 5, 5);
        }
    }
}

