/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.border.Border;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.FilterManager;
import net.jalbum.filterManager.FilterManagerFriend;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JGlassButton;
import se.datadosen.component.JHeadingPanel;
import se.datadosen.component.JLineSplitPane;
import se.datadosen.component.JProgressSpinner;
import se.datadosen.explorer.ImageCache;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.explorer.JCommentPanel;
import se.datadosen.explorer.JFiltersPanel;
import se.datadosen.explorer.JPropertyPanel;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.EditListener;
import se.datadosen.jalbum.EditPanel;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Debug;
import se.datadosen.util.FileFilters;
import se.datadosen.util.annotations.ToolTipText;

public class JEditPanel
extends JPanel
implements EditPanel,
FilterManagerFriend {
    public static final String NAME = "editPanel";
    private static final int CROSS_PADDING = 20;
    private final JAlbumExplorer context;
    final KeyStroke pgUp = KeyStroke.getKeyStroke(33, 0);
    final KeyStroke pgDown = KeyStroke.getKeyStroke(34, 0);
    final KeyStroke up = KeyStroke.getKeyStroke(38, 0);
    final KeyStroke down = KeyStroke.getKeyStroke(40, 0);
    final KeyStroke left = KeyStroke.getKeyStroke(37, 0);
    final KeyStroke right = KeyStroke.getKeyStroke(39, 0);
    final KeyStroke escape = KeyStroke.getKeyStroke(27, 0);
    AlbumObject ao;
    ControlPanel metaPanel = new ControlPanel();
    JPanel centerPanel = new JPanel();
    JBackgroundPanel imagePanel;
    JPanel glassPanel = new JPanel(new BorderLayout());
    JProgressSpinner progressSpinner = new JProgressSpinner(36);
    JScrollPane imageScrollPane = new JMyScrollPane();
    JSplitPane vSplitPane = new JSplitPane(0);
    private final CardLayout filterPanelViewMode = new CardLayout();
    JPanel filterPanel = new JPanel(this.filterPanelViewMode);
    JFiltersPanel filtersPanel = new JFiltersPanel(this);
    FilterManager filterManager = new FilterManager(this);
    JAlbumImageFilter currentFilter;
    JHeadingPanel filterUIHeadingPanel;
    JPanel filterUIContainer = new JPanel(new BorderLayout());
    JPanel filterUI;
    JScrollPane filterScrollPane = new JScrollPane(20, 31);
    JPanel filterManagerControls;
    JCommentPanel commentPanel = new JCommentPanel(this);
    JPropertyPanel propertyPanel = new JPropertyPanel(this);
    JSplitPane hSplitPane = new JSplitPane(1);
    JSlider zoomSlider = new JSlider(0, 0, 100, 0);
    @ToolTipText(value="edit.previousImageToolTip")
    public Action previousImageAction = new AbstractAction(){
        {
            this.putValue("AcceleratorKey", JEditPanel.this.pgUp);
            this.putValue("SmallIcon", Icons.getIcon("big.previous"));
        }

        public void actionPerformed(ActionEvent evt) {
            JEditPanel.this.commentPanel.save();
            JEditPanel.this.propertyPanel.save();
            JAlbumObject dest = JEditPanel.this.getPreviousComponent();
            if (dest != null) {
                JEditPanel.this.moveTo(dest.ao);
                JAlbumObject previous = JEditPanel.this.getPreviousComponent(dest.ao);
                ((JEditPanel)JEditPanel.this).context.imageCache.preload(previous != null ? previous.ao : null);
            }
        }
    };
    @ToolTipText(value="edit.nextImageToolTip")
    public Action nextImageAction = new AbstractAction(){
        {
            this.putValue("AcceleratorKey", JEditPanel.this.pgDown);
            this.putValue("SmallIcon", Icons.getIcon("big.next"));
        }

        public void actionPerformed(ActionEvent evt) {
            JEditPanel.this.commentPanel.save();
            JEditPanel.this.propertyPanel.save();
            JAlbumObject dest = JEditPanel.this.getNextComponent();
            if (dest != null) {
                JEditPanel.this.moveTo(dest.ao);
                JAlbumObject next = JEditPanel.this.getNextComponent(dest.ao);
                ((JEditPanel)JEditPanel.this).context.imageCache.preload(next != null ? next.ao : null);
            }
        }
    };
    @ToolTipText(value="edit.leaveTooltip")
    Action cancelAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.getIcon("big.return"));
        }

        public void actionPerformed(ActionEvent evt) {
            JEditPanel.this.context.setExplorerView();
        }
    };
    JGlassButton previousButton = new JGlassButton(this.previousImageAction);
    JGlassButton nextButton = new JGlassButton(this.nextImageAction);
    JGlassButton returnButton = new JGlassButton(this.cancelAction);
    FileFilters.BasicImageInfo imageInfo;
    BufferedImage bufferedImage;
    MouseConverter mouseConverter = new MouseConverter();
    private transient Vector<EditListener> editListeners;

    public JEditPanel(JAlbumExplorer context) {
        this.context = context;
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAO(AlbumObject ao) {
        this.ao = ao;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.commentPanel.setAlbumObject(ao);
            this.propertyPanel.setAlbumObject(ao);
            this.fireEditingAlbumObject(ao);
            if (ao.isDisplayableImage()) {
                this.imageInfo = FileFilters.getBasicImageInfo(ao.getFile());
            }
            this.refreshUI();
        }
        catch (IOException iOException) {
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public AlbumObject getAO() {
        return this.ao;
    }

    void moveTo(AlbumObject dest) {
        if (dest == null) {
            return;
        }
        this.setAO(dest);
    }

    void setFiltersViewMode() {
        this.filterPanelViewMode.show(this.filterPanel, "filtersPanel");
    }

    private JAlbumObject getPreviousComponent(AlbumObject ao) {
        return this.context.explorer.getPreviousComponent(this.context.getJAlbumObject(ao));
    }

    private JAlbumObject getPreviousComponent() {
        return this.getPreviousComponent(this.ao);
    }

    private JAlbumObject getNextComponent(AlbumObject ao) {
        return this.context.explorer.getNextComponent(this.context.getJAlbumObject(ao));
    }

    private JAlbumObject getNextComponent() {
        return this.getNextComponent(this.ao);
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.text);
        this.setFocusable(true);
        this.filtersPanel.setFocusable(false);
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.setBackground(SystemColor.text);
        this.setToolTipText(Msg.get("edit.tipLabel"));
        this.setPreferredSize(new Dimension(760, 600));
        this.filterPanel.add((Component)this.filtersPanel, "filtersPanel");
        this.filterPanel.add((Component)this.filterUIContainer, "filterUI");
        this.filterScrollPane.setBorder(null);
        this.filterScrollPane.setOpaque(false);
        this.filterScrollPane.getViewport().setOpaque(false);
        Color borderColor = new Color(165, 165, 165);
        this.vSplitPane.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, borderColor));
        this.vSplitPane.setTopComponent(this.filterPanel);
        this.vSplitPane.setResizeWeight(1.0);
        this.vSplitPane.setBottomComponent(this.propertyPanel);
        this.previousButton.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.previousButton.setBorderRadius(8);
        this.previousButton.setBorderOpacity(0.35f);
        this.nextButton.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.nextButton.setBorderRadius(8);
        this.nextButton.setBorderOpacity(0.35f);
        this.returnButton.setBorder(BorderFactory.createEmptyBorder(14, 16, 14, 12));
        this.returnButton.setBorderRadius(8);
        this.returnButton.setBorderOpacity(0.35f);
        this.returnButton.setDiscrete(true);
        this.previousButton.setDiscrete(true);
        this.nextButton.setDiscrete(true);
        this.registerKeyboardAction(this.cancelAction, "cancel-dialog", this.escape, 2);
        this.registerKeyboardAction(this.previousImageAction, "pgUpAction", this.pgUp, 1);
        this.registerKeyboardAction(this.nextImageAction, "pgDownAction", this.pgDown, 1);
        this.registerKeyboardAction(this.previousImageAction, "pgUpAction", this.up, 1);
        this.registerKeyboardAction(this.nextImageAction, "pgDownAction", this.down, 1);
        this.registerKeyboardAction(this.previousImageAction, "pgUpAction", this.left, 1);
        this.registerKeyboardAction(this.nextImageAction, "pgDownAction", this.right, 1);
        this.hSplitPane.setBorder(null);
        this.hSplitPane.setBackground(SystemColor.text);
        this.imagePanel = new JBackgroundPanel();
        this.imagePanel.setBackground(SystemColor.text);
        this.centerPanel.setOpaque(true);
        this.imagePanel.setImageBorder(this.createImageBorder());
        MouseAdapter ml = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                JEditPanel.this.returnButton.setVisible(true);
                JEditPanel.this.previousButton.setVisible(true);
                JEditPanel.this.nextButton.setVisible(true);
            }

            public void mouseExited(MouseEvent e) {
                if (!JEditPanel.this.glassPanel.getBounds().contains(e.getPoint())) {
                    JEditPanel.this.returnButton.setVisible(false);
                    JEditPanel.this.previousButton.setVisible(false);
                    JEditPanel.this.nextButton.setVisible(false);
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getSource() instanceof JComponent) {
                    ((JComponent)e.getSource()).requestFocusInWindow();
                }
                JEditPanel.this.requestFocusInWindow();
            }
        };
        this.addMouseListener(ml);
        this.centerPanel.addMouseListener(ml);
        this.imagePanel.addMouseListener(ml);
        this.imageScrollPane.setViewportView(this.imagePanel);
        this.imageScrollPane.getViewport().setScrollMode(2);
        this.imageScrollPane.setBorder(null);
        JPanel overlayPanel = new JPanel();
        overlayPanel.setOpaque(false);
        this.imageScrollPane.getViewport().setOpaque(false);
        overlayPanel.setLayout(new OverlayLayout(overlayPanel));
        this.glassPanel.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
        this.glassPanel.setOpaque(false);
        Box west = Box.createHorizontalBox();
        this.previousButton.setAlignmentY(0.5f);
        west.add(this.previousButton);
        this.glassPanel.add((Component)west, "West");
        Box east = Box.createHorizontalBox();
        this.nextButton.setAlignmentY(0.5f);
        east.add(this.nextButton);
        this.glassPanel.add((Component)east, "East");
        Box north = Box.createVerticalBox();
        this.returnButton.setAlignmentX(0.5f);
        north.add(this.returnButton);
        this.glassPanel.add((Component)north, "North");
        overlayPanel.add(this.glassPanel);
        overlayPanel.add(this.imageScrollPane);
        this.imageScrollPane.getViewport().setOpaque(false);
        JLineSplitPane split = new JLineSplitPane(0);
        split.setTopComponent(overlayPanel);
        split.setBottomComponent(this.commentPanel);
        split.setResizeWeight(1.0);
        split.setBorder(null);
        this.centerPanel.add((Component)split, "Center");
        this.hSplitPane.setLeftComponent(this.centerPanel);
        this.hSplitPane.setRightComponent(this.vSplitPane);
        this.hSplitPane.setDividerSize(3);
        this.hSplitPane.setResizeWeight(1.0);
        this.add((Component)this.hSplitPane, "Center");
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().downFocusCycle(JEditPanel.this);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        Msg.maintainTranslated(this);
    }

    private Border createImageBorder() {
        return BorderFactory.createLineBorder(new Color(96, 96, 96));
    }

    private void refreshUI() throws IOException {
        this.context.updateRotateActions(this.ao);
        this.updateImage(true);
        this.enableImageBrowseActions();
        this.filtersPanel.setEnabled(!this.ao.isFolder() && this.ao.isDisplayableImage());
        this.context.parent.statusBar.setText(Msg.get("ui.editModeStatusText", this.ao.getFile().getName()));
        this.context.parent.setTitle();
    }

    void updateImage(boolean loadStack) throws IOException {
        this.imagePanel.setBackgroundImage(null);
        if (this.ao == null) {
            return;
        }
        if (this.ao.isDisplayableImage()) {
            if (loadStack) {
                AlbumObjectProperties props = this.ao.getProperties();
                Object stack = props.get("filterList");
                if (stack != null) {
                    this.filterManager.setFilterList((FilterList)stack);
                } else {
                    this.filterManager.setFilterList(null);
                }
            }
            Image closeup = this.context.imageCache.getImage(this.ao);
            this.filterManager.setImage((BufferedImage)closeup, this.filterManager.getFilterList());
            closeup = this.scaleToFit(closeup, this.imagePanel.getDisplayableImageSize());
            if (this.filterManager.hasFiltersInList()) {
                closeup = this.filterManager.renderImage((BufferedImage)closeup, true);
            }
            this.imagePanel.setBackgroundImage(closeup);
        } else {
            Image closeup = this.ao.getRepresentingIcon(this.imagePanel.getDisplayableImageSize(), false).getImage();
            this.imagePanel.setBackgroundImage(closeup);
        }
        this.imagePanel.repaint();
    }

    void saveFilters() {
        AlbumObjectProperties props = this.ao.getProperties();
        props.putHidden("filterList", this.filterManager.getFilterList());
        props.save();
        BufferedImage thumbnail = this.filterManager.renderImage(this.bufferedImage, true);
        try {
            this.ao.setRepresentingIcon(thumbnail, true);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private Image scaleToFit(Image image, Dimension boundingBox) {
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        if (newWidth < width && newHeight < height) {
            return ImageCache.scale(image, newWidth, newHeight);
        }
        return image;
    }

    void useFilter(JAlbumImageFilter filter) {
        this.currentFilter = filter;
        this.setImageInFilter();
        this.filterManager.addFilter(filter);
        this.imagePanel.addMouseListener(this.mouseConverter);
        this.imagePanel.addMouseMotionListener(this.mouseConverter);
        this.imagePanel.addMouseWheelListener(this.mouseConverter);
        this.imagePanel.addKeyListener(filter);
        this.cancelAction.setEnabled(false);
        this.glassPanel.setVisible(false);
        this.switchFilterUIHeading(filter.getProperties().getShortName());
        this.switchFilterUI(this.filterManager.getFilterControls());
        this.disableImageBrowseActions();
        this.switchFilterManagerControls(this.filterManager.getFilterManagerControls());
        this.filtersPanel.setUndoRedoEnabled(false);
        this.context.setTopBarActionsEnabled(false);
        this.commentPanel.setFocusable(false);
        this.propertyPanel.setFocusable(false);
        this.filterPanelViewMode.show(this.filterPanel, "filterUI");
        this.validate();
        this.commentPanel.setFocusable(true);
        this.propertyPanel.setFocusable(true);
    }

    void setImageInFilter() {
        try {
            this.bufferedImage = (BufferedImage)this.context.imageCache.getImage(this.ao);
            this.filterManager.setImage(this.bufferedImage, this.filterManager.getFilterList());
        }
        catch (IOException ex) {
            Debug.showErrorDialog(this, ex);
        }
    }

    private void switchFilterUIHeading(String heading) {
        if (this.filterUIHeadingPanel != null) {
            this.filterUIContainer.remove(this.filterUIHeadingPanel);
        }
        this.filterUIHeadingPanel = new JHeadingPanel(heading);
        this.filterUIContainer.add((Component)this.filterUIHeadingPanel, "North");
    }

    private void switchFilterUI(JPanel filterControls) {
        if (this.filterUI != null) {
            this.filterUIContainer.remove(this.filterScrollPane);
        }
        this.filterUI = filterControls;
        if (this.filterUI != null) {
            this.filterScrollPane.setViewportView(this.filterUI);
            this.filterUIContainer.add((Component)this.filterScrollPane, "Center");
        }
    }

    private void switchFilterManagerControls(JPanel managerControls) {
        if (this.filterManagerControls != null) {
            this.filterUIContainer.remove(this.filterManagerControls);
        }
        this.filterManagerControls = managerControls;
        if (this.filterManagerControls != null) {
            this.filterUIContainer.add((Component)this.filterManagerControls, "South");
        }
    }

    private void disableImageBrowseActions() {
        this.nextImageAction.setEnabled(false);
        this.propertyPanel.nextImage.setEnabled(false);
        this.previousImageAction.setEnabled(false);
        this.propertyPanel.previousImage.setEnabled(false);
    }

    private void enableImageBrowseActions() {
        boolean hasNext = this.getNextComponent() != null;
        boolean hasPrevious = this.getPreviousComponent() != null;
        this.nextImageAction.setEnabled(hasNext);
        this.propertyPanel.nextImage.setEnabled(hasNext);
        this.previousImageAction.setEnabled(hasPrevious);
        this.propertyPanel.previousImage.setEnabled(hasPrevious);
    }

    public BufferedImage scaleImage(BufferedImage bi) {
        AlbumImage ai = new AlbumImage(bi, this.context.parent.engine);
        ai = ai.scaleToFit(this.imagePanel.getDisplayableImageSize());
        return (BufferedImage)ai.getImage();
    }

    public void filterMenuClosed(BufferedImage bi, boolean saveBeforeClose) {
        this.setImage(bi);
        if (this.filterUI != null) {
            this.filterUIContainer.remove(this.filterScrollPane);
            this.filterUI = null;
        }
        if (this.filterManagerControls != null) {
            this.filterUIContainer.remove(this.filterManagerControls);
            this.filterManagerControls = null;
        }
        this.filterPanelViewMode.show(this.filterPanel, "filtersPanel");
        this.enableImageBrowseActions();
        if (saveBeforeClose) {
            this.saveFilters();
        }
        this.filtersPanel.setUndoRedoEnabled(true);
        this.context.setTopBarActionsEnabled(true);
        this.cancelAction.setEnabled(true);
        this.glassPanel.setVisible(true);
        this.cleanFilterListeners();
        this.currentFilter = null;
        this.validate();
        this.requestFocusInWindow();
    }

    protected void cleanFilterListeners() {
        if (this.currentFilter != null) {
            this.imagePanel.removeMouseListener(this.mouseConverter);
            this.imagePanel.removeMouseMotionListener(this.mouseConverter);
            this.imagePanel.removeMouseWheelListener(this.mouseConverter);
            this.imagePanel.removeKeyListener(this.currentFilter);
        }
    }

    public void setImage(BufferedImage bi) {
        this.imagePanel.setBackgroundImage(bi);
        this.imagePanel.repaint();
    }

    public JComponent getImageComponent() {
        return this.imagePanel;
    }

    public Point getImageCoordinates(MouseEvent e) {
        int width = this.bufferedImage.getWidth();
        int height = this.bufferedImage.getHeight();
        Dimension boundingBox = this.imagePanel.getDisplayableImageSize();
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        float xDistance = (float)((boundingBox.getWidth() - (double)newWidth) / 2.0);
        float yDistance = (float)((boundingBox.getHeight() - (double)newHeight) / 2.0);
        Point p = e.getPoint();
        int tx = (int)((double)p.x * maxScale - (double)xDistance);
        int ty = (int)((double)p.y * maxScale - (double)yDistance);
        return new Point(tx, ty);
    }

    public synchronized void addEditListener(EditListener l) {
        Vector v;
        Vector vector = v = this.editListeners == null ? new Vector(2) : (Vector)this.editListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            if (this.ao != null) {
                l.setAlbumObject(this.ao);
            }
            this.editListeners = v;
        }
    }

    public void removeEditListener(EditListener l) {
        if (this.editListeners != null && this.editListeners.contains(l)) {
            Vector v = (Vector)this.editListeners.clone();
            v.removeElement(l);
            this.editListeners = v;
        }
    }

    protected void fireEditingAlbumObject(AlbumObject ao) {
        if (this.editListeners != null) {
            for (EditListener listener : this.editListeners) {
                listener.setAlbumObject(ao);
            }
        }
    }

    public void addCustomTab(String title, JComponent panel) {
        this.propertyPanel.addTab(title, panel);
    }

    public void removeCustomTab(JComponent panel) {
        this.propertyPanel.removeTab(panel);
    }

    class MyViewPort
    extends JViewport {
        Point p1 = new Point();
        Point p2 = new Point();

        MyViewPort() {
        }

        public void paint(Graphics g2d) {
            Graphics2D g = (Graphics2D)g2d;
            super.paint(g);
            if (JEditPanel.this.ao != null && !JEditPanel.this.ao.isIncluded()) {
                Image crossImage = JAlbumObject.getCrossImage();
                g.drawImage(crossImage, JEditPanel.this.imagePanel.getImageTopCornerXCoordinate() + 20, JEditPanel.this.imagePanel.getImageTopCornerYCoordinate() + 20, null);
            }
            if (JEditPanel.this.glassPanel.isVisible()) {
                JEditPanel.this.returnButton.setDiscrete(false);
                JEditPanel.this.previousButton.setDiscrete(false);
                JEditPanel.this.nextButton.setDiscrete(false);
                this.paintComponent(JEditPanel.this.returnButton, g);
                this.paintComponent(JEditPanel.this.previousButton, g);
                this.paintComponent(JEditPanel.this.nextButton, g);
                JEditPanel.this.returnButton.setDiscrete(true);
                JEditPanel.this.previousButton.setDiscrete(true);
                JEditPanel.this.nextButton.setDiscrete(true);
            }
        }

        private void paintComponent(JComponent comp, Graphics2D g) {
            AffineTransform at = g.getTransform();
            int x = 0;
            int y = 0;
            Point p = null;
            Container c = comp;
            do {
                p = ((Component)c).getLocation(p);
                x += p.x;
                y += p.y;
            } while (c != JEditPanel.this.glassPanel && (c = c.getParent()) != null);
            g.translate(x, y);
            comp.paint(g);
            g.setTransform(at);
        }
    }

    class JMyScrollPane
    extends JScrollPane {
        protected JViewport createViewport() {
            return new MyViewPort();
        }
    }

    class MouseConverter
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        MouseConverter() {
        }

        private MouseEvent convertMouseEvent(MouseEvent e) {
            Point p = JEditPanel.this.getImageCoordinates(e);
            MouseEvent correctedEvent = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), (int)p.getX(), (int)p.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            return correctedEvent;
        }

        public void mouseClicked(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseClicked(this.convertMouseEvent(e));
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseEntered(this.convertMouseEvent(e));
            }
        }

        public void mouseExited(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseExited(this.convertMouseEvent(e));
            }
        }

        public void mousePressed(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mousePressed(this.convertMouseEvent(e));
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseReleased(this.convertMouseEvent(e));
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseDragged(this.convertMouseEvent(e));
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                JEditPanel.this.currentFilter.mouseMoved(this.convertMouseEvent(e));
            }
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (JEditPanel.this.currentFilter != null) {
                Point p = JEditPanel.this.getImageCoordinates(e);
                MouseWheelEvent correctedEvent = new MouseWheelEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), (int)p.getX(), (int)p.getY(), e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
                JEditPanel.this.currentFilter.mouseWheelMoved(correctedEvent);
            }
        }
    }
}

