/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.util.IO;

public class AlbumSynchronizer {
    protected AlbumBean engine;
    public static boolean debugMode = false;

    public AlbumSynchronizer(AlbumBean engine) {
        this.engine = engine;
    }

    public File translate(AlbumObject ao) {
        File rootOutputDirectory = this.engine.getInterpretedOutputDirectory();
        return new File(rootOutputDirectory, ao.getPathFromRoot());
    }

    public void moveTo(File from, File to) {
        File rootOutputDir;
        if (!Config.getConfig().isSynchronizeOutputDirectory()) {
            return;
        }
        File rootImageDir = new File(this.engine.getDirectory());
        if (!rootImageDir.equals(rootOutputDir = this.engine.getInterpretedOutputDirectory())) {
            AlbumSynchronizer.moveFile(from, to);
        }
        if (!from.isDirectory()) {
            AlbumSynchronizer.moveFile(this.getThumbnailFile(from), this.getThumbnailFile(to));
            AlbumSynchronizer.moveFile(this.getCloseupFile(from), this.getCloseupFile(to));
            AlbumSynchronizer.moveFile(this.getCloseupPage(from), this.getCloseupPage(to));
        }
    }

    public void delete(File file) {
        if (!Config.getConfig().isSynchronizeOutputDirectory()) {
            return;
        }
        File rootImageDir = new File(this.engine.getDirectory());
        File rootOutputDir = this.engine.getInterpretedOutputDirectory();
        if (file.isDirectory()) {
            if (!rootImageDir.equals(rootOutputDir)) {
                AlbumSynchronizer.deleteDirRecursively(file);
                AlbumSynchronizer.log("Deleted directory " + file);
            }
        } else {
            if (!rootImageDir.equals(rootOutputDir)) {
                AlbumSynchronizer.deleteFile(file);
            }
            AlbumSynchronizer.deleteFile(this.getThumbnailFile(file));
            AlbumSynchronizer.deleteFile(this.getCloseupFile(file));
            AlbumSynchronizer.deleteFile(this.getCloseupPage(file));
        }
    }

    public void deleteOriginal(AlbumObject ao) {
        File rootOutputDir;
        if (!Config.getConfig().isSynchronizeOutputDirectory()) {
            return;
        }
        File rootImageDir = new File(this.engine.getDirectory());
        if (!rootImageDir.equals(rootOutputDir = this.engine.getInterpretedOutputDirectory())) {
            AlbumSynchronizer.deleteFile(this.translate(ao));
        }
    }

    private static void deleteDirRecursively(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                AlbumSynchronizer.deleteDirRecursively(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    private static void deleteFile(File f) {
        if (f.delete()) {
            AlbumSynchronizer.log("Deleted " + f);
        }
    }

    private static void moveFile(File from, File to) {
        if (from.renameTo(to)) {
            AlbumSynchronizer.log("Moved " + from + " to " + to);
        }
    }

    private File getThumbnailFile(File translatedFile) {
        File thumbDir = new File(translatedFile.getParentFile(), this.engine.getThumbnailDirectory());
        return new File(thumbDir, AlbumBean.jpegName(translatedFile.getName()));
    }

    private File getCloseupFile(File translatedFile) {
        File slidesDir = new File(translatedFile.getParentFile(), this.engine.getSlideDirectory());
        return new File(slidesDir, AlbumBean.jpegName(translatedFile.getName()));
    }

    private File getCloseupPage(File translatedFile) {
        File slidesDir = new File(translatedFile.getParentFile(), this.engine.getSlideDirectory());
        return new File(slidesDir, IO.baseName(translatedFile.getName()) + this.engine.getPageExtension());
    }

    private static void log(String s) {
        if (debugMode) {
            System.out.println(s);
        }
    }
}

