/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.SystemColor;
import java.util.Map;
import se.datadosen.component.ControlPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.EditListener;
import se.datadosen.jalbum.EditPanel;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.jalbum.event.JAlbumAdapter;
import se.datadosen.jalbum.event.JAlbumEvent;
import se.datadosen.util.PropertyBinder;

public class JCustomPanel
extends ControlPanel
implements EditListener {
    protected JAlbumContext context;
    protected PluginContext pc;
    protected EditPanel editPanel;
    private Map initiatedValues;
    protected AlbumObject currentAO;

    public JCustomPanel(JAlbumContext context) {
        this.context = context;
        this.pc = context.getPluginContext();
        this.editPanel = this.pc.getEditPanel();
        this.setBackground(SystemColor.text);
        this.setOpaque(true);
        context.getFrame().addJAlbumListener(new JAlbumAdapter(){

            public void skinChanged(JAlbumEvent e) {
                JCustomPanel.this.editPanel.removeCustomTab(JCustomPanel.this);
                JCustomPanel.this.editPanel.removeEditListener(JCustomPanel.this);
            }
        });
    }

    public void setAlbumObject(AlbumObject ao) {
        this.saveUI();
        this.currentAO = ao;
        this.loadUI();
    }

    private void initUI() {
        if (this.initiatedValues == null) {
            this.initiatedValues = PropertyBinder.getProperties(this);
            this.editPanel.addEditListener(this);
        } else {
            PropertyBinder.syncUI(this.initiatedValues, this);
        }
    }

    protected void loadUI() {
        this.initUI();
        if (this.currentAO != null) {
            AlbumObjectProperties props = this.currentAO.getProperties();
            props.loadUI(this);
        }
    }

    protected void init() {
        this.loadUI();
    }

    protected void saveUI() {
        if (this.currentAO == null) {
            return;
        }
        AlbumObjectProperties props = this.currentAO.getProperties();
        props.saveUI(this);
    }
}

