import se.datadosen.jalbum.JAFilter;
import java.awt.*;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import java.io.*;
import java.net.*;

/**
 * Title:        JAlbum simple image filter adding image logotypes to images
 * Copyright:    Copyright (c) 2003
 * Company:      Datadosen
 * @author David Ekholm
 * @version 1.0
 */

public class LogoFilter implements JAFilter {
    public static final String LEFT_ALIGNMENT = "left";
    public static final String CENTER_ALIGNMENT = "center";
    public static final String RIGHT_ALIGNMENT = "right";
    public static final String TOP_ALIGNMENT = "top";
    public static final String BOTTOM_ALIGNMENT = "bottom";

    // Default image
	ImageIcon logo = new ImageIcon();
    private String src;
    private String align = LEFT_ALIGNMENT;
    private String valign = TOP_ALIGNMENT;
    private int margin = 0;
    private int offset = 0;
    private int voffset = 0;

		// Implements JAFilter
    public String getName() {
        return "Logo filter";
    }

		// Implements JAFilter
    public String getDescription() {
        return "Add image logotypes to images";
    }

		// Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
		Graphics2D g = bi.createGraphics();

        int width = bi.getWidth();
        int height = bi.getHeight();
        Image logoImage = logo.getImage();
        int logoWidth = logoImage.getWidth(null);
        int logoHeight = logoImage.getHeight(null);
        int x,y;
        if (align.equals(LEFT_ALIGNMENT))
            x = margin;
        else if (align.equals(RIGHT_ALIGNMENT))
            x = width-margin-logoWidth;
        else // CENTER
            x = (width-logoWidth)/2;

        if (valign.equals(TOP_ALIGNMENT))
            y = margin;
        else if (valign.equals(BOTTOM_ALIGNMENT))
            y = height-margin-logoHeight;
        else // CENTER
            y = (height-logoHeight)/2;

		g.drawImage(logo.getImage(), x+offset, y+voffset, null);
		return bi;
    }
    public void setSrc(String imageURL) throws IOException {
        URL url = new URL(imageURL);
        logo = new ImageIcon(url);
        src = imageURL;
    }

    public String getSrc() {
        return src;
    }

    public void setMargin(int newMargin) {
        margin = newMargin;
    }
    public int getMargin() {
        return margin;
    }
    public void setAlign(String newAlign) {
        align = newAlign;
    }
    public String getAlign() {
        return align;
    }
    public void setValign(String newValign) {
        valign = newValign;
    }
    public String getValign() {
        return valign;
    }
    public void setOffset(int newOffset) {
        offset = newOffset;
    }
    public int getOffset() {
        return offset;
    }
    public void setVoffset(int newVoffset) {
        voffset = newVoffset;
    }
    public int getVoffset() {
        return voffset;
    }
}