#ifndef _LSYS_H
#define _LSYS_H

#include <iostream>
#include <vector>
#include <string>
#include "mutprobs.h"
#include "Lline.h"

using namespace std;

enum {COMM=-5, REC=-4, ANG=-3, THICK=-2, AXIOM=-1};

class Lsys{
private:
	void mutate_rec();
	void mutate_ang();
	void mutate_thick();
	void mutate_axiom();
	void mutate_rules();
	bool mutate_algorithm(Lline &s, size_t &pos1);
	bool mutate_parameter(Lline &s, size_t &pos1);
	void mutate_str(Lline &str);
	string comments;
	Lline rec, ang, thick, axiom;
	vector<Lrule> rules;
	bool changed;
	mut_class M;
	mut_mut_class *MM;
public:
  static const string basic_tree;
//  static const string brackets;
//  static const string open_brackets;

  Lsys(mut_mut_class *mmc);
  ~Lsys();
  //assume copy constructor works ok.
  float bounds[6];
  string get_Lstring();
  
  void operator<<(char *in);
  void operator<<(const char *in);
  void operator<<(string &in);
  void operator<<(const string &in);
  void operator<<(istream &in);
  friend void operator<<(string &out, Lsys &l);
  friend ostream& operator<<(ostream& out, Lsys& l);

  bool read_in(const string &in);
  void clear();
  void derive_from(const Lsys &l);
  int num_rules() const {return rules.size();};
  float get_rec() const { return atof(rec.c_str());}
  bool  rec_is_int() const { if (rec.find('.')==string::npos) return true; else return false;};
  float get_ang() const { return atof(ang.c_str());}
  float get_thick() const { return atof(thick.c_str());}
  string get_axiom() const { return axiom;}
  string get_rules_as_one_string() const;
  
  void set_unchanged(void) {changed=false;};
  bool has_changed(void) const {return changed;};

  string available_rules() const;
  string used_rules() const;
  bool del_rule(int which);
  void add_rule(char name, string str, string comm="");

};

#endif
