// A set of classes which define a random number generating class and a derived class that stores a potentially mutable probability value

#include <cmath>

#ifdef WIN32
#define rint(X) floor((X)+0.5)
#endif

#include "probability.h"

/* random number generating routine taken from    *
*  http://www.helsbreth.org/random/unbiased.html  */

MyRand::MyRand(unsigned long myseed)
{
	S=myseed;
};

void MyRand::seed(unsigned long myseed)
{
	S=myseed;
};

unsigned int MyRand::integer()
{
  S=R_MOD*(S&MAX_RND)+(S>>16);
  return(S&MAX_RND);
};
  
unsigned int MyRand::integer(unsigned int i)
{
	return(static_cast<unsigned int>((static_cast<float>(i)/(MAX_RND+1))*integer()));
};
  
float MyRand::floatingpoint()
{
	return(static_cast<float>(integer())/(static_cast<unsigned long>(MAX_RND)+1));
};
  
float MyRand::Normal(float stdev) {  //produce normally distributed random numbers
    static double V1, V2, S;
    static int phase = 0;
    double X;
    if(phase == 0) {
      do {
	double U1 = ((double) integer()) / MAX_RND;
	double U2 = ((double) integer()) / MAX_RND;
	V1 = 2 * U1 - 1;
	V2 = 2 * U2 - 1;
	S = V1 * V1 + V2 * V2;
      } while(S >= 1 || S == 0);
      X = V1 * sqrt(-2 * log(S) / S);
    } else X = V2 * sqrt(-2 * log(S) / S);
    phase = 1 - phase; //reuse the random numbers
    return (X*stdev);
  };

MyRand Probability::Rand=MyRand();
	
Probability::Probability(){p=0; stdev=0; stdev_used=false;};
	bool  Probability::has_stddev(){return stdev_used;};
	float Probability::get()        {return p/Rand.MAX_RND;};
	float Probability::get_stdev() {return stdev;};
	void  Probability::set(float pr) {p=pr*Rand.MAX_RND;};
	void  Probability::set_stdev(float s){if (stdev_used) stdev=s;};
	void  Probability::init(float pr) {p=pr*Rand.MAX_RND; stdev_used=false;};
	void  Probability::init(float pr, float s){p=pr*Rand.MAX_RND; stdev=s; stdev_used=true;};
	void  Probability::jitter(float j) { //never allow probabilities below 0 or above 1 
		if (p>0) { //arcsin transformation
			float temp=asin(sqrt(get()));
			temp=sin(temp+j);
			p=temp*temp;
		};
	};
	
void  Probability::jitter_stdev(float j_stdev) 
{
	if (stdev_used) stdev+=j_stdev;
};
	
bool Probability::mut(const float &multval) 
{
	if (Rand.integer() < p*multval) return true;
	else                            return false;
};
	
bool Probability::mut(float *ret, const float &multval)
{
	if (stdev_used && mut(multval)) {
		*ret=Rand.Normal(stdev); 
		return true;
	} else
		return false;
};
	
bool Probability::mut(int *ret, float multval){
  if (stdev_used && mut(multval)) {
    *ret=(int) rint(Rand.Normal(stdev));
    return true;
  } else
    return false;
};
