/***************************************************************************
 *   Copyright (C) 2010 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/
#include "elementiterator.h"
#include "elements/polygon.h"
#include "elements/cellrefarray.h"
#include "elements/cellref.h"

elementIterator::elementIterator(cell*c,iteratorType t,int i)
{
  init();
  layer=i;
  type=t;
  iteratorCell=c;
}

elementIterator::elementIterator(const elementIterator &i){
  init();
  layer=i.layer;
  iteratorCell=i.iteratorCell;
  type=i.type;
  currentMap=i.currentMap;
  start=i.start;
  stack=i.stack;
  rMin=i.rMin;
  rMax=i.rMax;
}

void elementIterator::init(){
  layer=0;
  iteratorCell=NULL;
  e=NULL;
  currentMap.el=NULL;
  start=true;
}

void elementIterator::setRegion(QPoint min,QPoint max){
  if (min.x()>max.x()){
    int h=min.x();
    min.setX(max.x());
    max.setX(h);
  }
  if (min.y()>max.y()){
    int h=min.y();
    min.setY(max.y());
    max.setY(h);
  }
  if (type==iteratorShapeOnLayer) {
    type=iteratorShapeOnLayerRegion;
    rMin=min;
    rMax=max;
  }
  else if (type==iteratorShape) {
    type=iteratorShapeRegion;
    rMin=min;
    rMax=max;
  }
  else {
    if (min.x()<rMin.x()) rMin.setX(min.x());
    if (max.x()>rMax.x()) rMax.setX(max.x());
    if (min.y()<rMin.y()) rMin.setY(min.y());
    if (max.y()>rMax.y()) rMax.setY(max.y());
  }
}

elementIterator::~elementIterator()
{
   clear();
}

bool elementIterator::next(){
  clear();
  if (start) {
    start=false;
    currentMap.el=iteratorCell->firstElement;
  } else {
    next_();
  }
  return process();
}

void elementIterator::next_(){
    // test on cellarray 
    if ((currentMap.array)){
      cellrefArray *cr=static_cast<cellrefArray *>(currentMap.el->thisElement);
      if ((++currentMap.ix)<cr->anz_x) {}
      else if ((++currentMap.iy)<cr->anz_y) {currentMap.ix=0;}
      else {
	currentMap.array=false;
	currentMap.el=currentMap.el->nextElement;
      }
     if ((currentMap.array)){
       /* if (type==iteratorShapeOnLayerRegion){
		bool doNext=true;
		do {
		QPoint pos=cr->point+cr->space_x*currentMap.ix+cr->space_y*currentMap.iy;
		QPoint posMax=pos+currentMap.refMax;
		QPoint posMin=pos+currentMap.refMin;
	  	if ((posMax.x()>rMin.x())&&
			(posMax.y()>rMin.y())&&
			(rMax.x()>posMin.x())&&
			(rMax.y()>posMin.y())) {
			  doNext=false;
		}
		else {
		        if ((++currentMap.ix)<cr->anz_x) {}
			else if ((++currentMap.iy)<cr->anz_y) {currentMap.ix=0;}
			else {
			  currentMap.array=false;
			  currentMap.el=currentMap.el->nextElement;
			  return;
			}
		}
		}
		while (doNext);
	}*/
        //printf("cell %d %d\n",currentMap.ix,currentMap.iy);
	stack.push(currentMap);
	currentMap.array=false;
	QPoint pos=cr->point+cr->space_x*currentMap.ix+cr->space_y*currentMap.iy;
	currentMap.matrix.translate(pos.x(),pos.y());
	strans trans=currentMap.el->thisElement->getTrans();
	if (trans.mirror_x){currentMap.matrix.toggleMirror_x();};
	currentMap.matrix.rotate(trans.angle);
	currentMap.matrix.scale(trans.mag);
	currentMap.el=cr->cell_ref->firstElement;
     }
    }
    else 
      currentMap.el=currentMap.el->nextElement;
}

bool elementIterator::process(){
  if (currentMap.el==NULL) {
    if (levelUp()) return process();
    else return false;
  }

  if (currentMap.el->thisElement==NULL) return next();
  
  switch (type){
      case iteratorShapeOnLayer:{
	do {
	  while (currentMap.el!=NULL){
	    if (currentMap.el->thisElement!=NULL){
	      if (currentMap.el->thisElement->isCellref()) {levelDown();continue; }
	      if (currentMap.el->thisElement->isCellrefArray()) 
		{
		  currentMap.array=true;
		  currentMap.ix=0;
		  currentMap.iy=0;
		 // currentMap.refMin=QPoint(INT_MIN,INT_MIN);
		 // currentMap.refMax=QPoint(INT_MAX,INT_MAX);
		  levelDown();
		  continue;
		}
	      if (currentMap.el->thisElement->layerNum==layer) {
		prepare();
		return true;
		}
	      }
	  currentMap.el=currentMap.el->nextElement;
	  }
	}
	while (levelUp());
	return false;
      } break;
      case iteratorShapeOnLayerRegion:{
	do {
	  while (currentMap.el!=NULL){
	    if (currentMap.el->thisElement!=NULL){
	      if (currentMap.el->thisElement->isCellref()) {
		prepare();
		QPoint cMax=QPoint(INT_MIN,INT_MIN);
  		QPoint cMin=QPoint(INT_MAX,INT_MAX);
		e->maximum(&cMax);
		e->minimum(&cMin);
		//printf("%s checked cr %d %d\n",e->depend()->cellName.toAscii().data(),cMin.x(),cMin.y());
		clear();
		if ((cMax.x()>rMin.x())&&
			(cMax.y()>rMin.y())&&
			(rMax.x()>cMin.x())&&
			(rMax.y()>cMin.y())) {
				//printf("ref start\n");
				levelDown();continue; 
			}
	        }
	      if (currentMap.el->thisElement->isCellrefArray()) 
		{		
		prepare();
		QPoint cMax=QPoint(INT_MIN,INT_MIN);
  		QPoint cMin=QPoint(INT_MAX,INT_MAX);
		e->maximum(&cMax);
		e->minimum(&cMin);
	        //printf("%s checked cra\n",e->depend()->cellName.toAscii().data());
	      	/*	      cellref cr(e->depend(),QPoint(0,0));
			      cr.trans=e->getTrans();
			      currentMap.refMax=QPoint(INT_MIN,INT_MIN);
			      currentMap.refMin=QPoint(INT_MAX,INT_MAX);
			      cr.maximum(&(currentMap.refMax));
			      cr.minimum(&(currentMap.refMin));*/
		clear();
		if ((cMax.x()>rMin.x())&&
			(cMax.y()>rMin.y())&&
			(rMax.x()>cMin.x())&&
			(rMax.y()>cMin.y())) {
			      //printf("start array\n");
			      currentMap.array=true;
			      currentMap.ix=0;
			      currentMap.iy=0;
			      //next_(); //
			      levelDown();
			      continue;
			}
	        }
	      if (currentMap.el->thisElement->layerNum==layer) {
		prepare();
		QPoint cMax=QPoint(INT_MIN,INT_MIN);
  		QPoint cMin=QPoint(INT_MAX,INT_MAX);
		e->maximum(&cMax);
		e->minimum(&cMin);
		if ((cMax.x()>rMin.x())&&
			(cMax.y()>rMin.y())&&
			(rMax.x()>cMin.x())&&
			(rMax.y()>cMin.y())) {
				return true;
			}
		else clear();
		}
	      }
	  currentMap.el=currentMap.el->nextElement;
	  }
	}
	while (levelUp());
	return false;
      } break;
      case iteratorShape:{
	do {
	  while (currentMap.el!=NULL){
	    if (currentMap.el->thisElement!=NULL){
	      if (currentMap.el->thisElement->isCellref()) {levelDown();continue; }
	      if (currentMap.el->thisElement->isCellrefArray()) 
		{
		  currentMap.array=true;
		  currentMap.ix=0;
		  currentMap.iy=0;
		 // currentMap.refMin=QPoint(INT_MIN,INT_MIN);
		 // currentMap.refMax=QPoint(INT_MAX,INT_MAX);
		  levelDown();
		  continue;
		}
		prepare();
		return true;
	      }
	  currentMap.el=currentMap.el->nextElement;
	  }
	}
	while (levelUp());
	return false;  
      }break;
      case iteratorShapeRegion:{
	do {
	  while (currentMap.el!=NULL){
	    if (currentMap.el->thisElement!=NULL){
	      if (currentMap.el->thisElement->isCellref()) {
		prepare();
		QPoint cMax=QPoint(INT_MIN,INT_MIN);
  		QPoint cMin=QPoint(INT_MAX,INT_MAX);
		e->maximum(&cMax);
		e->minimum(&cMin);
		//printf("%s checked cr %d %d\n",e->depend()->cellName.toAscii().data(),cMin.x(),cMin.y());
		clear();
		if ((cMax.x()>rMin.x())&&
			(cMax.y()>rMin.y())&&
			(rMax.x()>cMin.x())&&
			(rMax.y()>cMin.y())) {
				//printf("ref start\n");
				levelDown();continue; 
			}
	        }
	      if (currentMap.el->thisElement->isCellrefArray()) 
		{		
		prepare();
		QPoint cMax=QPoint(INT_MIN,INT_MIN);
  		QPoint cMin=QPoint(INT_MAX,INT_MAX);
		e->maximum(&cMax);
		e->minimum(&cMin);
	        //printf("%s checked cra\n",e->depend()->cellName.toAscii().data());
	      	/*	      cellref cr(e->depend(),QPoint(0,0));
			      cr.trans=e->getTrans();
			      currentMap.refMax=QPoint(INT_MIN,INT_MIN);
			      currentMap.refMin=QPoint(INT_MAX,INT_MAX);
			      cr.maximum(&(currentMap.refMax));
			      cr.minimum(&(currentMap.refMin));*/
		clear();
		if ((cMax.x()>rMin.x())&&
			(cMax.y()>rMin.y())&&
			(rMax.x()>cMin.x())&&
			(rMax.y()>cMin.y())) {
			      //printf("start array\n");
			      currentMap.array=true;
			      currentMap.ix=0;
			      currentMap.iy=0;
			      //next_(); //
			      levelDown();
			      continue;
			}
	        }
		prepare();
		QPoint cMax=QPoint(INT_MIN,INT_MIN);
  		QPoint cMin=QPoint(INT_MAX,INT_MAX);
		e->maximum(&cMax);
		e->minimum(&cMin);
		if ((cMax.x()>rMin.x())&&
			(cMax.y()>rMin.y())&&
			(rMax.x()>cMin.x())&&
			(rMax.y()>cMin.y())) {
				return true;
			}
		else clear();
	      }
	  currentMap.el=currentMap.el->nextElement;
	  }
	}
	while (levelUp());
	return false;
      }
    }
  return false;
}

void elementIterator::prepare(){
  if (currentMap.matrix.matrix.isIdentity ()) e=currentMap.el->thisElement->copy(); 
  else if (currentMap.el->thisElement->isBox())
    e=currentMap.el->thisElement->convertToPolygon();
  else e=currentMap.el->thisElement->copy(); 
  e->map(currentMap.matrix);
}

void elementIterator::toPolygon(){
  if (e==NULL) return;
  element *f=e->convertToPolygon();
  delete e;
  e=f;
}

bool elementIterator::levelUp(){
  if (stack.size()==0) return false;
  currentMap=stack.pop();
  //printf("up\n");
  next_();
  return true;
}

void elementIterator::levelDown(){
    stack.push(currentMap);
    currentMap.array=false;
    cell *c= currentMap.el->thisElement->depend();
    //printf("cell down %d %d %d\n",currentMap.ix,currentMap.iy,currentMap.el->thisElement);
    //printf("cell %s\n",c->cellName.toAscii().data());
    pointArray pa=currentMap.el->thisElement->getPoints();
    currentMap.matrix.translate(pa.point(0).x(),pa.point(0).y());
    strans trans=currentMap.el->thisElement->getTrans();
    if (trans.mirror_x){currentMap.matrix.toggleMirror_x();};
    currentMap.matrix.rotate(trans.angle);
    currentMap.matrix.scale(trans.mag);
    currentMap.el=c->firstElement;
    if (currentMap.el==NULL) levelUp();
}

void elementIterator::clear(){
    if (e==NULL) return;
      delete e; e=NULL;
}

void elementIterator::copyElement(cell *workCell){
  if (e!=NULL) workCell->addElement(e->copy());
}



