/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PROPERTYLIST_H
#define PROPERTYLIST_H

#include <QList>
#include <QString>


/**
@author Juergen Thies
*/
enum propertyType{propertyNone,propertyInt,propertyString,propertyFloat};
class gds;
class propertyItem{
public:

union {
	int propertyNum;
	QString *propertyName;
};
union {
	int propertyValueNum;
	QString *propertyValueString;
	float propertyValueFloat;
};
    	propertyItem();
	propertyItem(int num);
	propertyItem(int num,QString value);
	propertyItem(int num,int value);
	propertyItem(QString Name,QString value);
	propertyItem(QString Name);
   	inline propertyItem(const propertyItem &p){
		nameType=p.nameType;
		valueType=p.valueType;
		propertyNum=p.propertyNum;
		propertyValueFloat=p.propertyValueFloat;
		if (nameType==propertyString) propertyName=new QString(*(p.propertyName));
		if (valueType==propertyString) propertyValueString=new QString(*(p.propertyValueString));
	}

    	~propertyItem();
	void setValue( QString value);
	void setValue( int value);
	void setValue( float value);
	void setName(QString);
 	propertyType nameType,valueType;

 	inline propertyItem & operator=(const propertyItem &p){
		nameType=p.nameType;
		valueType=p.valueType;
		propertyNum=p.propertyNum;
		propertyValueFloat=p.propertyValueFloat;
		if (nameType==propertyString) propertyName=new QString(*(p.propertyName));
		if (valueType==propertyString) propertyValueString=new QString(*(p.propertyValueString));
		return *this;
	}
	int getNum()const;
	bool isNum()const;
	QString getString()const;
	QString getValueString()const;
	int getValueInt()const;
};



#endif
