/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "file_read.h"



fileRead::fileRead(QString filename)
 : QFile(filename)
{
if (atEnd()) end=true;
else end=false;
bufferRead=0;
bufferPos=0;
noswap = QSysInfo::ByteOrder == QSysInfo::BigEndian;
}


fileRead::~fileRead()
{
}

bool fileRead::open(){
end=!QFile::open(QIODevice::ReadOnly );
lastBlock=false;
return end;
}

void fileRead::readBuffer(){
int newPos=0;
for (newPos=0;bufferPos<bufferRead;newPos++){
   buffer[newPos]=buffer[bufferPos];
   bufferPos++;	
 }
int i=read((char *)&buffer[newPos],bufferSize-newPos);
bufferRead=i+newPos;
if (i<(bufferSize-newPos)) lastBlock=true;
bufferPos=0;

}

qint32 fileRead::readInt32(){
bufferPos+=4;
if (bufferRead<bufferPos) {
	bufferPos-=4;
	readBuffer();
	bufferPos+=4;
	}
if (lastBlock) if (bufferPos>=bufferRead) end=true;
if (noswap) {
	qint32 *i;
	i=(qint32 *)&buffer[bufferPos-4];
        return *i;
    } else {
	qint32 i;
        register uchar *p = (uchar *)(&i);
            *p++ = buffer[bufferPos-1];;
	    *p++ = buffer[bufferPos-2];;
	    *p++ = buffer[bufferPos-3];;
            *p = buffer[bufferPos-4];
	return i;
    }
}

qint16 fileRead::readInt16(){
bufferPos+=2;
//printf("bufferPos %d %d\n",bufferPos,bufferRead);
if (bufferRead<bufferPos) {
	bufferPos-=2;
	readBuffer();
	bufferPos+=2;
	}
if (lastBlock) if (bufferPos>=bufferRead) end=true;
if (noswap) {
	qint16 *i;
	i=(qint16 *)&buffer[bufferPos-2];
        return *i;
    } else {
	qint16 i;
        register uchar *p = (uchar *)(&i);
            *p++ = buffer[bufferPos-1];;
            *p = buffer[bufferPos-2];
	return i;
    }
}

quint16 fileRead::readUInt16(){
bufferPos+=2;
//printf("bufferPos %d %d\n",bufferPos,bufferRead);
if (bufferRead<bufferPos) {
	bufferPos-=2;
	readBuffer();
	bufferPos+=2;
	}
if (lastBlock) if (bufferPos>=bufferRead) end=true;
if (noswap) {
	quint16 *i;
	i=(quint16 *)&buffer[bufferPos-2];
        return *i;
    } else {
	quint16 i;
        register uchar *p = (uchar *)(&i);
            *p++ = buffer[bufferPos-1];;
            *p = buffer[bufferPos-2];
	return i;
    }
}

quint8 fileRead::readUInt8(){
quint8 *i;
i=(quint8 *)&buffer[bufferPos];
bufferPos++;
//printf("bufferPos %d %d\n",bufferPos,bufferRead);
if (bufferRead<bufferPos) {
	bufferPos--;
	readBuffer();
	i=(quint8 *)&buffer[bufferPos];
	bufferPos++;
	}
if (lastBlock) if (bufferPos>=bufferRead) end=true;
//printf("uint8 %d \n",*i);
return *i;
}

qint8 fileRead::readInt8(){
qint8 *i;
i=(qint8 *)&buffer[bufferPos];
bufferPos++;
//printf("bufferPos %d %d\n",bufferPos,bufferRead);
if (bufferRead<bufferPos) {
	bufferPos--;
	readBuffer();
	i=(qint8 *)&buffer[bufferPos];
	bufferPos++;
	}
if (lastBlock) if (bufferPos>=bufferRead) end=true;
return *i;
}

QString fileRead::readString(int length){
  QString s,s1;
  s1="";
  int start=0;
  if (length>3){
      quint8 help1;
      quint8 help2;
      quint8 help3;
      help1=readUInt8();
      help2=readUInt8();
      help3=readUInt8();
      //239 187 191 = EF BB BF
      //printf("%d %d %d\n",help1,help2,help3);
      if (help1==239)
	if (help2==187)
	  if (help3==191){
	    QByteArray b;
	    quint8 help;
	    for (int i=3;i<length;i++){
	      help=readUInt8();
	      //QString s;
	      b.append(char(help));
	    }
	    /*printf("%d size\n",b.length());
	    for (int i=0;i<b.size();++i){
		printf("%d \n",b.at(i));
	    }*/
	    return QString::fromUtf8(b.constData(),b.length());
	  }
      s1+=help1;
      s1+=help2;
      s1+=help3;
      start=3;
  }
  quint8 help;
  int i;
  for (i=start;i<length;i++){
  	help=readUInt8();
	if (help!=0){
		s=help; 
		s1+=s;}
	}
  return s1;
}