/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "layoutimage.h"
#include "layoutimagepainter.h"
#include "layoutimagepaintertransparent.h"
#include "layoutimagepainterwhitetransparent.h"
#include "layoutimagepainterstacked.h"
#include "setup.h"

layoutImage::layoutImage(int x,int y)
#ifdef multithread
:layoutImageDispatcher()
#endif
{
  image=new QImage(x+2,y+2,QImage::Format_RGB32);
  switch (setup::paintEngine){
    case 1: if (setup::transparentWhiteEngine()) imagePainter=new layoutImagePainterWhiteTransparent(this);
	      else imagePainter=new layoutImagePainterTransparent(this);
		break;
	case 2: imagePainter=new layoutImagePainterStacked(this);
		break;
	default: imagePainter=new layoutImagePainter(this);
		break;
	}
  //imagePainter=new layoutImagePainter(this);
  //paintAbort=&imageChanged;
  multiThreadDraw=false;
}


layoutImage::~layoutImage()
{
//printf("del layoutImage start\n");
#ifdef multithread
	if (multiThreadDraw){
		unsetPainter();
	}
#endif 
//printf("del layoutImage\n");
 
  delete imagePainter;
 delete image;
}

void layoutImage::setMultiThread(){
#ifdef multithread
  setupPainter(this);
  multiThreadDraw=true;
#endif 
}



void layoutImage::resize(int x, int y){
//printf("resize2 %d,%d\n",x,y);
  //delete imagePainter;
  delete image;
  image=new QImage(x+2,y+2,QImage::Format_RGB32);
  imagePainter->resize();
#ifdef multithread
	if (multiThreadDraw){
		resizePainter();
	}
#endif
  //imagePainter=new layoutImagePainter(this);
//printf("resize2 end\n");
}

void layoutImage::setBackground(){
image->fill(setup::backgroundColor.rgb());
if (setup::paintEngine==2){
    //clear alpha channal for deep buffer
    uint fillchar=setup::backgroundColor.rgb()& 0xffffff;
    for (int h=image->height()-1;h>=0;h--){
      uint *ptr = reinterpret_cast<uint *>(image->scanLine(h));
      for (int y=image->width()-1;y>=0;y--){
	*ptr=fillchar;
	ptr++;
      }
    }
}
}

void layoutImage::reset(){
imagePainter->cellrefDepth=0;
imagePainter->paintAbort=paintAbort;
setBackground();
/* uint *ptr = reinterpret_cast<uint *>(image->scanLine(10)) + 10;
printf(" %d  ( %d)\n",(*ptr)& 0xffffff,(*ptr)>>24);
*/
imageChanged=true;
#ifdef multithread
	if (multiThreadDraw){
		resetPainter();
	}
#endif
}

void layoutImage::setPaintAbort(bool *b){
paintAbort=b;
imagePainter->paintAbort=paintAbort;
}

void layoutImage::setDrawTrans(strans trans){
drawTrans=trans;
backgroundColor=setup::backgroundColor.rgb();
imagePainter->setTrans(trans);
}

