/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "elements/celllist.h"



void macro::cellListHandler_registerKeywords(keywords **keyword_){
  *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="cellList";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::cellListHandler_typeHandler;
}

void macro::cellListHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrCellList,varCellList,single);
}

returnValue macro::cellListHandler_classHandler(int *counter, keywords *keyword_,returnValue* r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (r->type==ptrCellList){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else if (r->type==varCellList){
     if (checkDot(counter)) {
   }
   else {
   	if (left) {compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
    }
 cellList *cl= r->getCellList();
 p=next(counter);
 // variables
 if ((p.type==keyword)&&(p.value=="thisCell")){
 		returnValue r2;
		r2.setType(ptrCell);
		r2.deleteAfter=false;
		r2.Cell=(cl->thisCell);
		r2=cellHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
 else if ((p.type==keyword)&&(p.value=="nextCell")){
 		returnValue r2;
		r2.setType(ptrCellList);
		r2.deleteAfter=false;
		r2.CellList=(cl->nextCell);
		r2=cellListHandler_classHandler(counter,keyword_,&r2,left);
		return r2;
 	}
 // methods
 else {
  	error->addItem(tr("Class cellList has no member")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}

