/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILE_H
#define FILE_H

#include <QString>
#include <QFile>
#include <QDir>
#include <QStringList>
/**
@author Juergen Thies
*/
//! file read/write
/*!
This class provides a interface for reading and writing on files.
This class not no avaiable in the python interface, as there a plenty other ways to load files.
*/
class file 
{

public:
    file();
    ~file();
    file(const file& f){filename=f.filename;};
    file& operator=(const file& f){filename=f.filename;return *this;};
    QStringList list;
    int num;
    bool opened;
//! open file
/*!
The filename had to be set prior to the property filename. I
@return true if filename exists. Otherwise false.
*/
    bool exists();
    QFile File;
    QString path;
//! filename
/*!
Name of the file to operate with.
*/
    QString filename;
//! open file
/*!
Open a file. The filename had to be set prior to the property filename. If mode is true, the file is opened in readonly mode. If mode is false, the file is open as writeonly mode. 
@return true if operation was successful. Otherwise false.
*/
    bool open(bool mode=true);
//! read file
/*!
@return the hole file is returned as a string
*/
    QString read();
//! write file
/*!
The file is overwrite with the string s
*/
    void write(QString s);
//! close file
/*!
The file is closed.
*/
    void close();
//! find file
/*!
Find a file matching to the search string s. If a match is found, filename is set. Otherwise filename is set to "".
*/
    void find(QString path, QString s);
//! find file
/*!
Find a file matching to the search string s. If a match is found, filename is set. Otherwise filename is set to "".
*/
    void findDir(QString path, QString s);
//! find next
/*!
Find an other file match to a previous find. If a match is found, filename is set. Otherwise filename is set to "".
*/
    void findNext();
//! set current path
/*!
The default working directory is set.
*/
    void setCurrentPath(QString path);
//! current path
/*!
The current working path is returned.
*/
    QString currentPath();
//! home path
/*!
The home path is returned.
*/
    QString homePath();
//! temp path
/*!
The temp path is returned.
*/
    QString tempPath();
//! remove file
/*!
Removes the file specified by the filename given.
Returns true if successful; otherwise returns false.
*/
    bool remove();
};

#endif
