/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "general/setup.h"
#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include <QProcess>





void macro::processHandler_registerKeywords(keywords **keyword_){
 *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="process";
 (*keyword_)->type=intClass;
 (*keyword_)->r=new returnValue();
 (*keyword_)->classHandler=&macro::processHandler_classHandler;
}

returnValue macro::processHandler_classHandler(int *counter, keywords *keyword_,returnValue* ,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (!checkStaticClass(counter)) throw 19;
 p=next(counter);
 // methods
 if (((p.type==keyword)&&(p.value=="execute"))) {
 	testParenOpen(counter);
	variant p1=calculate(counter,keyword_);
    testComma(counter);
	variant p2=calculate(counter,keyword_);
	testParenClose(counter);
	if (p2.isStringList()) ret.setInt(QProcess::execute(p1.getString(),p2.getStringList()));
	else ret.setInt(QProcess::execute(p1.getString(),p2.getString().split(" ")));
  	}
 else if (((p.type==keyword)&&(p.value=="startDetached"))) {
 	testParenOpen(counter);
	variant p1=calculate(counter,keyword_);
	testComma(counter);
	variant p2=calculate(counter,keyword_);
	testParenClose(counter);
	if (p2.isStringList()) ret.setBool(QProcess:: startDetached(p1.getString(),p2.getStringList()));
  	else ret.setBool(QProcess:: startDetached(p1.getString(),p2.getString().split(" ")));
	}
 else if (((p.type==keyword)&&(p.value=="getEnv"))) {
 	testParenOpen(counter);
	variant p1=calculate(counter,keyword_);
	testParenClose(counter);
	ret.setString(QString( getenv (p1.getString().toAscii().data())));
  	}
 else if (((p.type==keyword)&&(p.value=="setEnv"))) {
 	testParenOpen(counter);
	variant p1=calculate(counter,keyword_);
	testComma(counter);
	variant p2=calculate(counter,keyword_);
	testParenClose(counter);
	#ifdef Q_OS_WIN32
	ret.setInt(putenv(QString(p1.getString()+"="+p2.getString()).toAscii().data()));
	#else
	ret.setInt(setenv(p1.getString().toAscii().data(),p2.getString().toAscii().data(),1));
	#endif
  	}
 else {
  error->addItem(tr("Class process has no member ")+p.value,1,message((*counter)));
  throw 1;
 }
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}
