/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef POSWIDGET_H
#define POSWIDGET_H

#include <qwidget.h>
#include <qtoolbutton.h>
#include <qlabel.h>
//Added by qt3to4:
#include <QPixmap>
#include <QContextMenuEvent>
#include "widgets/mousewidget.h"

/**
@author Juergen Thies
*/
class layout;

class poswidget : public QWidget
{
Q_OBJECT
public:
    poswidget(class layout *la, QWidget *parent = 0, const char *name = 0);

    ~poswidget();
public slots:
    void setPos(QString s);
    void setWide();
    void setSmall();
    void setNormal();
private:
    class layout *l;
    QLabel *posIcon,*posNumber;
    QPixmap xyIcon;
protected:
  void contextMenuEvent ( QContextMenuEvent * event );
  void mousePressEvent ( QMouseEvent * event );
  void enterEvent ( QEvent * e ){mouseWidget::set(contextHelp);QWidget::enterEvent(e);}
};

#endif
