/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "propertyedit.h"
#include <qpushbutton.h>

propertyEdit::propertyEdit(QList<propertyItem> *p)
: propertyEditDialog()
{setupUi(this);
property=p;
propertyCopy=(*p);
setTable();
setModal(true);
connect(propertyTable,SIGNAL(  currentItemChanged ( QTableWidgetItem * , QTableWidgetItem * )),this,SLOT(updateItem(QTableWidgetItem *,QTableWidgetItem *)));
connect(deleteItemButton,SIGNAL( clicked()),this,SLOT( deleteItem()));
connect(addItemButton,SIGNAL( clicked()),this,SLOT( addItem()));
}

propertyEdit::~propertyEdit()
{

}

void propertyEdit::setTable(){
propOrgi.clear();
propSorted.clear();
propertyTable->clear();
propertyTable->setRowCount(propertyCopy.size());
propertyTable->setColumnCount(2);
QStringList sl;
sl<<tr("property")<<tr("value");
propertyTable->setHorizontalHeaderLabels(sl);
propertyTable->setSortingEnabled(false);
for (int i=0;i<propertyCopy.size();i++){
	propertyItem item=(propertyCopy)[i];
	QString s1,s2;
	s1=item.getString();
	s2=item.getValueString();
  	QTableWidgetItem *newItem = new QTableWidgetItem( s1);
     	propertyTable->setItem(i, 0, newItem);
	QTableWidgetItem *newItem2 = new QTableWidgetItem( s2);
     	propertyTable->setItem(i, 1, newItem2);
	propOrgi<<s1+";"+s2;
 }
propertyTable->setSortingEnabled(true);
propertyTable->sortByColumn ( 0, Qt::AscendingOrder );
propertyTable->setSortingEnabled(false);
for (int i=0;i<propertyCopy.size();i++){
	QString s1=propertyTable->item(i,0)->text();
	QString s2=propertyTable->item(i,1)->text();
	propSorted<<s1+";"+s2;
	//printf("%s\n",QString(s1+";"+s2).toAscii().data());
}
}

void propertyEdit::updateItem(QTableWidgetItem *,QTableWidgetItem *c){
if ((c!=NULL)&&(propSorted.size()>0)){
	int row_=propertyTable->row(c);
  	QString oldtext=propSorted.at(row_);
	QString s1=propertyTable->item(row_,0)->text();
	QString s2=propertyTable->item(row_,1)->text();
	QString newtext=s1+";"+s2;
	if (oldtext!=newtext){
		int oldpos=-1;
		for (int i=0;i<propertyCopy.size();i++){
			if (propOrgi.at(i)==oldtext) oldpos=i;
			}
		if (oldpos<0) return;
		bool ok1,ok2;
     		int val1 = s1.toInt(&ok1, 10);
		int val2 = s2.toInt(&ok2, 10);
		if (ok1&&(!ok2)) propertyCopy[oldpos]=propertyItem(val1,s2);
		else if (ok1&&ok2) propertyCopy[oldpos]=propertyItem(val1,val2);
		else propertyCopy[oldpos]=propertyItem(s1,s2);

	//printf("%d %d %d\n",propSorted.size(),propOrgi.size(),property->size());
  	//printf("%d %d,%d,%s,%s\n", row_,propertyTable->row(c),propertyTable->column(c),c->text().toAscii().data(),oldtext.toAscii().data());
	setTable();}
	}
}

void propertyEdit::deleteItem(){
if (propSorted.size()<=0) return;
int row=propertyTable->currentRow();
if (row<0) return;
QString s1=propertyTable->item(row,0)->text();
QString s2=propertyTable->item(row,1)->text();
QString newtext=s1+";"+s2;
int oldpos=-1;
for (int i=0;i<propertyCopy.size();i++){
		if (propOrgi.at(i)==newtext) oldpos=i;
	}
if (oldpos<0) return;
propertyCopy.removeAt(oldpos);
setTable();
}

void propertyEdit::addItem(){
propertyCopy<<propertyItem(0,"");
setTable();
}


void propertyEdit::accept()
{
  *property=propertyCopy;
  QDialog::accept();
}


