/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GERBER_H
#define GERBER_H
#include "general/layers.h"
#include <qobject.h>
#include <QTextStream>
#include "general/errorreport.h"
#include "filegeneral.h"

/**
@author Juergen Thies
*/
class drawingField;
class QString;
class gerber : public QObject
{
Q_OBJECT
public:
    gerber(QObject *parent = 0, const char *name = 0);

    ~gerber();
  static void open(QString filename,drawingField *);
  static void openMacro(QString filename,drawingField *);
  static void import(QString filename,drawingField *);
  static void update(QString filename,drawingField *);
  static void save(QString filename,drawingField *);
  errorreport report;
  errorreport *reportSave;

  void write(QString apertur,QPoint pos,int d);
  void writeOutput(QPoint pos,int d);
  void writeOutput(QString s);
  QString aperturSquare(int length);
  QString aperturCircle(int length);
  QString aperturRect(int width, int hight);
  int saveLayer;
private:
  void save(QTextStream *streamPtr,drawingField *, errorreport *error,int layer);
  
  void load(QString filename,drawingField *,  fileOpenType type);
  int readInt(QString *com);
  int readPos(QString *com);
  int readX(QString *com);
  int readY(QString *com);
  QList<int> readParameter(QString);

  QString unit;
  double databaseunits,scale;
  
  QStringList apertur,elements;
  QString output;

  bool omitLeadingZeroes;
  bool absCoordinates;
  int dig1x,dig2x,dig1y,dig2y;


};

#endif
