/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#define _USE_MATH_DEFINES
#include "layoutimagepainter.h"
#include "layoutimage.h"
#include "math.h"
#include <ft2build.h>
#include FT_FREETYPE_H

bool layoutImagePainter::defaultAbort=false;

layoutImagePainter::layoutImagePainter(layoutImage *im):textRender()
{
//printf("new image painter\n");
  LImage=im;
  image=im->image;
  setTrans(im->drawTrans);
  fill=new QImage(image->width(),image->height(),QImage::Format_Indexed8);
  fill->fill(0);
  drawBox.resize(5);
  setLimits();
  elementDraw=false;
  elementToDraw=NULL;
  paintAbort=&defaultAbort;
  detailLevel=1;
//printf("resize3 %d,%d\n",w,h);
}


layoutImagePainter::~layoutImagePainter()
{
//printf("del layoutImagePainter\n");
  delete fill;
}

#ifdef multithread
#include "threads/layoutimagedispatcher.h"
void layoutImagePainter::delegate(elementList *e, int num){
layoutImageDispatcherTask t;
t.cellrefDepth=cellrefDepth;
t.drawTrans=drawTrans;
t.elements=e;
t.numElements=num;
LImage->dataMutex.lock();
LImage->tasks.enqueue(t);
LImage->dataMutex.unlock();
LImage->jobs.release();
//printf("delegate %d\n",LImage->jobs.available());
}

bool layoutImagePainter::multiThreadDraw(){
	return LImage->multiThreadDraw;
}
#endif

void layoutImagePainter::resize(){

  image=LImage->image;
  QImage *fillold=fill;
  fill=new QImage(image->width(),image->height(),QImage::Format_Indexed8);
  fill->fill(0);
  setLimits();
  delete fillold;
}

void layoutImagePainter::setTrans(strans trans){
  drawTrans=trans;
  drawPixelSize=(int)(1.0/drawTrans.mag);
}

void layoutImagePainter::drawElement(element *e){
  if (elementDraw) return;
  elementToDraw=e;
  elementDraw=true;
}

void layoutImagePainter::drawElement(){
  if (!elementDraw) return;
  elementDraw=false;
  strans backup=drawTrans;
  drawTrans=LImage->drawTrans;
  drawPixelSize=(int)(1.0/drawTrans.mag);
  elementToDraw->paint(this);
  drawTrans=backup;
  drawPixelSize=(int)(1.0/drawTrans.mag);
}

void layoutImagePainter::drawPolygon(pointArray *p,uint c){
  if (*paintAbort) return;
  color=c;
  fillStyle=0;
  in=p;
  if (convert())
  for (int i=0;i<(int)outSize-1;i++){
        drawLine(out.point(i),out.point(i+1));
		//printf("line: %d , %d / %d , %d\n",out.point(i).x(),out.point(i).y(),out.point(i+1).x(),out.point(i+1).y());
	}
  if (elementDraw) drawElement();
  LImage->imageChanged=true;
}

void layoutImagePainter::drawPolygon(pointArray *p,uint c, uint style){
  if (style==0) drawPolygon(p,c);
  else {
	if (*paintAbort) return;
	//fill->fill(0);
  	color=c;
  	fillStyle=style;
	dir = true;
  	in=p;
  	if (convertFill()){
	int i;
	//printf("draw line\n");
  	for (i=0;i<(int)outSize-1;i++){
        	drawLineFill(out.point(i),out.point(i+1));
	}
	if (!dir) 
		fill->scanLine(out.point(i).y())[out.point(i).x()]++;
	//printf("fill\n");
	//printf("ist %d %d %d %d\n",maxX,minX,maxY,minY);
	//printf("soll %d %d %d %d\n",pmaxX,pminX,pmaxY,pminY);
	int line=fill->bytesPerLine ();
	uchar *c = fill->scanLine(pminY) +pminX;
	uint *ptr = reinterpret_cast<uint *>(image->scanLine(pminY)) + pminX;
	int fillLength=pmaxX-pminX+1;
	switch (style){
	case 1: //Dense7Pattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 2: //Dense6Pattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==0)) *ptr=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 3: //Dense 3/16=19%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==3)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==0)) *ptr=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 4: //Dense 4/16=25%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==3)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==0)) *ptr=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==1)) *ptr=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 5: //Dense 5/16=31%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%4==1)||((x%4==3)))) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==0)) *ptr=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 6: //Dense5Pattern 37%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==0)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%2==1)) *ptr=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 7: //Dense4-5Pattern 7/16=44%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%2==0)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==2)) *ptr=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%2==1)) *ptr=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 8: //Dense4Pattern 50%
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			if (y%2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%2!=0)) *ptr=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%2!=1)) *ptr=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 9: //solid
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			for (int x=pminX;x<=pmaxX;x++){
				b+= (*c);
				(*c)=0;
				if (b%2) *ptr=color;
				ptr++;
				c++;
			}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
//10: horizontal 1:3<br>
	case 10: 
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%4);
			if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)) *ptr=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 11: // FDiagPattern 27
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=((y+1)%4);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x/2)%4==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 12: // FDiagPattern 4
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=((y+1)%5);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 13: // FDiagPattern 72
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(((y+1)/2)%4);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 14: // VerPattern 4
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==1)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 15: // BDiagPattern 72
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=3-(((y+1)/2)%4);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 16: // BDiagPattern 4
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=4-((y+1)%5);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 17: // BDiagPattern 27
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=4-((y+1)%5);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x/2)%5==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 18: // CrossPattern 4
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=((y+3)%4);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)) *ptr=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%4==3)) *ptr=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 19: // DiagCrossPattern 4
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=((y+3)%5);
			short h2=4-((y+2)%5);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%5==h)||(x%5==h2))) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
// 20: horizontal 1:7<br>
	case 20: 
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%8);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)) *ptr=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 21: // FDiagPattern 27
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x/2)%8==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 22: // FDiagPattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 23: // FDiagPattern 72
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=((y/2)%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 24: // VerPattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==0)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 25: // BDiagPattern 72
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=7-((y/2)%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 26: // BDiagPattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=7-(y%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 27: // BDiagPattern 27
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=7-(y%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x/2)%8==h)) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 28: // CrossPattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%8);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)) *ptr=color;
					ptr++;
					c++;
				}
			else for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%8==0)) *ptr=color;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 29: // DiagCrossPattern
		for (int y=pminY;y<=pmaxY;y++){
	 	   	short b=0;
			short h=(y%8);
			short h2=7-(y%8);
			for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%8==h)||(x%8==h2))) *ptr=color;
					ptr++;
					c++;
				}
			
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 30: // DiagCrossPattern
			for (int y=pminY;y<=pmaxY;y++){// | o
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6<3)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%6==3)||(x%6==5))) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==5)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 31: 
		for (int y=pminY;y<=pmaxY;y++){// | |
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==5)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}		
		break;
	case 32: 
		for (int y=pminY;y<=pmaxY;y++){// - -
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6<3)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6>2)) *ptr=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 33: 
		for (int y=pminY;y<=pmaxY;y++){// -|
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6>2)) *ptr=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 34: 
		for (int y=pminY;y<=pmaxY;y++){// \/
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==0)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==2)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==5)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==5)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==3)) *ptr=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 35: 
		for (int y=pminY;y<=pmaxY;y++){// +/
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%6==0)||(x%6==2)||(x%6==1))) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%6==3)||(x%6==5)||(x%6==4))) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==5)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 36: 
		for (int y=pminY;y<=pmaxY;y++){// o/
	 	   	short b=0;
			short h=(y%6);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%6==0)||(x%6==2))) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==3)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==4)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%6==3)||(x%6==5))) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==5)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%6==4)) *ptr=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 37: 
		for (int y=pminY;y<=pmaxY;y++){//o
	 	   	short b=0;
			short h=(y%5);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%5==0)||(x%5==2))) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==1)) *ptr=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 38: 
		for (int y=pminY;y<=pmaxY;y++){//X
	 	   	short b=0;
			short h=(y%5);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%5==0)||(x%5==2))) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==1)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&((x%5==0)||(x%5==2))) *ptr=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	case 39: 
		for (int y=pminY;y<=pmaxY;y++){//cross
	 	   	short b=0;
			short h=(y%5);
			if (h==0)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==2)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==1)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5!=0)&&(x%5!=4)) *ptr=color;
					ptr++;
					c++;
				}
			else if (h==2)
				for (int x=pminX;x<=pmaxX;x++){
					b+= (*c);
					(*c)=0;
					if ((b%2)&&(x%5==2)) *ptr=color;
					ptr++;
					c++;
				}
			else 
				for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					ptr++;
					c++;
				}
		c+=line-fillLength;
		ptr+=w-fillLength;
		}
		break;
	default: //
		for (int y=pminY;y<=pmaxY;y++){
			for (int x=pminX;x<=pmaxX;x++){
					(*c)=0;
					c++;
				}
		c+=line-fillLength;
		}
		break;
	}}
        //printf("end\n");
	LImage->imageChanged=true;
  }
  if (elementDraw) drawElement();
}

void layoutImagePainter::drawPoint(QPoint po,uint color){
// cross for seelcted text elements
  QPoint p2=drawTrans.mapDraw(po);
  if (p2.x()<minX+3) return;
  if (p2.x()>maxX-3) return;
  if (p2.y()<minY+3) return;
  if (p2.y()>maxY-3) return;
  uint *ptr = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
  *ptr=color;
  uint *p;
  p=ptr;
  ptr-=w+1;
  *ptr=color;
  uint *p1;
  p1=ptr+2;
  *p1=color;
  ptr-=w+1;
  p1=ptr+4;
  *p1=color;
  *ptr=color;
  ptr-=w+1;
  *ptr=color;
  ptr+=6;
  *ptr=color;
  ptr=p+w-1;
  *ptr=color;
  p1=ptr+2;
  *p1=color;
  ptr+=w-1;
  *ptr=color;
  p1=ptr+4;
  *p1=color;
  ptr+=w-1;
  *ptr=color;
  p1=ptr+6;
  *p1=color;
  if (elementDraw) drawElement();
  LImage->imageChanged=true;
}

void layoutImagePainter::drawDot(QPoint po,uint color){
// dot for schematic crossing
  QPoint p2=drawTrans.mapDraw(po);
  if (p2.x()<minX+1) return;
  if (p2.x()>maxX-1) return;
  if (p2.y()<minY+1) return;
  if (p2.y()>maxY-1) return;
  uint *ptr = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
  *ptr=color;
  uint *p;
  p=ptr;
  ptr-=w+1;
  *ptr=color;
  ptr+=1;
  *ptr=color;
  ptr+=1;
  *ptr=color;
  ptr=p-1;
  *ptr=color;
  ptr=p+1;
  *ptr=color;
  ptr=p+w-1;
  *ptr=color;
  ptr+=1;
  *ptr=color;
  ptr+=1;
  *ptr=color;
  if (elementDraw) drawElement();
  LImage->imageChanged=true;
}

void layoutImagePainter::drawRing(QPoint po,uint color){
// ring for schemativ port
  QPoint p2=drawTrans.mapDraw(po);
  if (p2.x()<minX+2) return;
  if (p2.x()>maxX-2) return;
  if (p2.y()<minY+2) return;
  if (p2.y()>maxY-2) return;
  uint *ptr = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
  uint *p;
  p=ptr;
  ptr-=w+2;
  *ptr=color;
  ptr+=4;
  *ptr=color;
  ptr-=w+1;
  *ptr=color;
  ptr-=1;
  *ptr=color;
  ptr-=1;
  *ptr=color;
  ptr=p+2;
  *ptr=color;
  ptr=p-2;
  *ptr=color;
  ptr=p+w-2;
  *ptr=color;
  ptr+=4;
  *ptr=color;
  ptr+=w-1;
  *ptr=color;
  ptr+=-1;
  *ptr=color;
  ptr+=-1;
  *ptr=color;
  if (elementDraw) drawElement();
  LImage->imageChanged=true;
}

void layoutImagePainter::drawTarget(QPoint po,uint color){
// ring for schemativ port
  QPoint p2=drawTrans.mapDraw(po);
  if (p2.x()<minX+2) return;
  if (p2.x()>maxX-2) return;
  if (p2.y()<minY+2) return;
  if (p2.y()>maxY-2) return;
  drawRing(po,color);
  uint *ptr = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
  uint *p;
  p=ptr;
  if (p2.x()>minX+6){
    ptr=p;
    ptr-=4;
    *ptr=color;
    ptr-=1;
    *ptr=color;
    ptr-=1;
    *ptr=color;
  }
   if (p2.x()<maxX-6){
    ptr=p;
    ptr+=4;
    *ptr=color;
    ptr+=1;
    *ptr=color;
    ptr+=1;
    *ptr=color;
  }
   if (p2.y()>minY+6){
    ptr=p;
    ptr-=4*w;
    *ptr=color;
    ptr-=w;
    *ptr=color;
    ptr-=w;
    *ptr=color;
  }
   if (p2.y()<maxY-6){
    ptr=p;
    ptr+=4*w;
    *ptr=color;
    ptr+=w;
    *ptr=color;
    ptr+=w;
    *ptr=color;
  }
  LImage->imageChanged=true;
}

void layoutImagePainter::drawPixel(QPoint po,uint color){
  QPoint p2=drawTrans.mapDraw(po);
  if (p2.x()<minX) return;
  if (p2.x()>maxX) return;
  if (p2.y()<minY) return;
  if (p2.y()>maxY) return;

  uint *ptr = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
  *ptr=color;
  if (elementDraw) drawElement();
  LImage->imageChanged=true;

}


void layoutImagePainter::drawCircle(QPoint p1, QPoint p2,uint c){
if ((!visiblePoint(p1))&&(!visiblePoint(p2)))return;
QPoint p1c=drawTrans.mapDraw(p1);
QPoint p2c=drawTrans.mapDraw(p2);
QPoint pc=(p1c+p2c)/2;
QPoint pr=p1c-p2c;
color=c;
pointArray pa=element::ellipse(pc,pr.x()/2,pr.y()/2,5);
  for (int i=0;i<pa.size()-1;i++){
        drawLineLimit(pa.point(i),pa.point(i+1));
		//printf("line: %d , %d / %d , %d\n",out.point(i).x(),out.point(i).y(),out.point(i+1).x(),out.point(i+1).y());
	}
LImage->imageChanged=true;
}
void layoutImagePainter::drawArc(QPoint p1, QPoint p2,QPoint p3,uint c){
if ((!visiblePoint(p1))&&(!visiblePoint(p2))&& (!visiblePoint(p3)))return;
QPoint p1c=drawTrans.mapDraw(p1);
QPoint p2c=drawTrans.mapDraw(p2);
QPoint p3c=drawTrans.mapDraw(p3);
if (drawTrans.mirror_x){
	QPoint ph=p2c;
	p2c=p3c;
	p3c=ph;
	}
color=c;
pointArray pa=element::spirale(p1c,p2c,p3c,5);
  for (int i=0;i<pa.size()-1;i++){
        drawLineLimit(pa.point(i),pa.point(i+1));
		//printf("line: %d , %d / %d , %d\n",out.point(i).x(),out.point(i).y(),out.point(i+1).x(),out.point(i+1).y());
	}
LImage->imageChanged=true;
}

void layoutImagePainter::drawImage(QImage i,int x ,int y){
	int startx,stoppx,offx;
	int starty,stoppy,offy;
	startx=x;
	stoppx=x+i.width();
	starty=y;
	stoppy=y+i.height();
	offx=x;
	offy=y;
	if (startx<1){ startx=1;}
	if (starty<1){ starty=1;}
    if (stoppx>w){ stoppx=w;}
	if (stoppy>h){ stoppy=h;}
	//printf("-- %d %d\n",x,y);
	//printf("x %d %d %d\n",startx,stoppx,offx);
	//printf("y %d %d %d\n",starty,stoppy,offy);
	for (int ny=starty;ny<stoppy;ny++){
		uint *ptr = reinterpret_cast<uint *>(image->scanLine(ny)) +startx;
		uint *ptri = reinterpret_cast<uint *>(i.scanLine(ny-offy)) +startx-offx;
		for (int nx=startx;nx<stoppx;nx++){
			if (*ptri!=LImage->backgroundColor){
				*ptr=*ptri;
			}
			ptr++;
			ptri++;
		}
	}
LImage->imageChanged=true;

}

void layoutImagePainter::drawFTBitmap(FT_Bitmap *b,int x ,int y,uint color){
	int startx,stoppx,offx;
	int starty,stoppy,offy;
	startx=x;
	stoppx=x+b->width;
	starty=y;
	stoppy=y+b->rows;
	offx=x;
	offy=y;
	//printf("-- %d %d\n",x,y);
	//printf("x %d %d %d\n",startx,stoppx,offx);
	//printf("y %d %d %d\n",starty,stoppy,offy);
	//printf("pitch %d width %d\n",b->pitch,b->width);
	//printf("mode %d\n",b->pixel_mode);
	//if (FT_PIXEL_MODE_MONO==b->pixel_mode)printf("mono %d\n",b->pitch);
	if (startx<1){ startx=1;}
	if (starty<1){ starty=1;}
    if (stoppx>w){ stoppx=w;}
	if (stoppy>h){ stoppy=h;}
    
	for (int ny=starty;ny<stoppy;ny++){
		uint *ptr = reinterpret_cast<uint *>(image->scanLine(ny)) +startx;
		unsigned char *ptrb =b->buffer+(ny-offy)*b->pitch+((startx-offx)>>3);
		unsigned char comp;
		comp=128;
		for (int nx=startx;nx<stoppx;nx++){
			//printf("-- %d %d %d\n",(*ptrb),comp,nx);
			if ((*ptrb)&(comp)) *ptr=color;
			ptr++;
			if (comp==1) {
				comp=128;
				ptrb++;
			}
			else comp=comp>>1;
		// b->pitch;
		// b->buffer;

		}
	}
LImage->imageChanged=true;
}


bool layoutImagePainter::visibleBox(QPoint p1, QPoint p2){
if  (drawTrans.angle==0) return visibleBoxFast(p1,p2);
if  (drawTrans.angle==90) return visibleBoxFast(p1,p2);
if  (drawTrans.angle==180) return visibleBoxFast(p1,p2);
if  (drawTrans.angle==270) return visibleBoxFast(p1,p2);
return visibleBoxFull(p1,p2);
}

bool layoutImagePainter::visibleBoxFast(QPoint p1, QPoint p2){
if  (drawTrans.mag<1){
  QPoint p1_=drawTrans.mapDraw(p1);
  QPoint p2_=drawTrans.mapDraw(p2);
  if ((p1_.x()<minX+3)&&(p2_.x()<minX+3)) return false;
  if ((p1_.x()>maxX-3)&&(p2_.x()>maxX-3)) return false;
  if ((p1_.y()<minY+3)&&(p2_.y()<minY+3)) return false;
  if ((p1_.y()>maxY-3)&&(p2_.y()>maxY-3)) return false;
  return true;
  }
  QPointF p1_=drawTrans.mapDrawF(p1);
  QPointF p2_=drawTrans.mapDrawF(p2);
  if ((p1_.x()<qreal(minX+3))&&(p2_.x()<qreal(minX+3))) return false;
  if ((p1_.x()>qreal(maxX-3))&&(p2_.x()>qreal(maxX-3))) return false;
  if ((p1_.y()<qreal(minY+3))&&(p2_.y()<qreal(minY+3))) return false;
  if ((p1_.y()>qreal(maxY-3))&&(p2_.y()>qreal(maxY-3))) return false;
  return true;
}
bool layoutImagePainter::visibleBoxFull(QPoint p1, QPoint p2){
if  (drawTrans.mag<1){
  QPoint p1_=drawTrans.mapDraw(p1);
  QPoint p2_=drawTrans.mapDraw(p2);
  QPoint min=p1_,max=p1_;
  if (p2_.x()<min.x()) min.setX(p2_.x());
  if (p2_.y()<min.y()) min.setY(p2_.y());
  if (p2_.x()>max.x()) max.setX(p2_.x());
  if (p2_.y()>max.y()) max.setY(p2_.y());
  p2_=drawTrans.mapDraw(QPoint(p1.x(),p2.y()));
  if (p2_.x()<min.x()) min.setX(p2_.x());
  if (p2_.y()<min.y()) min.setY(p2_.y());
  if (p2_.x()>max.x()) max.setX(p2_.x());
  if (p2_.y()>max.y()) max.setY(p2_.y());
  p2_=drawTrans.mapDraw(QPoint(p2.x(),p1.y()));
  if (p2_.x()<min.x()) min.setX(p2_.x());
  if (p2_.y()<min.y()) min.setY(p2_.y());
  if (p2_.x()>max.x()) max.setX(p2_.x());
  if (p2_.y()>max.y()) max.setY(p2_.y());
  if ((max.x()<minX+3)) return false;
  if ((min.x()>maxX-3)) return false;
  if ((max.y()<minY+3)) return false;
  if ((min.y()>maxY-3)) return false;
  return true;
  }
  QPointF p1_=drawTrans.mapDrawF(p1);
  QPointF p2_=drawTrans.mapDrawF(p2);
  QPointF min=p1_,max=p1_;
  if (p2_.x()<min.x()) min.setX(p2_.x());
  if (p2_.y()<min.y()) min.setY(p2_.y());
  if (p2_.x()>max.x()) max.setX(p2_.x());
  if (p2_.y()>max.y()) max.setY(p2_.y());
  p2_=drawTrans.mapDrawF(QPoint(p1.x(),p2.y()));
  if (p2_.x()<min.x()) min.setX(p2_.x());
  if (p2_.y()<min.y()) min.setY(p2_.y());
  if (p2_.x()>max.x()) max.setX(p2_.x());
  if (p2_.y()>max.y()) max.setY(p2_.y());
  p2_=drawTrans.mapDrawF(QPoint(p2.x(),p1.y()));
  if (p2_.x()<min.x()) min.setX(p2_.x());
  if (p2_.y()<min.y()) min.setY(p2_.y());
  if (p2_.x()>max.x()) max.setX(p2_.x());
  if (p2_.y()>max.y()) max.setY(p2_.y());
  if ((max.x()<qreal(minX+3))) return false;
  if ((min.x()>qreal(maxX-3))) return false;
  if ((max.y()<qreal(minY+3))) return false;
  if ((min.y()>qreal(maxY-3))) return false;
  return true;
}

bool layoutImagePainter::visiblePoint(QPoint p1){
  if  (drawTrans.mag<1){
    QPoint p1_=drawTrans.mapDraw(p1);
    if ((p1_.x()<minX+3)) return false;
    if ((p1_.x()>maxX-3)) return false;
    if ((p1_.y()<minY+3)) return false;
    if ((p1_.y()>maxY-3)) return false;
    return true;
  }
    QPointF p1_=drawTrans.mapDrawF(p1);
    if ((p1_.x()<qreal(minX+3))) return false;
    if ((p1_.x()>qreal(maxX-3))) return false;
    if ((p1_.y()<qreal(minY+3))) return false;
    if ((p1_.y()>qreal(maxY-3))) return false;
    return true;
}

bool layoutImagePainter::convert(){
int i=0,k;
char a=0,b=0;
bool paint=false;
QPoint point,point_;
if (out.size()<3*in->size()) out.resize(3*in->size());
point=drawTrans.mapDraw(in->point(i));
point_=point;
if (point.y()>=maxY){point.setY(maxY);a=0;}
else if (point.y()<=minY){point.setY(minY);a=6;}
else a=3;
if (point.x()>=maxX){point.setX(maxX);a+=3;}
else if (point.x()<=minX){point.setX(minX);a+=1;}
else a+=2;
out.setPoint(0,point);
k=1;
for (i=1;i<in->size();i++){
        point=drawTrans.mapDraw(in->point(i));
	if (point.y()>=maxY){b=0;}
	else if (point.y()<=minY){b=6;}
	else b=3;
	if (point.x()>=maxX){b+=3;}
	else if (point.x()<=minX){b+=1;}
	else b+=2;
	
	//printf("comp %d\n",(a*10+b));
	switch (a*10+b){
	case 77:
	case 99:
	case 11:
	case 33: break;
	case 55: out.setPoint(k,point);k++;paint=true;break;
	case 78:
	case 88:
	case 98: out.setPoint(k,point.x(),minY);k++;break;
	case 12:
	case 22:
	case 32: out.setPoint(k,point.x(),maxY);k++;break;
	case 74:
	case 14:
	case 44: out.setPoint(k,minX,point.y());k++;break;
	case 96:
	case 36:
	case 66: out.setPoint(k,maxX,point.y());k++;break;
	case 17:
	case 97:
	case 87:
	case 47: out.setPoint(k,minX,minY);k++;break;
	case 39:
	case 79:
	case 89:
	case 69: out.setPoint(k,maxX,minY);k++;break;
	case 71:
	case 31:
	case 41:
	case 21: out.setPoint(k,minX,maxY);k++;break;
	case 93:
	case 13:
	case 63:
	case 23: out.setPoint(k,maxX,maxY);k++;break;
	case 85: if (point.x()!=point_.x()) {out.setPoint(k,point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY);k++;}
		 out.setPoint(k,point);k++;paint=true;break;
	case 25: if (point.x()!=point_.x()) {out.setPoint(k,point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY);k++;}
		 out.setPoint(k,point);k++;paint=true;break;
	case 65: if (point.y()!=point_.y()) {out.setPoint(k,maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x()));k++;}
		 out.setPoint(k,point);k++;paint=true;break;
	case 45: if (point.y()!=point_.y()) {out.setPoint(k,minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x()));k++;}
		 out.setPoint(k,point);k++;paint=true;break;
	case 58: if (point.x()!=point_.x()) {out.setPoint(k,point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY);k++;}
		out.setPoint(k,point.x(),minY);k++;paint=true;break;
	case 52: if (point.x()!=point_.x()) {out.setPoint(k,point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY);k++;}
		out.setPoint(k,point.x(),maxY);k++;paint=true;break;
	case 56: if (point.y()!=point_.y()) {out.setPoint(k,maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x()));k++;}
		out.setPoint(k,maxX,point.y());k++;paint=true;break;
	case 54: if (point.y()!=point_.y()) {out.setPoint(k,minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x()));k++;}
		out.setPoint(k,minX,point.y());k++;paint=true;break;
	case 53: {QPoint h1=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x()));
		QPoint h2=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY);
		if (h1.y()<maxY){h2=h1;}
		out.setPoint(k,h2);k++;}out.setPoint(k,maxX,maxY);k++;paint=true;break;
	case 35: {QPoint h1=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x()));
		QPoint h2=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY);
		if (h1.y()<maxY){h2=h1;}
		out.setPoint(k,h2);k++;}out.setPoint(k,point);k++;paint=true;break;
	case 59: {QPoint h1=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x()));
		QPoint h2=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY);
		if (h1.y()>minY){h2=h1;}
		out.setPoint(k,h2);k++;}out.setPoint(k,maxX,minY);k++;paint=true;break;
	case 95: {QPoint h1=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x()));
		QPoint h2=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY);
		if (h1.y()>minY){h2=h1;}
		out.setPoint(k,h2);k++;}out.setPoint(k,point);k++;paint=true;break;
	case 57: {QPoint h1=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x()));
		QPoint h2=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY);
		if (h1.y()>minY){h2=h1;}
		out.setPoint(k,h2);k++;}out.setPoint(k,minX,minY);k++;paint=true;break;
	case 75: {QPoint h1=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x()));
		QPoint h2=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY);
		if (h1.y()>minY){h2=h1;}
		out.setPoint(k,h2);k++;}out.setPoint(k,point);k++;paint=true;break;
	case 51: {QPoint h1=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x()));
		QPoint h2=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY);
		if (h1.y()<maxY){h2=h1;}
		out.setPoint(k,h2);k++;}out.setPoint(k,minX,maxY);k++;paint=true;break;
	case 15: {QPoint h1=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x()));
		QPoint h2=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY);
		if (h1.y()<maxY){h2=h1;}
		out.setPoint(k,h2);k++;}out.setPoint(k,point);k++;paint=true;break;
	case 43: {QPoint h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,minX,maxY);k++;}
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 out.setPoint(k,maxX,maxY);k++;
		 }paint=true; break;
	case 83: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,maxX,minY);k++;}
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;};
		 out.setPoint(k,maxX,maxY);k++;
		 }paint=true; break;
	case 76: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;};
		 h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,maxX,minY);k++;}
		 out.setPoint(k,maxX,point.y());k++; 
		 } paint=true;break;
	case 73: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else if (h.x()>maxX){out.setPoint(k,maxX,minY);k++;}
		 h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else if (h.x()<minX){out.setPoint(k,minX,maxY);k++;}
		 h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 out.setPoint(k,maxX,maxY);k++;
		 }paint=true; break;
	case 72: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,minX,maxY);k++;}
		 out.setPoint(k,point.x(),maxY);k++; 
		 }paint=true; break;
	case 81: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,minX,minY);k++;}
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 out.setPoint(k,minX,maxY);k++; 
		 }paint=true; break;
	case 61: {QPoint h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,maxX,maxY);k++;}
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 out.setPoint(k,minX,maxY);k++; 
		 }paint=true; break;
	case 92: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,maxX,maxY);k++;}
		 out.setPoint(k,point.x(),maxY);k++; 
		 }paint=true; break;
	case 91: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else if (h.x()<minX){out.setPoint(k,minX,minY);k++;}
		 h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else if (h.x()>maxX) {out.setPoint(k,maxX,maxY);k++;}
		 h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 out.setPoint(k,minX,maxY);k++; 
		 }paint=true; break;
	case 94: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,minX,minY);k++;}
		 out.setPoint(k,minX,point.y());k++; 
		 }paint=true; break;
	case 49: {QPoint h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,minX,minY);k++;}
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 out.setPoint(k,maxX,minY);k++;
		 }paint=true; break;
	case 29: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,maxX,maxY);k++;}
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 out.setPoint(k,maxX,minY);k++;
		 }paint=true; break;
	case 18: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,minX,minY);k++;}
		 out.setPoint(k,point.x(),minY);k++;
		 }paint=true; break;
	case 19: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else if (h.x()>maxX) {out.setPoint(k,maxX,maxY);k++;}
		 h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else if (h.x()<minX) {out.setPoint(k,minX,minY);k++;}
		 h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;};
		 out.setPoint(k,maxX,minY);k++;
		 }paint=true; break;
	case 16: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,maxX,maxY);k++;}
		 out.setPoint(k,maxX,point.y());k++; 
		 }paint=true; break;
	case 27: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {
		 	out.setPoint(k,h);k++;
		 	h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 	if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 	h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 	if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 } else {out.setPoint(k,minX,maxY);k++;}
		 out.setPoint(k,minX,minY);k++;
		 }paint=true;break;
	case 67: {QPoint h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {
		  	out.setPoint(k,h);k++;
		 	h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 	if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 	h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 	if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 } else {out.setPoint(k,maxX,minY);k++;}
		 out.setPoint(k,minX,minY);k++;
		 }paint=true; break;
	case 34: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;} 
		 else {out.setPoint(k,minX,maxY);k++;}
		 out.setPoint(k,minX,point.y());k++;
		 }paint=true; break;
	case 37: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else if (h.x()>maxX) {out.setPoint(k,maxX,minY);k++;};
		 h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 else if (h.y()>maxY) {out.setPoint(k,minX,maxY);k++;};
		 out.setPoint(k,minX,minY);k++;
		 }paint=true; break;
	case 38: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 else {out.setPoint(k,maxX,minY);k++;}
		 out.setPoint(k,point.x(),minY);k++;
		 }paint=true; break;
	case 48: {QPoint h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {
		 	out.setPoint(k,h);k++;
		 	h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 	out.setPoint(k,h);k++;}
		 else {out.setPoint(k,minX,minY);k++;}
		 out.setPoint(k,point.x(),minY);k++;
		 }paint=true; break;
	case 46: {QPoint h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 out.setPoint(k,h);k++;
		 h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 out.setPoint(k,h);k++;
		 out.setPoint(k,maxX,point.y());k++; 
		 }paint=true; break;
	case 42: {QPoint h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {
		 	out.setPoint(k,h);k++;
		 	h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 	out.setPoint(k,h);k++;}
		 else {out.setPoint(k,minX,maxY);k++;}
		 out.setPoint(k,point.x(),maxY);k++;
		 }paint=true; break;
	case 84: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {
		 	out.setPoint(k,h);k++;
		 	h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 	out.setPoint(k,h);k++;}
		 else {out.setPoint(k,minX,minY);k++;}
		 out.setPoint(k,minX,point.y());k++;
		 }paint=true; break;
	case 82: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 out.setPoint(k,h);k++;
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 out.setPoint(k,h);k++;
		 out.setPoint(k,point.x(),maxY);k++;
		 }paint=true; break;
	case 86: {QPoint  h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {
		 	out.setPoint(k,h);k++;
		 	h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
			out.setPoint(k,h);k++;}
		 else {out.setPoint(k,maxX,minY);k++;}
		 out.setPoint(k,maxX,point.y());k++;
		 }paint=true; break;
	case 68: {QPoint h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {
		 	out.setPoint(k,h);k++; 
		 	h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
			out.setPoint(k,h);k++;}
		 else {out.setPoint(k,maxX,minY);k++;}
		 out.setPoint(k,point.x(),minY);k++;
		 }paint=true; break;
	case 64: {QPoint h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 out.setPoint(k,h);k++;
		 h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 out.setPoint(k,h);k++;
		 out.setPoint(k,minX,point.y());k++;
		 }paint=true; break;
	case 62: {QPoint  h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 if ((h.y()>=minY)&&(h.y()<=maxY)) {
		 	out.setPoint(k,h);k++;
		 	h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
			out.setPoint(k,h);k++;}
		 else  {out.setPoint(k,maxX,maxY);k++;};
		 out.setPoint(k,point.x(),maxY);k++;
		 }paint=true; break;
	case 24: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {
		 	out.setPoint(k,h);k++;
		 	h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		        out.setPoint(k,h);k++;}
		 else  {out.setPoint(k,minX,maxY);k++;};
		 out.setPoint(k,minX,point.y());k++;
		 }paint=true; break;
	case 28: {QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 out.setPoint(k,h);k++;
		 h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 out.setPoint(k,h);k++;
		 out.setPoint(k,point.x(),minY);k++;
		 }paint=true; break;
	case 26: {QPoint  h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 if ((h.x()>=minX)&&(h.x()<=maxX)) {
		 	out.setPoint(k,h);k++;
		 	h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 	out.setPoint(k,h);k++; } 
		 else {out.setPoint(k,maxX,maxY);k++;};
		 out.setPoint(k,maxX,point.y());k++;
		 }paint=true; break;
	default: 
           point_=point;
	   if (point.y()>=maxY){point_.setY(maxY);}
	   else if (point.y()<=minY){point_.setY(minY);}
	   if (point.x()>=maxX){point_.setX(maxX);}
           else if (point.x()<=minX){point_.setX(minX);}
	   out.setPoint(k,point_);k++;
	  // printf("missing %d\n",(a*10+b));
	   break;
	}
	point_=point;
	a=b;
	}
//out.resize(k);
outSize=k;
return paint;
}

bool layoutImagePainter::convertFill(){
  int i=0,k;
  uchar a=0,b=0;
  bool paint=false;
  QPoint point,point_;
  if (out.size()<3*in->size()) out.resize(3*in->size());
  point=drawTrans.mapDraw(in->point(i));
  point_=point;
  if (point.y()>=maxY){point.setY(maxY);a=0;}
  else if (point.y()<=minY){point.setY(minY);a=6;}
  else a=3;
  if (point.x()>=maxX){point.setX(maxX);a+=3;}
  else if (point.x()<=minX){point.setX(minX);a+=1;}
  else a+=2;
  out.setPoint(0,point);
  pmaxX=point.x();
  pminX=point.x();
  pmaxY=point.y();
  pminY=point.y();
  k=1;
  for (i=1;i<in->size();i++){
        point=drawTrans.mapDraw(in->point(i));
	if (point.y()>=maxY){b=0;}
	else if (point.y()<=minY){b=6;}
	else b=3;
	if (point.x()>=maxX){b+=3;}
	else if (point.x()<=minX){b+=1;}
	else b+=2;
	//printf("comp %d  k:%d\n",(a*10+b),k);
	uchar c=((a<<4)+b);
	if (c<0x46) {
		if (c<0x28) {
		    if (c<0x19) {
			if (c<0x15){
				if (c<0x13) {
					if (c<0x12) { 	//11
						// ignore
					} else
					{ 		//12
							out.setPoint(k,point.x(),maxY);
							k++;
							if (point.x()>pmaxX) pmaxX=point.x();
					}
					}
				else 	{
					if (c<0x14) { 	//13
							out.setPoint(k,maxX,maxY);k++;
							pmaxX=maxX;
					}
					else { 		//14
							out.setPoint(k,minX,point.y());k++;
							if (point.y()<pminY) pminY=point.y();
					}
				}
			} else
			{	if (c<0x17) {
					if (c<0x16) { 	//15
							{QPoint h1=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x()));
							QPoint h2=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY);
							if (h1.y()<maxY){h2=h1;}
							out.setPoint(k,h2);k++;}out.setPoint(k,point);k++;
							if (point.x()>pmaxX) pmaxX=point.x();
							if (point.y()<pminY) pminY=point.y();
							paint=true;
					} else
					{ 		//16
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++; }; 
		 					h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++; }
		 					else {out.setPoint(k,maxX,maxY);k++; }
		 					out.setPoint(k,maxX,point.y());k++;
							pmaxX=maxX;
							if (point.y()<pminY) pminY=point.y();
							paint=true;
					}
				} else {
					if (c<0x18) { 	//17
							out.setPoint(k,minX,minY);k++;
							pminY=minY;
					} else
					{ 		//18
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,minX,minY);k++;}
		 					out.setPoint(k,point.x(),minY);k++;
							if (point.x()>pmaxX) pmaxX=point.x();
							pminY=minY;
							paint=true;
					}
				}
			}
		    }
		    else {
			if (c<0x24){
				if (c<0x22) {
					if (c<0x20) { 	//19
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else if (h.x()>maxX) {out.setPoint(k,maxX,maxY);k++;}
		 					h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else if (h.x()<minX) {out.setPoint(k,minX,minY);k++;}
		 					h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;};
		 					out.setPoint(k,maxX,minY);k++;
							pminY=minY;
							pmaxX=maxX;
							paint=true;
					} else
					{ 		//21
							out.setPoint(k,minX,maxY);k++;
							pminX=minX;
					}
					}
				else 	{
					if (c<0x23) { 	//22
							out.setPoint(k,point.x(),maxY);k++;
							if (point.x()<pminX) pminX=point.x();
							if (point.x()>pmaxX) pmaxX=point.x();
					}
					else { 		//23
							out.setPoint(k,maxX,maxY);k++;
							pmaxX=maxX;
					}
				}
			} else
			{	if (c<0x26) {
					if (c<0x25) { 	//24
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {
		 						out.setPoint(k,h);k++;
		 						h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 					       out.setPoint(k,h);k++;}
		 					else  {out.setPoint(k,minX,maxY);k++;};
		 					out.setPoint(k,minX,point.y());k++;
							if (point.y()<pminY) pminY=point.y();
							pminX=minX;
							paint=true;
					} else
					{ 		//25
							if (point.x()!=point_.x()) {out.setPoint(k,point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY);k++;}
		 					out.setPoint(k,point);k++;
							if (point.x()<pminX) pminX=point.x();
							if (point.x()>pmaxX) pmaxX=point.x();
							if (point.y()<pminY) pminY=point.y();
							paint=true;
					}
				} else {
					if (c<0x27) { 	//26
							QPoint  h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {
		 						out.setPoint(k,h);k++;
		 						h=QPoint(maxX,point_.y()+(long long) (point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 						out.setPoint(k,h);k++; } 
		 					else {out.setPoint(k,maxX,maxY);k++;};
		 					out.setPoint(k,maxX,point.y());k++;
							if (point.y()<pminY) pminY=point.y();
							pmaxX=maxX;
							paint=true;
					} else
					{ 		//27
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {
		 						out.setPoint(k,h);k++;
		 						h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 						if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 						h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 						if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					} else {out.setPoint(k,minX,maxY);k++;}
		 					out.setPoint(k,minX,minY);k++;
							pminX=minX;
							pminY=minY;
							paint=true;
					}
				}
			}
		    }
		
		}
		else
		 {
		    if (c<0x37) {
			if (c<0x33){
				if (c<0x31) {
					if (c<0x29) { 	//28
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					out.setPoint(k,h);k++;
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 					out.setPoint(k,h);k++;
		 					out.setPoint(k,point.x(),minY);k++;
							pminY=minY;
							if (point.x()<pminX) pminX=point.x();
							if (point.x()>pmaxX) pmaxX=point.x();
							paint=true;
					} else
					{ 		//29
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,maxX,maxY);k++;}
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					out.setPoint(k,maxX,minY);k++;
							pmaxX=maxX;
							pminY=minY;
							paint=true;
					}
					}
				else 	{
					if (c<0x32) { 	//31
							out.setPoint(k,minX,maxY);k++;
							pminX=minX;
					}
					else { 		//32
							out.setPoint(k,point.x(),maxY);k++;
							if (point.x()<pminX) pminX=point.x();
					}
				}
			} else
			{	if (c<0x35) {
					if (c<0x34) { 	//33
							// ignore
					} else
					{ 		//34
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;} 
		 					else {out.setPoint(k,minX,maxY);k++;}
		 					out.setPoint(k,minX,point.y());k++;
							pminX=minX;
							if (point.y()<pminY) pminY=point.y();
							paint=true;
					}
				} else {
					if (c<0x36) { 	//35
							{QPoint h1=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x()));
							QPoint h2=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY);
							if (h1.y()<maxY){h2=h1;}
							out.setPoint(k,h2);k++;}out.setPoint(k,point);k++;
							if (point.x()<pminX) pminX=point.x();
							if (point.y()<pminY) pminY=point.y();
							paint=true;
					} else
					{ 		//36
							out.setPoint(k,maxX,point.y());k++;
							if (point.y()<pminY) pminY=point.y();
					}
				}
			}
		    }
		    else {
			if (c<0x42){
				if (c<0x39) {
					if (c<0x38) { 	//37
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else if (h.x()>maxX) {out.setPoint(k,maxX,minY);k++;};
		 					h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 					else if (h.y()>maxY) {out.setPoint(k,minX,maxY);k++;};
		 					out.setPoint(k,minX,minY);k++;
							pminX=minX;
							pminY=minY;
							paint=true;
					} else
					{ 		//38
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,maxX,minY);k++;}
		 					out.setPoint(k,point.x(),minY);k++;
							pminY=minY;
							if (point.x()<pminX) pminX=point.x();
							paint=true;
					}
					}
				else 	{
					if (c<0x41) { 	//39
							out.setPoint(k,maxX,minY);k++;
							pminY=minY;
					}
					else { 		//41
							out.setPoint(k,minX,maxY);k++;
							pmaxY=maxY;
					}
				}
			} else
			{	if (c<0x44) {
					if (c<0x43) { 	//42
							QPoint h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {
		 						out.setPoint(k,h);k++;
		 						h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 						out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,minX,maxY);k++;}
		 					out.setPoint(k,point.x(),maxY);k++;
							pmaxY=maxY;
							if (point.x()>pmaxX) pmaxX=point.x();
							paint=true;
					} else
					{ 		//43
							QPoint h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,minX,maxY);k++;}
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
							if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					out.setPoint(k,maxX,maxY);k++;
							pmaxX=maxX;
							pmaxY=maxY;
							paint=true;
					}
				} else {
					if (c<0x45) { 	//44
							out.setPoint(k,minX,point.y());k++;
							if (point.y()<pminY) pminY=point.y();
							if (point.y()>pmaxY) pmaxY=point.y();
					} else
					{ 		//45
							if (point.y()!=point_.y()) {out.setPoint(k,minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x()));k++;}
		 					out.setPoint(k,point);k++;
							if (point.x()>pmaxX) pmaxX=point.x();
							if (point.y()<pminY) pminY=point.y();
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					}
				}
			}
		    }
		
		}
	}
	else if (c<0x82)	
	    {
		if (c<0x64) {
		    if (c<0x55) {
			if (c<0x51){
				if (c<0x48) {
					if (c<0x47) { 	//46
							QPoint h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 					out.setPoint(k,h);k++;
		 					h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 					out.setPoint(k,h);k++;
		 					out.setPoint(k,maxX,point.y());k++;
							pmaxX=maxX;
							if (point.y()<pminY) pminY=point.y();
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					} else
					{ 		//47
							out.setPoint(k,minX,minY);k++;
							pminY=minY;
					}
					}
				else 	{
					if (c<0x49) { 	//48
							QPoint h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {
							 	out.setPoint(k,h);k++;
							 	h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
							 	out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,minX,minY);k++;}
		 					out.setPoint(k,point.x(),minY);k++;
							if (point.x()>pmaxX) pmaxX=point.x();
							pminY=minY;
							paint=true;
					}
					else { 		//49
							QPoint h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,minX,minY);k++;}
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					out.setPoint(k,maxX,minY);k++;
							pmaxX=maxX;
							pminY=minY;
							paint=true;
					}
				}
			} else
			{	if (c<0x53) {
					if (c<0x52) { 	//51
							{QPoint h1=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x()));
							QPoint h2=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY);
							if (h1.y()<maxY){h2=h1;}
							out.setPoint(k,h2);k++;}out.setPoint(k,minX,maxY);k++;
							pminX=minX;
							pmaxY=maxY;
							paint=true;
					} else
					{ 		//52
							if (point.x()!=point_.x()) {out.setPoint(k,point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY);k++;}
							out.setPoint(k,point.x(),maxY);k++;
							if (point.x()<pminX) pminX=point.x();
							if (point.x()>pmaxX) pmaxX=point.x();
							pmaxY=maxY;
							paint=true;
					}
				} else {
					if (c<0x54) { 	//53
							{QPoint h1=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x()));
							QPoint h2=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY);
							if (h1.y()<maxY){h2=h1;}
							out.setPoint(k,h2);k++;}out.setPoint(k,maxX,maxY);k++;
							pmaxX=maxX;
							pmaxY=maxY;
							paint=true;
					} else
					{ 		//54
							if (point.y()!=point_.y()) {out.setPoint(k,minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x()));k++;}
							out.setPoint(k,minX,point.y());k++;
							pminX=minX;
							if (point.y()<pminY) pminY=point.y();
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					}
				}
			}
		    }
		    else {
			if (c<0x59){
				if (c<0x57) {
					if (c<0x56) { 	//55
							out.setPoint(k,point);k++;
							if (point.x()<pminX) pminX=point.x();
							if (point.x()>pmaxX) pmaxX=point.x();
							if (point.y()<pminY) pminY=point.y();
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					} else
					{ 		//56
							if (point.y()!=point_.y()) {out.setPoint(k,maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x()));k++;}
							out.setPoint(k,maxX,point.y());k++;
							pmaxX=maxX;
							if (point.y()<pminY) pminY=point.y();
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					}
					}
				else 	{
					if (c<0x58) { 	//57
							{QPoint h1=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x()));
							QPoint h2=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY);
							if (h1.y()>minY){h2=h1;}
							out.setPoint(k,h2);k++;}out.setPoint(k,minX,minY);k++;
							pminY=minY;
							pminX=minX;
							paint=true;
					}
					else { 		//58
							if (point.x()!=point_.x()) {out.setPoint(k,point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY);k++;}
							out.setPoint(k,point.x(),minY);k++;
							if (point.x()<pminX) pminX=point.x();
							if (point.x()>pmaxX) pmaxX=point.x();
							pminY=minY;
							paint=true;
					}
				}
			} else
			{	if (c<0x62) {
					if (c<0x61) { 	//59
							{QPoint h1=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x()));
							QPoint h2=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY);
							if (h1.y()>minY){h2=h1;}
							out.setPoint(k,h2);k++;}out.setPoint(k,maxX,minY);k++;
							pmaxX=maxX;
							pminY=minY;
							paint=true;
					} else
					{ 		//61
							QPoint h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,maxX,maxY);k++;}
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					out.setPoint(k,minX,maxY);k++;
							pmaxY=maxY;
							pminX=minX;
							paint=true;
					}
				} else {
					if (c<0x63) { 	//62
							QPoint  h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {
		 						out.setPoint(k,h);k++;
		 						h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
								out.setPoint(k,h);k++;}
		 					else  {out.setPoint(k,maxX,maxY);k++;};
		 					out.setPoint(k,point.x(),maxY);k++;
							if (point.x()<pminX) pminX=point.x();
							pmaxY=maxY;
							paint=true;
					} else
					{ 		//63
							out.setPoint(k,maxX,maxY);k++;
							pmaxY=maxY;
					}
				}
			}
		    }
		
		}
		else
		 {
		    if (c<0x73) {
			if (c<0x68){
				if (c<0x66) {
					if (c<0x65) { 	//64
							QPoint h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 					out.setPoint(k,h);k++;
		 					h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 					out.setPoint(k,h);k++;
		 					out.setPoint(k,minX,point.y());k++;
							pminX=minX;
							if (point.y()<pminY) pminY=point.y();
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					} else
					{ 		//65
							if (point.y()!=point_.y()) {out.setPoint(k,maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x()));k++;}
		 					out.setPoint(k,point);k++;
							if (point.x()<pminX) pminX=point.x();
							if (point.y()<pminY) pminY=point.y();
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					}
					}
				else 	{
					if (c<0x67) { 	//66
							out.setPoint(k,maxX,point.y());k++;
							if (point.y()<pminY) pminY=point.y();
							if (point.y()>pmaxY) pmaxY=point.y();
						
					}
					else { 		//67
							QPoint h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {
		  						out.setPoint(k,h);k++;
		 						h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
		 						if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 						h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 						if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					} else {out.setPoint(k,maxX,minY);k++;}
		 					out.setPoint(k,minX,minY);k++;
							pminX=minX;
							pminY=minY;
							paint=true;
					}
				}
			} else
			{	if (c<0x71) {
					if (c<0x69) { 	//68
							QPoint h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {
		 						out.setPoint(k,h);k++; 
		 						h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-minY)/(point.y()-point_.y()),minY); //top
								out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,maxX,minY);k++;}
		 					out.setPoint(k,point.x(),minY);k++;
							pminY=minY;
							if (point.x()<pminX) pminX=point.x();
							paint=true;
					} else
					{ 		//69
							out.setPoint(k,maxX,minY);k++;
							pminY=minY;
					}
				} else {
					if (c<0x72) { 	//71
							out.setPoint(k,minX,maxY);k++;
							pmaxY=maxY;
					} else
					{ 		//72
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,minX,maxY);k++;}
		 					out.setPoint(k,point.x(),maxY);k++;
							pmaxY=maxY;
							if (point.x()>pmaxX) pmaxX=point.x();
							paint=true;
					}
				}
			}
		    }
		    else {
			if (c<0x77){
				if (c<0x75) {
					if (c<0x74) { 	//73
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else if (h.x()>maxX){out.setPoint(k,maxX,minY);k++;}
		 					h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else if (h.x()<minX){out.setPoint(k,minX,maxY);k++;}
		 					h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					out.setPoint(k,maxX,maxY);k++;
							pmaxX=maxX;
							pmaxY=maxY;
							paint=true;
					} else
					{ 		//74
							out.setPoint(k,minX,point.y());k++;
							if (point.y()>pmaxY) pmaxY=point.y();
					}
					}
				else 	{
					if (c<0x76) { 	//75
							{QPoint h1=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x()));
							QPoint h2=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY);
							if (h1.y()>minY){h2=h1;}
							out.setPoint(k,h2);k++;}out.setPoint(k,point);k++;
							if (point.x()>pmaxX) pmaxX=point.x();
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					}
					else { 		//76
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(minX,point.y()-(long long)(point.y()-point_.y())*(point.x()-minX)/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;};
			 				h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,maxX,minY);k++;}
		 					out.setPoint(k,maxX,point.y());k++;
							pmaxX=maxX;
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					}
				}
			} else
			{	if (c<0x79) {
					if (c<0x78) { 	//77
							// ignore
					} else
					{ 		//78
							out.setPoint(k,point.x(),minY);k++;
							if (point.x()>pmaxX) pmaxX=point.x();
					}
				} else {
					if (c<0x81) { 	//79
							out.setPoint(k,maxX,minY);k++;
							pmaxX=maxX;
					} else
					{ 		//81
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
							 else {out.setPoint(k,minX,minY);k++;}
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					out.setPoint(k,minX,maxY);k++;
							pmaxY=maxY;
							pminX=minX;
							paint=true;
					}
				}
			}
		    }
		
		}
	}
	else 
	    {
		if (c<0x99) {
		    if (c<0x91) {
			if (c<0x86){
				if (c<0x84) {
					if (c<0x83) { 	//82
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 					out.setPoint(k,h);k++;
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					out.setPoint(k,h);k++;
		 					out.setPoint(k,point.x(),maxY);k++;
							pmaxY=maxY;
							if (point.x()<pminX) pminX=point.x();
							if (point.x()>pmaxX) pmaxX=point.x();
							paint=true;
					} else
					{ 		//83
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,maxX,minY);k++;}
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
							 if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;};
		 					out.setPoint(k,maxX,maxY);k++;
							pmaxX=maxX;
							pmaxY=maxY;
							paint=true;
					}
					}
				else 	{
					if (c<0x85) { 	//84
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {
							 	out.setPoint(k,h);k++;
							 	h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
							 	out.setPoint(k,h);k++;}
							 else {out.setPoint(k,minX,minY);k++;}
		 					out.setPoint(k,minX,point.y());k++;
							pminX=minX;
							if (point.y()>pmaxY) pmaxY=point.y();
					}
					else { 		//85
							if (point.x()!=point_.x()) {out.setPoint(k,point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY);k++;}
							out.setPoint(k,point);k++;
							if (point.x()<pminX) pminX=point.x();
							if (point.x()>pmaxX) pmaxX=point.x();
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					}
				}
			} else
			{	if (c<0x88) {
					if (c<0x87) { 	//86
							QPoint  h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {
		 						out.setPoint(k,h);k++;
		 						h=QPoint(maxX,point_.y()+(long long)(point.y()-point_.y())*(maxX-point_.x())/(point.x()-point_.x())); //right
								out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,maxX,minY);k++;}
		 					out.setPoint(k,maxX,point.y());k++;
							pmaxX=maxX;
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					} else
					{ 		//87
							out.setPoint(k,minX,minY);k++;
							pminX=minX;
					}
				} else {
					if (c<0x89) { 	//88
							out.setPoint(k,point.x(),minY);k++;
							if (point.x()<pminX) pminX=point.x();
							if (point.x()>pmaxX) pmaxX=point.x();
					} else
					{ 		//89
							out.setPoint(k,maxX,minY);k++;
							pmaxX=maxX;
							pminY=minY;
					}
				}
			}
		    }
		    else {
			if (c<0x95){
				if (c<0x93) {
					if (c<0x92) { 	//91
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else if (h.x()<minX){out.setPoint(k,minX,minY);k++;}
		 					h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else if (h.x()>maxX) {out.setPoint(k,maxX,maxY);k++;}
		 					h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					out.setPoint(k,minX,maxY);k++;
							pminX=minX;
							pmaxY=maxY;
							paint=true;
					} else
					{ 		//92
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					h=QPoint(point_.x()-(long long)(point.x()-point_.x())*(point_.y()-maxY)/(point.y()-point_.y()),maxY); //bottom
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,maxX,maxY);k++;}
		 					out.setPoint(k,point.x(),maxY);k++;
							pmaxY=maxY;
							if (point.x()<pminX) pminX=point.x();
							paint=true;
					}
					}
				else 	{
					if (c<0x94) { 	//93
							out.setPoint(k,maxX,maxY);k++;
							pmaxX=maxX;
							pmaxY=maxY;
							paint=true;
					}
					else { 		//94
							QPoint h=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY); //top
		 					if ((h.x()>=minX)&&(h.x()<=maxX)) {out.setPoint(k,h);k++;};
		 					h=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x())); //right
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}; 
		 					h=QPoint(minX,point_.y()+(long long)(point.y()-point_.y())*(minX-point_.x())/(point.x()-point_.x())); //left
		 					if ((h.y()>=minY)&&(h.y()<=maxY)) {out.setPoint(k,h);k++;}
		 					else {out.setPoint(k,minX,minY);k++;}
		 					out.setPoint(k,minX,point.y());k++;
							pminX=minX;
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					}
				}
			} else
			{	if (c<0x97) {
					if (c<0x96) { 	//95
							{QPoint h1=QPoint(maxX,point.y()-(long long)(point.y()-point_.y())*(point.x()-maxX)/(point.x()-point_.x()));
							QPoint h2=QPoint(point.x()-(long long)(point.x()-point_.x())*(point.y()-minY)/(point.y()-point_.y()),minY);
							if (h1.y()>minY){h2=h1;}
							out.setPoint(k,h2);k++;}out.setPoint(k,point);k++;
							if (point.x()<pminX) pminX=point.x();
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					} else
					{ 		//96
							out.setPoint(k,maxX,point.y());k++;
							if (point.y()>pmaxY) pmaxY=point.y();
							paint=true;
					}
				} else {
					if (c<0x98) { 	//97
							out.setPoint(k,minX,minY);k++;
							pminX=minX;
							paint=true;
					} else
					{ 		//98
							out.setPoint(k,point.x(),minY);k++;
							if (point.x()<pminX) pminX=point.x();
							paint=true;
					}
				}
			}
		    }
		
		}
		else 					// 99
							// ignore
		 {
		    }
		
	}

	point_=point;
	a=b;
	}
//out.resize(k);
outSize=k;
//printf("k:%d\n",k);
//for (int i=0;i<out.size();i++){
// printf("%d: %d,%d\n",k,out.point(i).x(),out.point(i).y());
//}
return paint;
}

void layoutImagePainter::drawLine(QPoint p1, QPoint p2,uint c){
  // nur fr senkrechte und waagereichte linien
  color=c;
  drawLine(limit(p1),limit(p2));
  
  if (elementDraw) drawElement();
  LImage->imageChanged=true;
}


void layoutImagePainter::drawLine(QPoint p1, QPoint p2)
{
  QPoint delta=p2-p1;
  if (delta.x()==0) {  
	if (delta.y()==0) {
		uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
		*ptr=color;
		return;
		}
	//senkrecht
 	if (p1.x()==0) return;
 	if (p1.x()==maxX) return; 
  	if (p1.y()>p2.y()) 
		{
		QPoint h=p2;
		p2=p1;
		p1=h;
		}
 	 uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
  	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p1.x();
  	for (;ptr<=end;ptr+=w){
		*ptr = color;
		}
 	}
  else if (delta.y()==0) { //waagerecht
 	if (p1.y()==0) return;
 	if (p1.y()==maxY) return; 
 	 if (p1.x()>p2.x()) 
		{
		QPoint h=p2;
		p2=p1;
		p1=h;
		}
  	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
  	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
 	 for (;ptr<=end;ptr++){
		*ptr = color;
		}
 	}
  else if (abs(delta.x())>=abs(delta.y())){ //leichte steigung
 	float off=(float)delta.y()/(delta.x());
 	if (p1.x()>p2.x()){
		QPoint h=p1;
		p1=p2;
		p2=h;
		}
 	
 	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	if (off>0){
		float d=0;
 		for (;ptr!=end;ptr++){
			*ptr = color;
			d+=off;
			if (d>=0.5) {ptr+=w;d-=1;}
			}
		*ptr = color;
		}
	else	{
		float d=0;
		for (;ptr!=end;ptr++){
			*ptr = color;
			d+=off;
			if (d<=-0.5) {ptr-=w;d+=1;}
			}
		*ptr = color;
		}
 	}
  else  {// starke steigung
  	float off=(float)delta.x()/(delta.y());
 	if (p1.y()>p2.y()){
		QPoint h=p1;
		p1=p2;
		p2=h;
		}
 	
 	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	if (off>0){
		float d=0;
 		for (;ptr!=end;ptr+=w){
			*ptr = color;
			d+=off;
			if (d>=0.5) {ptr++;d-=1;}
			}
		*ptr = color;
		}
	else	{
		float d=0;
		for (;ptr!=end;ptr+=w){
			*ptr = color;
			d+=off;
			if (d<=-0.5) {ptr--;d+=1;}
			}
		*ptr = color;
		}
	}
}

void layoutImagePainter::drawLineFill(QPoint p1, QPoint p2)
{
  QPoint delta=p2-p1;
  if (delta.x()==0) {  
	if (delta.y()==0) {
		uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
		*ptr=color;
		return;}
	//senkrecht
	bool newDir=false;
	if (p1.y()>p2.y()) newDir=true; 
	if (newDir==dir) 
		fill->scanLine(p1.y())[p1.x()]++;
	else 
		dir=newDir;
	
 	if (p1.x()==maxX) return; 
  	if (p1.y()>p2.y()) 
		{
		QPoint h=p2;
		p2=p1;
		p1=h;
		}
	uchar *c = fill->scanLine(p1.y()) + p1.x();
	int line=fill->bytesPerLine ();
 	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
  	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p1.x();
  	for (;ptr<=end;ptr+=w){
		*ptr = color;
		(*c) ++;
		c+=line;
		}
 	}
  else if (delta.y()==0) { //waagerecht
 	if (p1.y()==0) return;
 	if (p1.y()==maxY) return; 
 	 if (p1.x()>p2.x()) 
		{
		QPoint h=p2;
		p2=p1;
		p1=h;
		}
  	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
  	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
 	 for (;ptr<=end;ptr++){
		*ptr = color;
		}
 	}
  else if (abs(delta.x())>=abs(delta.y())){ //leichte steigung
 	float off=(float)(delta.y())/(delta.x());
	bool newDir=false;
	if (p1.y()>p2.y()) newDir=true; 
	if (newDir==dir) 
		fill->scanLine(p1.y())[p1.x()]++;
	else 
		dir=newDir;
 	
	if (p1.x()>p2.x()){
		QPoint h=p1;
		p1=p2;
		p2=h;
		}
	int line=fill->bytesPerLine ();
 	uchar *c = fill->scanLine(p1.y()) + p1.x();
	(*c)++;
	c++;
 	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	//float g=0;
	if (off>0){
		float d=0;
 		for (;ptr!=end;ptr++){
			//printf("1: off %f g %f ptr %d end %d dx %d dy %d\n",off,g,ptr,end,delta.x(),delta.y());
			*ptr = color;
			d+=off;
			//g+=off;
			if (d>=0.5) {ptr+=w;d-=1;c+=line;(*c)++;}
			c++;
			}
		*ptr = color;
		}
	else	{
		float d=0;
		for (;ptr!=end;ptr++){
			//printf("2: off %f g %f ptr %d end %d dx %d dy %d\n",off,g,ptr,end,delta.x(),delta.y());
			*ptr = color;
			d+=off;
			//g+=off;
			if (d<=-0.5) {ptr-=w;d+=1;c-=line;(*c)++;}
			c++;
			}
		*ptr = color;
		}
	/*uint *pa = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *pe = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	*pe=color*256;
	*pa=color*256;*/
 	}
  else  {// starke steigung
	bool newDir=false;
	if (p1.y()>p2.y()) newDir=true; 
	if (newDir==dir) 
		fill->scanLine(p1.y())[p1.x()]++;
	else 
		dir=newDir;
  	float off=(float)delta.x()/(delta.y());
 	if (p1.y()>p2.y()){
		QPoint h=p1;
		p1=p2;
		p2=h;
		}
 	int line=fill->bytesPerLine ();
 	uchar *c = fill->scanLine(p1.y()) + p1.x();
 	uint *ptr = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *end = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	if (off>0){
		float d=0;
 		for (;ptr!=end;ptr+=w){
			*ptr = color;
			(*c)++;
			d+=off;
			if (d>=0.5) {ptr++;d-=1;c++;}
			c+=line;
			}
		*ptr = color;
		(*c)++;
		}
	else	{
		float d=0;
		for (;ptr!=end;ptr+=w){
			*ptr = color;
			(*c)++;
			d+=off;
			if (d<=-0.5) {ptr--;d+=1;c--;}
			c+=line;
			}
		*ptr = color;
		(*c)++;
		}
	/*uint *pa = reinterpret_cast<uint *>(image->scanLine(p1.y())) + p1.x();
 	uint *pe = reinterpret_cast<uint *>(image->scanLine(p2.y())) + p2.x();
	*pe=color*256*256;
	*pa=color*256*256;*/
 	}

}

QPoint layoutImagePainter::limit(QPoint p){
  QPoint p2=drawTrans.mapDraw(p);
  if (p2.x()<minX) p2.setX(minX);
  if (p2.x()>maxX) p2.setX(maxX);
  if (p2.y()<minY) p2.setY(minY);
  if (p2.y()>maxY) p2.setY(maxY);
  return p2;
}

void layoutImagePainter::drawLineLimit(QPoint p1, QPoint p2){
  if (p2.x()<minX) p2.setX(minX);
  if (p2.x()>maxX) p2.setX(maxX);
  if (p2.y()<minY) p2.setY(minY);
  if (p2.y()>maxY) p2.setY(maxY);
  if (p1.x()<minX) p1.setX(minX);
  if (p1.x()>maxX) p1.setX(maxX);
  if (p1.y()<minY) p1.setY(minY);
  if (p1.y()>maxY) p1.setY(maxY);
  drawLine(p1,p2);
}

void layoutImagePainter::drawGrid(int gridX,int gridY,int gridOffsetX, int gridOffsetY){
 if (w==0) return;
 if (h==0) return;
 QPoint p=drawTrans.mapDraw(QPoint(0,0));
 QMatrix matrixinv=drawTrans.matrix.inverted();
 QPoint p1=(raster(matrixinv.map(QPoint(0,0)),gridX,gridY,gridOffsetX,gridOffsetY));
 QPoint p2=(matrixinv.map(QPoint(w,h)));
 QPoint p3=drawTrans.mapDraw(QPoint(gridX,gridY))-p;
 //painter->setPen(setup::gridColor);
 int c=setup::gridColor.rgb();
 int c1=QColor((setup::zeroColor.red()+setup::gridColor.red())/2,(setup::zeroColor.green()+setup::gridColor.green())/2,(setup::zeroColor.blue()+setup::gridColor.blue())/2).rgb();
 int c2=QColor((setup::zeroColor.red()+3*setup::gridColor.red())/4,(setup::zeroColor.green()+3*setup::gridColor.green())/4,(setup::zeroColor.blue()+3*setup::gridColor.blue())/4).rgb();
 if ((p3.x()>7)&&(p3.y()<(-7))){
 	for (int x=p1.x();x<p2.x();x+=gridX){
 		for (int y=p1.y();y>p2.y();y-=gridY){
			QPoint p=drawTrans.mapDraw(QPoint(x,y));
			if ((p.x()>=0)&&(p.x()<w))
				if ((p.y()>=0)&&(p.y()<h)) {
			//painter->drawPoint(drawTrans.matrix.map(QPoint(x,y)));
			if ((((x/gridX)%10)==0)&&(((y/gridY)%10==0)))
				image->setPixel(p.x(),p.y(),c1);
			else if ((((x/gridX)%5)==0)&&(((y/gridY)%5==0)))
				image->setPixel(p.x(),p.y(),c2);
			else
			image->setPixel(p.x(),p.y(),c);
		
			}
		}
 	}
 }
 c=setup::zeroColor.rgb();
 if ((p.x()>=0)&&(p.x()<w)) 
   if ((p.y()>=0)&&(p.y()<h)) 
     image->setPixel(p.x(),p.y(),c);
 p+=QPoint(1,1);
 if ((p.x()>=0)&&(p.x()<w)) 
   if ((p.y()>=0)&&(p.y()<h)) 
     image->setPixel(p.x(),p.y(),c);
 p+=QPoint(-2,0);
 if ((p.x()>=0)&&(p.x()<w)) 
   if ((p.y()>=0)&&(p.y()<h)) 
     image->setPixel(p.x(),p.y(),c);
 p+=QPoint(0,-2);
 if ((p.x()>=0)&&(p.x()<w)) 
   if ((p.y()>=0)&&(p.y()<h)) 
     image->setPixel(p.x(),p.y(),c);
 p+=QPoint(2,0);
 if ((p.x()>=0)&&(p.x()<w)) 
   if ((p.y()>=0)&&(p.y()<h)) 
     image->setPixel(p.x(),p.y(),c);
/* painter->setPen(setup::zeroColor);
 painter->drawPoint(p);
 painter->drawPoint(p-QPoint(1,1));
 painter->drawPoint(p+QPoint(1,1));
 painter->drawPoint(p-QPoint(1,-1));
 painter->drawPoint(p-QPoint(-1,1));*/
 LImage->imageChanged=true;
}

QPoint layoutImagePainter::raster(QPoint pos,int gridX,int gridY,int gridOffsetX, int gridOffsetY){
  if ((gridX>1)&&(gridY>1)){
    if (pos.x()-gridOffsetX>0) {pos.setX(((pos.x()-gridOffsetX+(gridX/2))/gridX)*gridX+gridOffsetX);}
    else {pos.setX(((pos.x()-gridOffsetX-(gridX/2))/gridX)*gridX+gridOffsetX);}
    if (pos.y()-gridOffsetY>0) {pos.setY(((pos.y()-gridOffsetY+(gridY/2))/gridY)*gridY+gridOffsetY);}
    else {pos.setY(((pos.y()-gridOffsetY-(gridY/2))/gridY)*gridY+gridOffsetY);}}
  return pos;
}


void layoutImagePainter::drawText(QString s, int width,  QPoint point, strans trans,uint color){

	
 if (currentFontNum!=fontNum) 
	{	
		initFace(); 
		if (currentFontNum!=fontNum) return; 
	}
 double gr=(1.25*(double)width);
 double a=(double)(trans.angle+drawTrans.angle)/180*M_PI;
 if (!(trans.mirror_x^drawTrans.mirror_x)) a=(double)(trans.angle-drawTrans.angle)/180*M_PI;
 // if (!(e->drawTrans.mirror_x))a=-a;
  
  FT_Matrix     matrixA;
  matrixA.xx = (FT_Fixed)( cos( a ) * 0x10000L );
  matrixA.xy = (FT_Fixed)(-sin( a ) * 0x10000L );
  matrixA.yx = (FT_Fixed)( sin( a ) * 0x10000L );
  matrixA.yy = (FT_Fixed)( cos( a ) * 0x10000L );
  if ((trans.mirror_x)^ (!drawTrans.mirror_x)) {  // 
		matrixA.yy = -matrixA.yy;
		matrixA.yx = -matrixA.yx;
		}
 
  FT_Vector     pen; 
  pen.x = 0;
  pen.y = 0;
	int error = FT_Set_Pixel_Sizes(
            face,   // handle to face object 
            0,      // pixel_width           
            (int)gr);   // pixel_height          

  
  int           pen_x, pen_y, n;


  FT_Set_Transform( face, &matrixA, &pen );
  bool fallBackUsed=false;
  QPoint p=drawTrans.mapDraw(point);
  pen_x = p.x();
  pen_y = p.y();

  for ( n = 0; n < s.length();n++ )
  {
    FT_UInt  glyph_index;
    FT_Face useface=face;
    // retrieve glyph index from character code 
    glyph_index = FT_Get_Char_Index( face,(FT_ULong) s[n].unicode() );
	if (glyph_index==0){
	  if (!fallBackInitDone) initFallBackFace();
	  if (fallBackFound) {
	    if (!fallBackUsed){
	      fallBackUsed=true;
	      FT_Set_Pixel_Sizes(
            fallbackFace,   // handle to face object 
            0,      // pixel_width           
            (int)gr);
	      FT_Set_Transform( fallbackFace, &matrixA, &pen );
	    }
	    glyph_index = FT_Get_Char_Index( fallbackFace,  (FT_ULong) s[n].unicode());
	    useface=fallbackFace;
	    
	  }
	}
    FT_GlyphSlot  slot = useface->glyph;  // a small shortcut 
    // load glyph image into the slot (erase previous one) 
    error = FT_Load_Glyph( useface, glyph_index, FT_LOAD_NO_HINTING+FT_LOAD_MONOCHROME);
    if ( error )
      continue;  //ignore errors 

    // convert to an anti-aliased bitmap 

    error = FT_Render_Glyph( useface->glyph, FT_RENDER_MODE_MONO );

    if ( error )
      continue;

    // now, draw to our target surface 
	drawFTBitmap(&slot->bitmap,pen_x + slot->bitmap_left, pen_y - slot->bitmap_top, color);

    // increment pen position 
    pen_x += (slot->advance.x >> 6);

   pen_y -= (slot->advance.y >> 6); 
  }

    //FT_Matrix     matrix;  
    matrixA.xx = 0x10000L;
    matrixA.xy = 0;
    matrixA.yx = 0;
    matrixA.yy = 0x10000L;
    //FT_Vector     pen; 
    pen.x = 0;
    pen.y = 0;
    FT_Set_Transform( face, &matrixA, &pen );
    if (fallBackUsed){
      FT_Set_Transform( fallbackFace, &matrixA, &pen );
    }
//printf("dt-end\n");
 LImage->imageChanged=true;
}
