/***************************************************************************
 *   Copyright (C) 2009 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/
#include "project.h"
#include "layout.h"
#include <QMessageBox>
#ifdef netlistutility
#include "net/netlistmodule.h"
#endif

#ifdef SCHEMATIC
#include "schematic/schematic.h"
#include "schematic/schematicdisplay.h"
#endif

project project::projects[128];

project::project()
{
l=NULL;
#ifdef SCHEMATIC
s=NULL;
#endif
}


project::~project()
{
}


layout* project::newLayout(viewModeType viewonly){
#ifdef LIBCHECK
#include "../liblayout/libcheck.cpp"
if (libCheckResult) return NULL;
#endif
  int i=0;
#ifdef SCHEMATIC
  while ((projects[i].s!=NULL || projects[i].l!=NULL)&&(i<127)){i++;}
#else
  while ((projects[i].l!=NULL)&&(i<127)){i++;}
#endif
  if (i>=127) return NULL;
  projects[i].l=new layout(viewonly);
  return projects[i].l;
}

void project::closeLayout(layout *l){
  if (layout::debug) printf ("project close layout %d\n",l);
 int i=0;
  while ((projects[i].l!=l)&&(i<127)){i++;}
 //l->hide();
 if (i>=127) return;
 projects[i].l=NULL;
 //delete l;
}

layout* project::getNextLayout(layout *lay){
  int i=0;
  while ((projects[i].l!=lay)&&(i<127)){i++;}
  if (i>=127) return NULL;
  i++;
  while ((projects[i].l==NULL)) {
	i++;
	if (i==127) i=0; 
  };
  return projects[i].l;
}

#ifdef SCHEMATIC
schematic* project::getSchematic(layout *lay){
  int i=0;
  while ((projects[i].l!=lay)&&(i<127)){i++;}
  if (i>=127) {
    i=0;
    while (((projects[i].l!=NULL)||(projects[i].s!=NULL))&&(i<127)){i++;}
    if (i>=127) return NULL;
    projects[i].l=lay;
  }
  if (projects[i].s==NULL) {
	//projects[i].s=new schematic();// avoid error on schematic creation in macros
	projects[i].s=projects[i].l->createSchematic();
	link(projects[i].l,projects[i].s);
	}
  return projects[i].s;
}

bool project::hasSchematic(layout *lay){
  int i=0;
  while ((projects[i].l!=lay)&&(i<127)){i++;}
  if (i>=127)  return false;
  if (projects[i].s==NULL) return false;
  return true;
}

layout* project::getLayout(schematic *s){
  int i=0;
  while ((projects[i].s!=s)&&(i<127)){i++;}
  if (i>=127)  {
    i=0;
    while (((projects[i].l!=NULL)||(projects[i].s!=NULL))&&(i<127)){i++;}
    if (i>=127) return NULL;
    projects[i].s=s;
  }
  if (projects[i].l==NULL) {
	projects[i].l=new layout();
	link(projects[i].l,projects[i].s);
	}
  return projects[i].l;
}

schematic* project::newSchematic(){
  int i=0;
  while ((projects[i].s!=NULL || projects[i].l!=NULL)&&(i<127)){i++;}
  if (i>=127) return NULL;
  projects[i].s=new schematic();
  return projects[i].s;
}

void project::closeSchematic(schematic *s){
 int i=0;
  while ((projects[i].s!=s)&&(i<127)){i++;}
 //l->hide();
  if (i>=127) return ;
  projects[i].s=NULL;
 //delete l;
}

void project::link(layout *lay,schematic *sch){
//printf("link\n");
connect (sch,SIGNAL(newCurrentSheet(const QString &)),lay->drawing,SLOT(setCellGui(const QString &)));
connect (lay,SIGNAL(newCurrentCell(const QString &)),sch->drawing,SLOT(setSheetGui(const QString &)));
connect (sch->drawing,SIGNAL(currentNetlistChange(QString,netList *)),lay->netlistTool,SLOT(setNetlist(QString ,netList *)));
connect (sch->drawing,SIGNAL(currentNetlistConnectionsChange(QString,netList *)),lay->netlistTool,SLOT(setNetlistConnections(QString ,netList *)));

connect (sch->drawing,SIGNAL(deviceChanged(QString,QString,componentPlacement *)),lay->netlistTool,SLOT(changeDevice(QString,QString,componentPlacement *)));
connect (sch->drawing,SIGNAL(processDevice(QString,QString)),lay->netlistTool,SLOT(processDevice(QString,QString)));
connect (sch->drawing,SIGNAL(processNode(QString,int)),lay->netlistTool,SLOT(processNode(QString,int)));
connect (lay->drawing,SIGNAL(removeAllCells()),sch->drawing,SLOT(cleanCellnames()));
//connect (sch,SIGNAL(),lay->netlistTool,SLOT());
connect (lay->netlistTool,SIGNAL(showDevice(QString)),sch->drawing,SLOT(showDevice(QString)));
connect (lay->netlistTool,SIGNAL(showNode(QString)),sch->drawing,SLOT(showNode(QString)));
}

#endif
