/***************************************************************************
 *   Copyright (C) 2006 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef USERUNITSVALIDATOR_H
#define USERUNITSVALIDATOR_H

#include <QValidator>

/**
@author Juergen Thies
*/
class userunitsValidator : public QValidator
{
    Q_OBJECT

public:
    explicit userunitsValidator(QObject * parent);
    userunitsValidator(double userunits, QObject * parent);
    ~userunitsValidator();

    QValidator::State validate(QString &, int &) const;

    void setUserunits(double);
    void setDecimals(int);

    double userunits() const { return uunit; }
    int decimals() const { return d; }


private:
    int d;
    double uunit;
    void calDecimals();


};


#endif
