/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "general/drawingfield.h"

#include "background/backgroundmodule.h"




void macro::backgroundModuleHandler_registerKeywords(keywords **keyword_){
  *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="backgroundModule";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::backgroundModuleHandler_typeHandler;
}

void macro::backgroundModuleHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrBackgroundModule,ptrBackgroundModule,single);
}

returnValue macro::backgroundModuleHandler_classHandler(int *counter, keywords *keyword_,returnValue *r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (r->type==ptrBackgroundModule){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else throw 1;
 backgroundModule *d= r->getBackgroundModule();
 p=next(counter);
 // methods
 if (((p.type==keyword)&&(p.value=="addBackground"))) { testParenOpen(counter);
		returnValue p1=calculate(counter,keyword_); testParenClose(counter);
		ret.setInt(d->addBackground(p1.getString()));}
 else if (((p.type==keyword)&&(p.value=="clearBackground"))) { testParenOpen(counter);
	testParenClose(counter);
	d->clearBackground();}
 else if (((p.type==keyword)&&(p.value=="backgroundOffset"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);
	testParenClose(counter);
	d->backgroundOffset(p1.getInt(),p2.getDouble(),p3.getDouble());}
 else if (((p.type==keyword)&&(p.value=="backgroundScale"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);
	testParenClose(counter);
	d->backgroundScale(p1.getInt(),p2.getDouble(),p3.getDouble());}  
 else if (((p.type==keyword)&&(p.value=="backgroundShear"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);
	testParenClose(counter);
	d->backgroundShear(p1.getInt(),p2.getDouble(),p3.getDouble());}  
 else if (((p.type==keyword)&&(p.value=="backgroundRotate"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);
	testParenClose(counter);
	d->backgroundRotate(p1.getInt(),p2.getDouble());}
 else if (((p.type==keyword)&&(p.value=="backgroundOffsetGetX"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testParenClose(counter);
	ret.setDouble(d->backgroundOffsetGetX(p1.getInt()));}  
 else if (((p.type==keyword)&&(p.value=="backgroundOffsetGetY"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testParenClose(counter);
	ret.setDouble(d->backgroundOffsetGetY(p1.getInt()));} 
 else if (((p.type==keyword)&&(p.value=="backgroundScaleGetX"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testParenClose(counter);
	ret.setDouble(d->backgroundScaleGetX(p1.getInt()));} 
 else if (((p.type==keyword)&&(p.value=="backgroundScaleGetY"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testParenClose(counter);
	ret.setDouble(d->backgroundScaleGetY(p1.getInt()));} 
 else if (((p.type==keyword)&&(p.value=="backgroundShearGetX"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testParenClose(counter);
	ret.setDouble(d->backgroundShearGetX(p1.getInt()));} 
 else if (((p.type==keyword)&&(p.value=="backgroundShearGetY"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testParenClose(counter);
	ret.setDouble(d->backgroundShearGetY(p1.getInt()));} 
 else if (((p.type==keyword)&&(p.value=="backgroundRotateGet"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testParenClose(counter);
	ret.setDouble(d->backgroundRotateGet(p1.getInt()));} 
 else if (((p.type==keyword)&&(p.value=="vectorizePixel"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);
	testParenClose(counter);
	d->vectorizePixel(p1.getInt());} 
 else if (((p.type==keyword)&&(p.value=="vectorizeThreshold"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);
	testParenClose(counter);
	d->vectorizeThreshold(p1.getInt());} 
 else if (((p.type==keyword)&&(p.value=="centerView"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);
	testParenClose(counter);
	d->centerView(p1.getInt());} 
 else if (((p.type==keyword)&&(p.value=="setShapeColorRange"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);
	testParenClose(counter);
	d->setShapeColorRange(p1.getInt());} 
 else if (((p.type==keyword)&&(p.value=="setBackgroundColorRange"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);
	testParenClose(counter);
	d->setBackgroundColorRange(p1.getInt());} 
 else if (((p.type==keyword)&&(p.value=="setIgnorePixel"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);
	testParenClose(counter);
	d->setIgnorePixel(p1.getInt());} 
 else if (((p.type==keyword)&&(p.value=="setThreshold"))) { testParenOpen(counter);
	returnValue p2=calculate(counter,keyword_);
	testParenClose(counter);
	d->setThreshold(p2.getDouble());}  
 else if (((p.type==keyword)&&(p.value=="setRisingThreshold"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);
	testParenClose(counter);
	d->setRisingThreshold(p1.getBool());}  
 else if (((p.type==keyword)&&(p.value=="setShapeColor"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);
	testParenClose(counter);
	d->setShapeColor(p1.getInt(),p2.getInt(),p3.getInt());}  
 else if (((p.type==keyword)&&(p.value=="setBackgroundColor"))) { testParenOpen(counter);
        returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);
	testParenClose(counter);
	d->setBackgroundColor(p1.getInt(),p2.getInt(),p3.getInt());}  
 else if (((p.type==keyword)&&(p.value=="hide"))) { testParenOpen(counter);
	returnValue p2=calculate(counter,keyword_);
	testParenClose(counter);
	d->hide(p2.getInt());} 
 else if (((p.type==keyword)&&(p.value=="show"))) { testParenOpen(counter);
	returnValue p2=calculate(counter,keyword_);
	testParenClose(counter);
	d->show(p2.getInt());} 
 else if (((p.type==keyword)&&(p.value=="showCell"))) { testParenOpen(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);
	testParenClose(counter);
	d->showCell(p2.getInt(),p3.getString());} 
 else if (((p.type==keyword)&&(p.value=="hideAll"))) { testParenOpen(counter);
	testParenClose(counter);
	d->hideAll();} 
 else if (((p.type==keyword)&&(p.value=="showAll"))) { testParenOpen(counter);
	testParenClose(counter);
	d->showAll();} 
 else if (((p.type==keyword)&&(p.value=="showAllCell"))) { testParenOpen(counter);
	returnValue p3=calculate(counter,keyword_);
	testParenClose(counter);
	d->showAllCell(p3.getString());} 
 else if (((p.type==keyword)&&(p.value=="setAnchor"))) { testParenOpen(counter);
	returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);
	testParenClose(counter);
	d->setAnchor(p1.getInt(),p2.getDouble(),p3.getDouble());} 
 else if (((p.type==keyword)&&(p.value=="setAnchorCenter"))) { testParenOpen(counter);
	returnValue p3=calculate(counter,keyword_);
	testParenClose(counter);
	d->setAnchorCenter(p3.getInt());} 
 else if (((p.type==keyword)&&(p.value=="setAnchorTopLeft"))) { testParenOpen(counter);
	returnValue p3=calculate(counter,keyword_);
	testParenClose(counter);
	d-> setAnchorTopLeft(p3.getInt());} 
 else if (((p.type==keyword)&&(p.value=="setImageAnchor"))) { testParenOpen(counter);
	returnValue p1=calculate(counter,keyword_);testComma(counter);
	returnValue p2=calculate(counter,keyword_);testComma(counter);
	returnValue p3=calculate(counter,keyword_);
	testParenClose(counter);
	d->setImageAnchor(p1.getInt(),p2.getInt(),p3.getInt());} 
 else {
  	error->addItem(tr("Class backgroundmodul has no member ")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}



