/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "menuaction.h"
#include <QKeyEvent>
#include "layout.h"
#include <QWhatsThis>
#include <QEvent>
#include "mainwindow.h"
#include "dialog/helpwindow.h"

menuAction::menuAction( )
 : QMenu()
{
  setAttribute(Qt::WA_CustomWhatsThis,false);
  setWhatsThis("CategoryFeature");
 

}




menuAction::~menuAction()
{
}



bool menuAction::event( QEvent *e){
  //printf("event %d\n",e->type());
   if (e->type() == QEvent::WhatsThis ) {
	   // printf("triggert\n");
	   QString help="";
	   QHelpEvent * ke = reinterpret_cast<QHelpEvent *>( e);
	   if (ke==NULL) return false;
	   QAction *a=actionAt(ke->pos());
	   if (a!=NULL){
	     help=a->whatsThis();
	     if (help=="") help=a->text();
	     if (help=="") help=a->toolTip();
	     if (help=="") help=whatsThis();
	   }
	   else help=whatsThis();
	   layout::helpwindow->showHelp(help);
	   QWhatsThis::leaveWhatsThisMode ();
            e->accept();
	    hide();
	    return true;
            }
		//printf("key:%d type: %d\n",ke->key(),e->type());

    
return QMenu::event(e);
}
