/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "poswidget.h"

#include <qimage.h>
#include <qstatusbar.h>
#include <qpainter.h>
//#include <q3paintdevicemetrics.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qstring.h>
//#include <q3whatsthis.h>
#include "icons/xyicon.xpm"
#include "dialog/helpwindow.h"
#include "layout.h"
#include <QMenu>

poswidget::poswidget(class layout *la,QWidget *parent, const char *)
 : QWidget(parent)
{
  l=la;
QString s=tr("This bar indicates the position of the mouse.");
posIcon=new QLabel(this);
posIcon->setWhatsThis(s);
posNumber=new QLabel(this);
posNumber->setWhatsThis(s);
xyIcon = QPixmap(xyicon);
posIcon->setPixmap(xyIcon);
posNumber->setText("");
setNormal();
}

void poswidget::setSmall(){
setFixedSize(180,17);
posIcon->setGeometry(0,0,20,17);
posNumber->setGeometry(20,0,160,17);
}

void poswidget::setNormal(){
setFixedSize(250,17);
posIcon->setGeometry(0,0,20,17);
posNumber->setGeometry(20,0,230,17);
}
void poswidget::setWide(){
setFixedSize(350,17);
posIcon->setGeometry(0,0,20,17);
posNumber->setGeometry(20,0,330,17);
}
    
poswidget::~poswidget()
{
}


void poswidget::setPos( QString s){
  posNumber->setText(s);
}

void poswidget::mousePressEvent ( QMouseEvent * event ){
  if (event->button()!=Qt::LeftButton) return;
  //if (event->pos().x()<gridNumber->x()) return;
  l->commandlineActivate();
}

void poswidget::contextMenuEvent ( QContextMenuEvent * event) {
  if (QApplication::keyboardModifiers ()!=Qt::NoModifier) {event->ignore();return;}
  //printf("content menu requested\n");
#ifdef FULL_VERSION
QMenu menu;

menu.addAction(helpWindow::getIcon(setUserunitsHelp),helpWindow::getMenuname(setUserunitsHelp),l,SLOT(chooseUserunits()));

//menu.addSeparator();
// menu.addAction(helpWindow::getIcon(layerManagerHelp),helpWindow::getMenuname(layerManagerHelp),parent(),SLOT(openLayerManager()));
// reset layer
// restore layer
// store layer as
// menu.addSeparator();
//menu.addAction(helpWindow::getIcon(layerManagerHelp),helpWindow::getMenuname(layerManagerHelp),parent(),SLOT(openLayerManager()));
// layer setup ???
menu.exec(QCursor::pos());
#endif
}

