/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SHORTKEYBUTTON_H
#define SHORTKEYBUTTON_H
#include <QEvent>
#include <QKeyEvent>
#include <qpushbutton.h>
#include "general/layers.h"
#include <qwidget.h>
#include <qpixmap.h>
#include "widgets/shortkey.h"
/**
@author Juergen Thies
*/
class shortKeyButton : public QPushButton, private shortKey
{
Q_OBJECT

public:
    shortKeyButton( QWidget *parrent);

    ~shortKeyButton();

public:

    void setShortKey(QString sk);
    QString getShortKey();
private:
 QString sk;
 bool input;
 void focusOutEvent ( QFocusEvent * event );
private slots:
 void activate();
protected:
  bool eventFilter(QObject *obj, QEvent *event);
};

#endif
